/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbaudoin.yamllint.rules;

import com.github.sbaudoin.yamllint.LintProblem;
import com.github.sbaudoin.yamllint.rules.TokenRule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.tokens.ScalarToken;
import org.yaml.snakeyaml.tokens.TagToken;
import org.yaml.snakeyaml.tokens.Token;

public class Truthy
extends TokenRule {
    private static final List<String> TRUTHY_TOKENS = Arrays.asList("YES", "Yes", "yes", "NO", "No", "no", "TRUE", "True", "FALSE", "False", "ON", "On", "on", "OFF", "Off", "off");

    @Override
    public List<LintProblem> check(Map<Object, Object> conf, Token token, Token prev, Token next, Token nextnext, Map<String, Object> context) {
        ArrayList<LintProblem> problems = new ArrayList<LintProblem>();
        if (prev instanceof TagToken) {
            return problems;
        }
        if (token instanceof ScalarToken && TRUTHY_TOKENS.stream().anyMatch(truthy -> truthy.equals(((ScalarToken)token).getValue())) && ((ScalarToken)token).getStyle().getChar() == null) {
            problems.add(new LintProblem(token.getStartMark().getLine() + 1, token.getStartMark().getColumn() + 1, "truthy value should be true or false"));
        }
        return problems;
    }
}

