/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbridges.ephemeralfs;

import com.github.sbridges.ephemeralfs.FileAttributesSnapshot;
import com.github.sbridges.ephemeralfs.FileAttributesViewBuilder;
import java.io.IOException;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;

enum Attribute {
    BASIC_CREATION_TIME("creationTime"){

        @Override
        public Object read(FileAttributesViewBuilder view) throws IOException {
            return view.build(BasicFileAttributeView.class).readAttributes().creationTime();
        }

        @Override
        public void write(FileAttributesViewBuilder view, String fullName, Object value) throws IOException {
            view.build(BasicFileAttributeView.class).setTimes(null, null, (FileTime)value);
        }
    }
    ,
    BASIC_FILE_KEY("fileKey"){

        @Override
        public Object read(FileAttributesViewBuilder view) throws IOException {
            if (view.fs.getSettings().isWindows()) {
                return null;
            }
            return view.build(BasicFileAttributeView.class).readAttributes().fileKey();
        }
    }
    ,
    BASIC_IS_DIRECTORY("isDirectory"){

        @Override
        public Object read(FileAttributesViewBuilder view) throws IOException {
            return view.build(BasicFileAttributeView.class).readAttributes().isDirectory();
        }
    }
    ,
    BASIC_IS_OTHER("isOther"){

        @Override
        public Object read(FileAttributesViewBuilder view) throws IOException {
            return view.build(BasicFileAttributeView.class).readAttributes().isOther();
        }
    }
    ,
    BASIC_IS_REGULAR_FILE("isRegularFile"){

        @Override
        public Object read(FileAttributesViewBuilder view) throws IOException {
            return view.build(BasicFileAttributeView.class).readAttributes().isRegularFile();
        }
    }
    ,
    BASIC_IS_SYMBOLIC_LINK("isSymbolicLink"){

        @Override
        public Object read(FileAttributesViewBuilder view) throws IOException {
            return view.build(BasicFileAttributeView.class).readAttributes().isSymbolicLink();
        }
    }
    ,
    BASIC_LAST_ACCESS_TIME("lastAccessTime"){

        @Override
        public Object read(FileAttributesViewBuilder view) throws IOException {
            return view.build(BasicFileAttributeView.class).readAttributes().lastAccessTime();
        }

        @Override
        public void write(FileAttributesViewBuilder view, String fullName, Object value) throws IOException {
            view.build(BasicFileAttributeView.class).setTimes(null, (FileTime)value, null);
        }
    }
    ,
    BASIC_LAST_MODIFIED_TIME("lastModifiedTime"){

        @Override
        public Object read(FileAttributesViewBuilder view) throws IOException {
            return view.build(BasicFileAttributeView.class).readAttributes().lastModifiedTime();
        }

        @Override
        public void write(FileAttributesViewBuilder view, String fullName, Object value) throws IOException {
            view.build(BasicFileAttributeView.class).setTimes((FileTime)value, null, null);
        }
    }
    ,
    BASIC_SIZE("size"){

        @Override
        public Object read(FileAttributesViewBuilder view) throws IOException {
            return view.build(BasicFileAttributeView.class).readAttributes().size();
        }
    }
    ,
    DOS_ARCHIVE("archive"){

        @Override
        public Object read(FileAttributesViewBuilder view) throws IOException {
            return view.build(DosFileAttributeView.class).readAttributes().isArchive();
        }

        @Override
        public void write(FileAttributesViewBuilder view, String fullName, Object value) throws IOException {
            view.build(DosFileAttributeView.class).setArchive((Boolean)value);
        }
    }
    ,
    DOS_IS_HIDDEN("hidden"){

        @Override
        public Object read(FileAttributesViewBuilder view) throws IOException {
            return view.build(DosFileAttributeView.class).readAttributes().isHidden();
        }

        @Override
        public void write(FileAttributesViewBuilder view, String fullName, Object value) throws IOException {
            view.build(DosFileAttributeView.class).setHidden((Boolean)value);
        }
    }
    ,
    DOS_IS_READ_ONLY("readonly"){

        @Override
        public Object read(FileAttributesViewBuilder view) throws IOException {
            return view.build(DosFileAttributeView.class).readAttributes().isReadOnly();
        }

        @Override
        public void write(FileAttributesViewBuilder view, String fullName, Object value) throws IOException {
            view.build(DosFileAttributeView.class).setReadOnly((Boolean)value);
        }
    }
    ,
    DOS_SYSTEM("system"){

        @Override
        public Object read(FileAttributesViewBuilder view) throws IOException {
            return view.build(DosFileAttributeView.class).readAttributes().isSystem();
        }

        @Override
        public void write(FileAttributesViewBuilder view, String fullName, Object value) throws IOException {
            view.build(DosFileAttributeView.class).setSystem((Boolean)value);
        }
    }
    ,
    OWNER_OWNER("owner"){

        @Override
        public Object read(FileAttributesViewBuilder view) throws IOException {
            return view.snapshotProperties().getOwner();
        }

        @Override
        public void write(FileAttributesViewBuilder view, String fullName, Object value) throws IOException {
            view.build(FileOwnerAttributeView.class).setOwner((UserPrincipal)value);
        }
    }
    ,
    POSIX_GROUP("group"){

        @Override
        public Object read(FileAttributesViewBuilder view) throws IOException {
            return view.snapshotProperties().getGroup();
        }
    }
    ,
    POSIX_PERMISSIONS("permissions"){

        @Override
        public Object read(FileAttributesViewBuilder view) throws IOException {
            return view.snapshotProperties().permissions();
        }
    }
    ,
    UNIX_CTIME("ctime"){

        @Override
        public Object read(FileAttributesViewBuilder view) throws IOException {
            return view.snapshotProperties().lastModifiedTime();
        }
    }
    ,
    UNIX_GID("gid"){

        @Override
        public Object read(FileAttributesViewBuilder view) throws IOException {
            return view.snapshotProperties().getGroup().getGid();
        }
    }
    ,
    UNIX_INO("ino"){

        @Override
        public Object read(FileAttributesViewBuilder view) throws IOException {
            return view.snapshotProperties().getINodeNumber();
        }
    }
    ,
    UNIX_MODE("mode"){

        @Override
        public Object read(FileAttributesViewBuilder view) throws IOException {
            FileAttributesSnapshot snapshotProperties = view.snapshotProperties();
            int mode = 0;
            if (snapshotProperties.isRegularFile()) {
                mode += 32768;
            } else if (snapshotProperties.isDirectory()) {
                mode += 16384;
            } else if (snapshotProperties.isSymbolicLink()) {
                mode += 40960;
            } else {
                throw new IllegalStateException();
            }
            block11: for (PosixFilePermission perm : snapshotProperties.permissions()) {
                switch (perm) {
                    case OWNER_READ: {
                        mode += 256;
                        continue block11;
                    }
                    case OWNER_WRITE: {
                        mode += 128;
                        continue block11;
                    }
                    case OWNER_EXECUTE: {
                        mode += 64;
                        continue block11;
                    }
                    case GROUP_READ: {
                        mode += 32;
                        continue block11;
                    }
                    case GROUP_WRITE: {
                        mode += 16;
                        continue block11;
                    }
                    case GROUP_EXECUTE: {
                        mode += 8;
                        continue block11;
                    }
                    case OTHERS_READ: {
                        mode += 4;
                        continue block11;
                    }
                    case OTHERS_WRITE: {
                        mode += 2;
                        continue block11;
                    }
                    case OTHERS_EXECUTE: {
                        ++mode;
                        continue block11;
                    }
                }
                throw new IllegalStateException("unrecognized:" + (Object)((Object)perm));
            }
            return mode;
        }
    }
    ,
    UNIX_NLINK("nlink"){

        @Override
        public Object read(FileAttributesViewBuilder view) throws IOException {
            return view.snapshotProperties().getNLink();
        }
    }
    ,
    UNIX_RDEV("rdev"){

        @Override
        public Object read(FileAttributesViewBuilder view) throws IOException {
            return 0L;
        }
    }
    ,
    UNIX_UID("uid"){

        @Override
        public Object read(FileAttributesViewBuilder view) throws IOException {
            return view.snapshotProperties().getOwner().getUid();
        }
    };

    private final String name;

    private Attribute(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public abstract Object read(FileAttributesViewBuilder var1) throws IOException;

    public void write(FileAttributesViewBuilder view, String fullName, Object value) throws IOException {
        throw new IllegalArgumentException("'" + fullName + "' not recognized");
    }
}

