/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbridges.ephemeralfs;

import com.github.sbridges.ephemeralfs.Attribute;
import com.github.sbridges.ephemeralfs.AttributeSet;
import com.github.sbridges.ephemeralfs.FileAttributesViewBuilder;
import java.io.IOException;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.PosixFileAttributeView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class AttributeLookup {
    private final Map<String, AttributeSet> attributeSets;

    public AttributeLookup(AttributeSet ... attributeSets) {
        HashMap<String, AttributeSet> attributeSetsMap = new HashMap<String, AttributeSet>();
        for (AttributeSet attributeSet : attributeSets) {
            if (attributeSetsMap.put(attributeSet.getName(), attributeSet) == null) continue;
            throw new IllegalStateException("duplicate:" + attributeSet.getName());
        }
        this.attributeSets = Collections.unmodifiableMap(attributeSetsMap);
    }

    public List<Attribute> getMultiple(String attributes) {
        String rest;
        String view;
        if (!attributes.matches("([a-zA-Z]+:)?[a-zA-Z*]+(,[a-zA-Z*]+)*")) {
            throw new IllegalArgumentException("invalid attribute:" + attributes);
        }
        HashSet<Attribute> answer = new HashSet<Attribute>();
        if (attributes.contains(":")) {
            int index = attributes.indexOf(58);
            view = attributes.substring(0, index);
            rest = attributes.substring(index + 1, attributes.length());
        } else {
            view = "basic";
            rest = attributes;
        }
        if (!this.attributeSets.containsKey(view)) {
            throw new UnsupportedOperationException("View '" + view + "' not available");
        }
        AttributeSet attributeSet = this.attributeSets.get(view);
        for (String name : rest.split(",")) {
            if (name.isEmpty()) continue;
            if (name.equals("*")) {
                answer.addAll(attributeSet.getAll());
                continue;
            }
            if (!attributeSet.contains(name)) {
                throw new IllegalArgumentException("'" + name + "' not recognized");
            }
            answer.add(attributeSet.get(name));
        }
        return new ArrayList<Attribute>(answer);
    }

    public Attribute getSingle(String name) {
        return this.getSingleInternal((String)name).attribute;
    }

    private NamedAttribute getSingleInternal(String name) {
        String att;
        String view;
        if (!name.matches("([a-zA-Z]+:)?[a-zA-Z]+")) {
            throw new IllegalArgumentException("invalid attribute:" + name);
        }
        if (name.contains(":")) {
            int index = name.indexOf(58);
            view = name.substring(0, index);
            att = name.substring(index + 1, name.length());
        } else {
            view = "basic";
            att = name;
        }
        if (!this.attributeSets.containsKey(view)) {
            throw new IllegalArgumentException("View '" + view + "' not recognized");
        }
        AttributeSet attributeSet = this.attributeSets.get(view);
        if (!attributeSet.contains(att)) {
            throw new UnsupportedOperationException("'" + name + "' not recognized");
        }
        return new NamedAttribute(view + ":" + att, attributeSet.get(att));
    }

    public Set<String> getViews() {
        return Collections.unmodifiableSet(this.attributeSets.keySet());
    }

    public boolean supportsFileAttributeView(Class<? extends FileAttributeView> type) {
        String name = "notFound";
        if (type == BasicFileAttributeView.class) {
            name = "basic";
        } else if (type == DosFileAttributeView.class) {
            name = "dos";
        } else if (type == PosixFileAttributeView.class) {
            name = "posix";
        } else if (type == FileOwnerAttributeView.class) {
            name = "owner";
        }
        return this.attributeSets.containsKey(name);
    }

    public void write(String attribute, FileAttributesViewBuilder builder, Object value) throws IOException {
        NamedAttribute namedAttribute = this.getSingleInternal(attribute);
        namedAttribute.attribute.write(builder, namedAttribute.name, value);
    }

    static class NamedAttribute {
        final String name;
        final Attribute attribute;

        public NamedAttribute(String name, Attribute attribute) {
            this.name = name;
            this.attribute = attribute;
        }
    }
}

