/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbridges.ephemeralfs;

import com.github.sbridges.ephemeralfs.Attribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class AttributeSet {
    private final Map<String, Attribute> attributes;
    private final String name;
    public static final AttributeSet BASIC = new AttributeSet("basic", null, Attribute.BASIC_CREATION_TIME, Attribute.BASIC_FILE_KEY, Attribute.BASIC_IS_DIRECTORY, Attribute.BASIC_IS_OTHER, Attribute.BASIC_IS_REGULAR_FILE, Attribute.BASIC_IS_SYMBOLIC_LINK, Attribute.BASIC_LAST_ACCESS_TIME, Attribute.BASIC_LAST_MODIFIED_TIME, Attribute.BASIC_SIZE);
    public static final AttributeSet DOS = new AttributeSet("dos", BASIC, Attribute.DOS_ARCHIVE, Attribute.DOS_IS_HIDDEN, Attribute.DOS_IS_READ_ONLY, Attribute.DOS_SYSTEM);
    public static final AttributeSet OWNER = new AttributeSet("owner", BASIC, Attribute.OWNER_OWNER);
    public static final AttributeSet POSIX = new AttributeSet("posix", BASIC, Attribute.POSIX_GROUP, Attribute.OWNER_OWNER, Attribute.POSIX_PERMISSIONS);
    public static final AttributeSet UNIX = new AttributeSet("unix", POSIX, Attribute.UNIX_CTIME, Attribute.UNIX_GID, Attribute.UNIX_INO, Attribute.UNIX_MODE, Attribute.UNIX_NLINK, Attribute.UNIX_RDEV, Attribute.UNIX_UID);

    private AttributeSet(String name, AttributeSet parent, Attribute ... attributes) {
        this.name = name;
        HashMap<String, Attribute> attributeMap = new HashMap<String, Attribute>();
        if (parent != null) {
            attributeMap.putAll(parent.attributes);
        }
        for (Attribute attribute : attributes) {
            if (attributeMap.put(attribute.getName(), attribute) == null) continue;
            throw new IllegalStateException("dupe:" + attribute.getName());
        }
        this.attributes = Collections.unmodifiableMap(attributeMap);
    }

    public String getName() {
        return this.name;
    }

    public boolean contains(String name) {
        return this.attributes.containsKey(name);
    }

    public Attribute get(String name) {
        return this.attributes.get(name);
    }

    public Collection<Attribute> getAll() {
        return this.attributes.values();
    }
}

