/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbridges.ephemeralfs;

import com.github.sbridges.ephemeralfs.EphemeralFsFileSystem;
import com.github.sbridges.ephemeralfs.EphemeralFsPath;
import java.io.PrintWriter;
import java.io.StringWriter;

class CloseTracker {
    private final Exception openStackTrace;
    private final EphemeralFsFileSystem fs;
    private final EphemeralFsPath path;
    private final Class<?> type;

    public CloseTracker(Class<?> type, EphemeralFsFileSystem fs, EphemeralFsPath path) {
        this.path = path;
        this.fs = fs;
        this.type = type;
        this.openStackTrace = fs.getSettings().getRecordStackTracesOnOpen() ? new Exception("Open stack trace") : null;
    }

    public void onClose() {
        this.fs.closed(this);
    }

    public String getErrorString() {
        if (this.openStackTrace == null) {
            return this.type.getSimpleName() + " for path:" + this.path + " no stack trace captured";
        }
        StringWriter buffer = new StringWriter();
        PrintWriter writer = new PrintWriter(buffer);
        this.openStackTrace.printStackTrace(writer);
        writer.flush();
        String error = buffer.toString().trim();
        error = error.replaceAll("\n", "\n        >");
        return this.type.getSimpleName() + " for path:" + this.path + " created with stack trace:\n" + error;
    }
}

