/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbridges.ephemeralfs;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

class DefaultAsyncThreadPoolHolder {
    private static final String THREAD_FACTORY_PROP = System.getProperty("java.nio.channels.DefaultThreadPool.threadFactory");
    private static final String INITIAL_SIZE_PROP = System.getProperty("java.nio.channels.DefaultThreadPool.initialSize");
    private final Object lock = new Object();
    private boolean closed = false;
    private ExecutorService executor;

    DefaultAsyncThreadPoolHolder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorService getThreadPool() {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw new IllegalStateException("already closed!");
            }
            if (this.executor != null) {
                return this.executor;
            }
            try {
                if (INITIAL_SIZE_PROP != null) {
                    Integer.parseInt(INITIAL_SIZE_PROP);
                }
            }
            catch (Exception e) {
                throw new Error("Invalid prop for system property:java.nio.channels.DefaultThreadPool.initialSize, value:" + INITIAL_SIZE_PROP, e);
            }
            ThreadFactory factory = DefaultAsyncThreadPoolHolder.daemonThreadFactory();
            if (THREAD_FACTORY_PROP != null) {
                try {
                    factory = (ThreadFactory)Class.forName(THREAD_FACTORY_PROP).newInstance();
                }
                catch (Exception e) {
                    throw new Error(e);
                }
            }
            this.executor = Executors.newCachedThreadPool(factory);
            return this.executor;
        }
    }

    private static ThreadFactory daemonThreadFactory() {
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread answer = new Thread(r);
                answer.setDaemon(true);
                return answer;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.executor != null) {
                this.executor.shutdown();
            }
            this.closed = true;
        }
    }
}

