/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbridges.ephemeralfs;

import com.github.sbridges.ephemeralfs.EphemeralFsPath;
import com.github.sbridges.ephemeralfs.FilePermissions;
import com.github.sbridges.ephemeralfs.FileProperties;
import com.github.sbridges.ephemeralfs.INode;

class DirectoryEntry {
    private final INode destination;
    private final EphemeralFsPath symbolicLink;
    private final FileProperties linkProperties;

    public DirectoryEntry(EphemeralFsPath link) {
        this.destination = null;
        this.symbolicLink = link;
        this.linkProperties = new FileProperties(link.fs, FilePermissions.createDefaultSymlink(), false);
    }

    public DirectoryEntry(INode destination) {
        this.destination = destination;
        this.symbolicLink = null;
        this.linkProperties = null;
    }

    public EphemeralFsPath getSymbolicLink() {
        return this.symbolicLink;
    }

    public boolean isSymbolicLink() {
        return this.symbolicLink != null;
    }

    public INode getDestination() {
        return this.destination;
    }

    public FileProperties getLinkProperties() {
        return this.linkProperties;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DirectoryEntry[destination=");
        builder.append(this.destination);
        builder.append(", symbolicLink=");
        builder.append(this.symbolicLink);
        builder.append(", linkProperties=");
        builder.append(this.linkProperties);
        builder.append("]");
        return builder.toString();
    }
}

