/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbridges.ephemeralfs;

import com.github.sbridges.ephemeralfs.EphemeralFsFileChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.channels.FileLock;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;

class EphemeralFsAsynchronousFileChannel
extends AsynchronousFileChannel {
    private final EphemeralFsFileChannel channel;
    private final Executor executor;

    EphemeralFsAsynchronousFileChannel(EphemeralFsFileChannel channel, Executor executor) {
        if (channel == null) {
            throw new NullPointerException("channel is null");
        }
        if (executor == null) {
            throw new NullPointerException("executor is null");
        }
        this.executor = executor;
        this.channel = channel;
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public long size() throws IOException {
        return this.channel.size();
    }

    @Override
    public AsynchronousFileChannel truncate(long size) throws IOException {
        this.channel.truncate(size);
        return this;
    }

    @Override
    public void force(boolean metaData) throws IOException {
        this.channel.force(metaData);
    }

    @Override
    public <A> void lock(final long position, final long size, final boolean shared, final A attachment, final CompletionHandler<FileLock, ? super A> handler) {
        if (handler == null) {
            throw new NullPointerException("handler is null");
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    handler.completed(EphemeralFsAsynchronousFileChannel.this.channel.lock(position, size, shared), attachment);
                }
                catch (Exception e) {
                    handler.failed(e, attachment);
                }
            }
        });
    }

    @Override
    public Future<FileLock> lock(final long position, final long size, final boolean shared) {
        return this.submit(new Callable<FileLock>(){

            @Override
            public FileLock call() throws Exception {
                return EphemeralFsAsynchronousFileChannel.this.channel.tryLock(EphemeralFsAsynchronousFileChannel.this, position, size, shared);
            }
        });
    }

    @Override
    public FileLock tryLock(long position, long size, boolean shared) throws IOException {
        return this.channel.tryLock(this, position, size, shared);
    }

    @Override
    public <A> void read(final ByteBuffer dst, final long position, final A attachment, final CompletionHandler<Integer, ? super A> handler) {
        if (handler == null) {
            throw new NullPointerException("handler is null");
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    handler.completed(EphemeralFsAsynchronousFileChannel.this.channel.read(dst, position), attachment);
                }
                catch (Exception e) {
                    handler.failed(e, attachment);
                }
            }
        });
    }

    @Override
    public Future<Integer> read(final ByteBuffer dst, final long position) {
        return this.submit(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return EphemeralFsAsynchronousFileChannel.this.channel.read(dst, position);
            }
        });
    }

    @Override
    public <A> void write(final ByteBuffer src, final long position, final A attachment, final CompletionHandler<Integer, ? super A> handler) {
        if (handler == null) {
            throw new NullPointerException("handler is null");
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    handler.completed(EphemeralFsAsynchronousFileChannel.this.channel.write(src, position), attachment);
                }
                catch (Exception e) {
                    handler.failed(e, attachment);
                }
            }
        });
    }

    @Override
    public Future<Integer> write(final ByteBuffer src, final long position) {
        return this.submit(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return EphemeralFsAsynchronousFileChannel.this.channel.write(src, position);
            }
        });
    }

    private <T> Future<T> submit(Callable<T> callable) {
        if (this.executor instanceof ExecutorService) {
            return ((ExecutorService)this.executor).submit(callable);
        }
        FutureTask<T> answer = new FutureTask<T>(callable);
        this.executor.execute(answer);
        return answer;
    }
}

