/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbridges.ephemeralfs;

import com.github.sbridges.ephemeralfs.CloseTracker;
import com.github.sbridges.ephemeralfs.EphemeralFsFileSystem;
import com.github.sbridges.ephemeralfs.EphemeralFsPath;
import com.github.sbridges.ephemeralfs.FileContents;
import com.github.sbridges.ephemeralfs.INode;
import com.github.sbridges.ephemeralfs.ResolvedPath;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;

class EphemeralFsFileChannel
extends FileChannel {
    private boolean closed;
    private int position;
    private final boolean canRead;
    private final boolean canWrite;
    private final FileContents fc;
    private final boolean deleteOnClose;
    private final EphemeralFsFileSystem fs;
    private final INode iNode;
    private final EphemeralFsPath path;
    private final CloseTracker closeTracker;
    private final boolean sync;

    public EphemeralFsFileChannel(FileContents fc, boolean canRead, boolean canWrite, boolean deleteOnClose, boolean sync, ResolvedPath resolvedPath, EphemeralFsFileSystem fs) {
        this.fc = fc;
        this.canRead = canRead;
        this.canWrite = canWrite;
        this.deleteOnClose = deleteOnClose;
        this.sync = sync;
        this.fs = fs;
        try {
            this.iNode = resolvedPath.getTarget();
        }
        catch (NoSuchFileException e) {
            throw new IllegalStateException(e);
        }
        this.path = resolvedPath.getPath();
        this.closeTracker = this.path.getFileSystem().trackClose(FileChannel.class, this.path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer dst) throws IOException {
        Object object = this.fc.lock;
        synchronized (object) {
            this.assertReadable();
            this.assertNotClosed();
            if (this.position >= this.fc.getSize()) {
                return -1;
            }
            int toRead = Math.min(dst.remaining(), this.fc.getSize() - this.position);
            this.fc.getContents().position(this.position);
            this.fc.getContents().limit(this.position + toRead);
            try {
                dst.put(this.fc.getContents());
                this.position += toRead;
            }
            finally {
                this.fc.getContents().limit(this.fc.getContents().capacity());
            }
            return toRead;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        Object object = this.fc.lock;
        synchronized (object) {
            this.assertNotClosed();
            this.assertValidIndexes(dsts, offset, length);
            long total = 0L;
            for (int i = offset; i < offset + length; ++i) {
                total += (long)this.read(dsts[i]);
            }
            return total;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer src) throws IOException {
        int answer;
        Object object = this.fc.lock;
        synchronized (object) {
            this.assertNotClosed();
            this.assertWritable();
            this.ensureCapacity((long)this.position + (long)src.remaining());
            int toWrite = src.remaining();
            int newPosition = this.position + toWrite;
            this.fc.getContents().position(this.position);
            try {
                this.fc.getContents().limit(this.fc.getContents().capacity());
                this.fc.setSize(Math.max(this.fc.getSize(), newPosition));
            }
            finally {
                this.fc.getContents().limit(this.fc.getContents().capacity());
            }
            this.fc.getContents().put(src);
            this.position = newPosition;
            answer = toWrite;
            this.markDirty();
        }
        this.notifyModified();
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        Object object = this.fc.lock;
        synchronized (object) {
            this.assertNotClosed();
            this.assertValidIndexes(srcs, offset, length);
            long total = 0L;
            for (int i = offset; i < offset + length; ++i) {
                total += (long)this.write(srcs[i]);
            }
            return total;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position() throws IOException {
        Object object = this.fc.lock;
        synchronized (object) {
            this.assertNotClosed();
            return this.position;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileChannel position(long newPosition) throws IOException {
        Object object = this.fc.lock;
        synchronized (object) {
            this.assertNotClosed();
            if (this.position < 0) {
                throw new IllegalArgumentException("position must be > 0, not:" + newPosition);
            }
            if (newPosition > Integer.MAX_VALUE) {
                throw new IOException("position > max file length");
            }
            this.position = (int)newPosition;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long size() throws IOException {
        Object object = this.fc.lock;
        synchronized (object) {
            this.assertNotClosed();
            return this.fc.getSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileChannel truncate(long newSize) throws IOException {
        Object object = this.fc.lock;
        synchronized (object) {
            this.assertNotClosed();
            this.assertWritable();
            if (newSize < 0L) {
                throw new IllegalArgumentException("size must be > 0, not:" + newSize);
            }
            if (newSize > Integer.MAX_VALUE) {
                throw new IOException("max file size exceeded");
            }
            if (newSize >= (long)this.fc.getSize()) {
                return this;
            }
            this.fc.setSize((int)newSize);
            if (this.fc.getContents().capacity() > 2048) {
                this.fc.createNewBuffer(1024, true);
            }
            this.position = Math.min(this.position, this.fc.getSize());
            this.markDirty();
        }
        this.notifyModified();
        return this;
    }

    @Override
    public void force(boolean metaData) throws IOException {
        this.assertNotClosed();
        if (metaData) {
            this.fc.setDirty(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
        if (!target.isOpen()) {
            throw new ClosedChannelException();
        }
        if (position < 0L || count < 0L) {
            throw new IllegalArgumentException();
        }
        if (count > Integer.MAX_VALUE) {
            count = Integer.MAX_VALUE;
        }
        ByteBuffer tempBuf = ByteBuffer.allocate((int)count);
        Object object = this.fc.lock;
        synchronized (object) {
            int read = this.read(tempBuf, position);
            if (read <= 0) {
                return 0L;
            }
        }
        tempBuf.flip();
        return target.write(tempBuf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
        long answer;
        ByteBuffer tempBuf;
        int read;
        if (!src.isOpen()) {
            throw new ClosedChannelException();
        }
        if (position < 0L || count < 0L) {
            throw new IllegalArgumentException();
        }
        if (count > Integer.MAX_VALUE) {
            count = Integer.MAX_VALUE;
        }
        if ((read = src.read(tempBuf = ByteBuffer.allocate((int)count))) <= 0) {
            return 0L;
        }
        tempBuf.flip();
        Object object = this.fc.lock;
        synchronized (object) {
            if (position > this.size()) {
                return 0L;
            }
            answer = this.write(tempBuf, position);
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer dst, long position) throws IOException {
        Object object = this.fc.lock;
        synchronized (object) {
            int n;
            this.assertNotClosed();
            long startPosition = this.position();
            try {
                this.position(position);
                n = this.read(dst);
            }
            catch (Throwable throwable) {
                this.position(startPosition);
                throw throwable;
            }
            this.position(startPosition);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer src, long position) throws IOException {
        Object object = this.fc.lock;
        synchronized (object) {
            int n;
            this.assertNotClosed();
            long startPosition = this.position();
            try {
                this.position(position);
                n = this.write(src);
            }
            catch (Throwable throwable) {
                this.position(startPosition);
                throw throwable;
            }
            this.position(startPosition);
            return n;
        }
    }

    @Override
    public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileLock lock(long position, long size, boolean shared) throws IOException {
        return this.tryLock(this, position, size, shared);
    }

    @Override
    public FileLock tryLock(long position, long size, boolean shared) throws IOException {
        return this.tryLock(this, position, size, shared);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FileLock tryLock(Channel actualChannel, long position, long size, boolean shared) throws IOException {
        Object object = this.fc.lock;
        synchronized (object) {
            this.assertNotClosed();
            this.assertWritable();
            return this.fc.tryLock(actualChannel, position, size, shared);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implCloseChannel() throws IOException {
        Object object = this.fc.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        this.fs.getLimits().releaseFileHandle();
        if (this.deleteOnClose) {
            Files.delete(this.path);
        }
        this.closeTracker.onClose();
        object = this.fs.fsLock;
        synchronized (object) {
            this.iNode.removeOpenFileHandle();
        }
    }

    private void assertValidIndexes(ByteBuffer[] array, int offset, int length) {
        if (offset < 0 || length < 0 || offset + length > array.length) {
            throw new IllegalArgumentException("invalid offsets");
        }
    }

    private void assertNotClosed() throws ClosedChannelException {
        if (this.closed) {
            throw new ClosedChannelException();
        }
    }

    private void assertReadable() throws NonReadableChannelException, IOException {
        if (this.iNode.isDir()) {
            throw new IOException("Is a directory");
        }
        if (!this.canRead) {
            throw new NonReadableChannelException();
        }
    }

    private void assertWritable() throws NonWritableChannelException {
        if (!this.canWrite) {
            throw new NonWritableChannelException();
        }
    }

    private void ensureCapacity(long newSize) throws IOException {
        if (newSize > Integer.MAX_VALUE) {
            throw new IOException("max file size is2147483647");
        }
        if ((long)this.fc.getContents().capacity() >= newSize) {
            return;
        }
        long newCapacity = Math.max((long)(this.fc.getContents().capacity() * 2), newSize);
        if (newCapacity > Integer.MAX_VALUE) {
            newCapacity = Integer.MAX_VALUE;
        }
        this.fc.createNewBuffer((int)newCapacity, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyModified() throws NoSuchFileException {
        Object object = this.fs.fsLock;
        synchronized (object) {
            this.iNode.getProperties().getFileTimes().setLastModifiedTime(System.currentTimeMillis());
            if (this.fs.getSettings().isWindows()) {
                this.iNode.getProperties().setDosIsArchive(true);
            }
            this.iNode.notifyChange(this.path);
            this.iNode.notifyChange(this.path);
        }
    }

    private void markDirty() {
        if (this.sync) {
            this.fc.setDirty(false);
        } else {
            this.fc.setDirty(true);
        }
    }
}

