/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbridges.ephemeralfs;

import com.github.sbridges.ephemeralfs.EphemeralFsFileSystem;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileStoreAttributeView;

class EphemeralFsFileStore
extends FileStore {
    private final EphemeralFsFileSystem fs;

    public EphemeralFsFileStore(EphemeralFsFileSystem fs) {
        this.fs = fs;
    }

    @Override
    public String name() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String type() {
        return "ephemeralfs";
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public long getTotalSpace() throws IOException {
        return this.fs.getSettings().getTotalSpace();
    }

    @Override
    public long getUsableSpace() throws IOException {
        return this.fs.getLimits().getFreeSpace();
    }

    @Override
    public long getUnallocatedSpace() throws IOException {
        return this.fs.getLimits().getFreeSpace();
    }

    @Override
    public boolean supportsFileAttributeView(Class<? extends FileAttributeView> type) {
        return this.fs.getAttributes().supportsFileAttributeView(type);
    }

    @Override
    public boolean supportsFileAttributeView(String name) {
        return this.fs.supportedFileAttributeViews().contains(name);
    }

    @Override
    public <V extends FileStoreAttributeView> V getFileStoreAttributeView(Class<V> type) {
        return null;
    }

    @Override
    public Object getAttribute(String attribute) throws IOException {
        throw new UnsupportedOperationException();
    }
}

