/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbridges.ephemeralfs;

import com.github.sbridges.ephemeralfs.AttributeLookup;
import com.github.sbridges.ephemeralfs.AttributeSet;
import com.github.sbridges.ephemeralfs.CloseChecker;
import com.github.sbridges.ephemeralfs.CloseTracker;
import com.github.sbridges.ephemeralfs.DefaultAsyncThreadPoolHolder;
import com.github.sbridges.ephemeralfs.EphemeralFsAsynchronousFileChannel;
import com.github.sbridges.ephemeralfs.EphemeralFsFileChannel;
import com.github.sbridges.ephemeralfs.EphemeralFsFileStore;
import com.github.sbridges.ephemeralfs.EphemeralFsFileSystemProvider;
import com.github.sbridges.ephemeralfs.EphemeralFsPath;
import com.github.sbridges.ephemeralfs.EphemeralFsPathProvider;
import com.github.sbridges.ephemeralfs.EphemeralFsSecureDirectoryStream;
import com.github.sbridges.ephemeralfs.EphemeralFsUserPrincipalLookupService;
import com.github.sbridges.ephemeralfs.EphemeralFsWatchService;
import com.github.sbridges.ephemeralfs.FileAttributesViewBuilder;
import com.github.sbridges.ephemeralfs.FilePermissions;
import com.github.sbridges.ephemeralfs.GlobUtil;
import com.github.sbridges.ephemeralfs.INode;
import com.github.sbridges.ephemeralfs.Limits;
import com.github.sbridges.ephemeralfs.ResolvedPath;
import com.github.sbridges.ephemeralfs.Settings;
import com.github.sbridges.ephemeralfs.WatchRegistry;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.regex.Pattern;

class EphemeralFsFileSystem
extends FileSystem {
    final Object fsLock = new Object();
    private final Settings settings;
    private final String name;
    private volatile boolean closed = false;
    private final EphemeralFsFileSystemProvider provider;
    private final INode root;
    private final DefaultAsyncThreadPoolHolder asyncThreadPoolHolder = new DefaultAsyncThreadPoolHolder();
    private final UserPrincipalLookupService userPrincipalLookupService = new EphemeralFsUserPrincipalLookupService();
    private final WatchRegistry watchRegistry = new WatchRegistry();
    private final EphemeralFsFileStore fileStore = new EphemeralFsFileStore(this);
    private final Limits limits;
    private final AttributeLookup attributes;
    private final Set<CloseTracker> notClosed = Collections.newSetFromMap(new ConcurrentHashMap());

    public AttributeLookup getAttributes() {
        return this.attributes;
    }

    public WatchRegistry getWatchRegistry() {
        return this.watchRegistry;
    }

    public void closed(CloseTracker tracker) {
        this.notClosed.remove(tracker);
    }

    public CloseTracker trackClose(Class<?> type, EphemeralFsPath path) {
        CloseTracker answer = new CloseTracker(type, this, path);
        this.notClosed.add(answer);
        return answer;
    }

    EphemeralFsFileSystem(String name, Settings settings, EphemeralFsFileSystemProvider provider) {
        this.name = name;
        this.settings = settings;
        this.provider = provider;
        this.root = INode.createRoot(this);
        this.limits = new Limits(settings);
        this.attributes = settings.isWindows() ? new AttributeLookup(AttributeSet.BASIC, AttributeSet.OWNER, AttributeSet.DOS) : new AttributeLookup(AttributeSet.BASIC, AttributeSet.DOS, AttributeSet.POSIX, AttributeSet.UNIX, AttributeSet.OWNER);
    }

    @Override
    public FileSystemProvider provider() {
        return this.provider;
    }

    @Override
    public void close() throws IOException {
        this.provider.closing(this);
        this.asyncThreadPoolHolder.close();
        this.closed = true;
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String getSeparator() {
        return this.settings.getSeperator();
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        return Collections.singleton(this.getRootPath());
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        return Collections.unmodifiableList(Arrays.asList(this.fileStore));
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return this.attributes.getViews();
    }

    @Override
    public EphemeralFsPath getPath(String first, String ... more) {
        this.assertOpen();
        return new EphemeralFsPath(this, first, more);
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        if (syntaxAndPattern.startsWith("regex:")) {
            return this.regexPathMatcher(syntaxAndPattern.substring("regex:".length()));
        }
        if (syntaxAndPattern.startsWith("glob:")) {
            String glob = syntaxAndPattern.substring("glob:".length());
            String regex = GlobUtil.globToRegex(glob, this.settings.isPosix());
            return this.regexPathMatcher(regex);
        }
        if (!Pattern.matches(".+:.+", syntaxAndPattern)) {
            throw new IllegalArgumentException("syntaxAndPattern must take the form syntax:patterbn, not" + syntaxAndPattern);
        }
        throw new UnsupportedOperationException("invlalid syntaxAndPattern:" + syntaxAndPattern);
    }

    private PathMatcher regexPathMatcher(String regex) {
        int flags = 0;
        if (!this.getSettings().caseSensitive()) {
            flags |= 2;
        }
        final Pattern p = Pattern.compile(regex, flags);
        return new PathMatcher(){

            @Override
            public boolean matches(Path path) {
                return p.matcher(path.toString()).matches();
            }
        };
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        return this.userPrincipalLookupService;
    }

    @Override
    public WatchService newWatchService() throws IOException {
        return new EphemeralFsWatchService(this);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[name=" + this.name + "]";
    }

    public AsynchronousFileChannel newAsynchronousByteChannel(EphemeralFsPath efsPath, Set<? extends OpenOption> options, ExecutorService executor, FileAttribute<?>[] attrs) throws IOException {
        if (executor == null) {
            executor = this.asyncThreadPoolHolder.getThreadPool();
        }
        EphemeralFsFileChannel channel = this.newByteChannel(efsPath, options, attrs);
        return new EphemeralFsAsynchronousFileChannel(channel, executor);
    }

    EphemeralFsFileChannel newByteChannel(EphemeralFsPath path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        if (this.getSettings().isWindows()) {
            for (FileAttribute<?> attr : attrs) {
                if (!attr.name().equals("posix:permissions")) continue;
                throw new UnsupportedOperationException("'posix:permissions' not supported as initial attribute");
            }
        }
        Object object = this.fsLock;
        synchronized (object) {
            boolean deleteOnOpen;
            if (!this.isOpen()) {
                throw new FileSystemException("closed");
            }
            boolean noFollow = options.contains(LinkOption.NOFOLLOW_LINKS);
            ResolvedPath resolvedPath = ResolvedPath.resolve(path, noFollow);
            if (resolvedPath.resolvedToSymbolicLink() && noFollow) {
                throw new IOException("Too many levels of symbolic links (NOFOLLOW_LINKS specified)");
            }
            boolean deleteOnClose = !this.settings.isPosix() && options.contains(StandardOpenOption.DELETE_ON_CLOSE);
            boolean bl = deleteOnOpen = this.settings.isPosix() && options.contains(StandardOpenOption.DELETE_ON_CLOSE);
            if (resolvedPath.hasTarget()) {
                this.limits.tryAcquireFileHandle();
                EphemeralFsFileChannel answer = resolvedPath.getTarget().newFileChannel(options, deleteOnClose, resolvedPath);
                if (deleteOnOpen && !resolvedPath.getTarget().isDir()) {
                    this.delete(path);
                }
                return answer;
            }
            if (options.contains(StandardOpenOption.CREATE) || options.contains(StandardOpenOption.CREATE_NEW)) {
                EphemeralFsPath realPath;
                if (!options.contains(StandardOpenOption.WRITE)) {
                    throw new NoSuchFileException(path.toString());
                }
                if (!resolvedPath.hasValidParent()) {
                    throw new NoSuchFileException(path.toString());
                }
                if (options.contains(StandardOpenOption.CREATE_NEW)) {
                    ResolvedPath resolvedForCreate = ResolvedPath.resolve(path, true);
                    realPath = resolvedForCreate.getPath();
                } else {
                    realPath = resolvedPath.getPath();
                }
                if (realPath.getParent() == null) {
                    throw new IOException("No Parent");
                }
                if (realPath.getFileName().toString().equals("..") || realPath.getFileName().toString().equals(".")) {
                    throw new IOException("invalid path:" + realPath);
                }
                INode parent = resolvedPath.getParent();
                if (!parent.isDir()) {
                    throw new IOException("not a directory");
                }
                this.limits.tryAcquireFileHandle();
                INode child = parent.addFile(realPath.getFileName(), new FilePermissions(false, attrs));
                HashSet<? extends OpenOption> openOptionsCopy = new HashSet<OpenOption>(options);
                openOptionsCopy.remove(StandardOpenOption.CREATE);
                openOptionsCopy.remove(StandardOpenOption.CREATE_NEW);
                EphemeralFsFileChannel answer = child.newFileChannel(openOptionsCopy, deleteOnClose, ResolvedPath.resolve(realPath, false));
                if (deleteOnOpen) {
                    this.delete(path);
                }
                return answer;
            }
            throw new NoSuchFileException(path.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkAccess(EphemeralFsPath path, AccessMode ... modes) throws IOException {
        Object object = this.fsLock;
        synchronized (object) {
            ResolvedPath resolved = ResolvedPath.resolve(path, false);
            if (!resolved.hasTarget()) {
                throw new NoSuchFileException("Could not find:" + path);
            }
            block8: for (AccessMode m : modes) {
                switch (m) {
                    case READ: {
                        if (resolved.getTarget().canRead()) continue block8;
                        throw new AccessDeniedException(path.toString());
                    }
                    case WRITE: {
                        if (resolved.getTarget().canWrite()) continue block8;
                        throw new AccessDeniedException(path.toString());
                    }
                    case EXECUTE: {
                        if (resolved.getTarget().canExecute()) continue block8;
                        throw new AccessDeniedException(path.toString());
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createDirectory(EphemeralFsPath dir, FileAttribute<?> ... attrs) throws IOException {
        dir = dir.toAbsolutePath();
        Object object = this.fsLock;
        synchronized (object) {
            if (dir.getParent() == null) {
                throw new FileAlreadyExistsException(dir.toString());
            }
            ResolvedPath resolvedPath = ResolvedPath.resolve(dir.getParent(), false);
            if (!resolvedPath.hasTarget()) {
                throw new NoSuchFileException(dir.getParent().toString());
            }
            if (!resolvedPath.getTarget().isDir()) {
                throw new FileSystemException(dir.getParent() + " : is Not a directory");
            }
            resolvedPath.getTarget().addDir(dir.getFileName(), new FilePermissions(true, attrs));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createSymbolicLink(EphemeralFsPath link, EphemeralFsPath target, FileAttribute<?>[] attrs) throws IOException {
        Object object = this.fsLock;
        synchronized (object) {
            EphemeralFsPath dir = link.getParent();
            ResolvedPath resolvedPath = ResolvedPath.resolve(dir, false);
            if (!resolvedPath.hasTarget()) {
                throw new NoSuchFileException(dir.toString());
            }
            if (!resolvedPath.getTarget().isDir()) {
                throw new FileSystemException(dir + " : is Not a directory");
            }
            resolvedPath.getTarget().addSymlink(link.getFileName(), target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createLink(EphemeralFsPath link, EphemeralFsPath existing) throws IOException {
        Object object = this.fsLock;
        synchronized (object) {
            EphemeralFsPath dir = link.getParent();
            ResolvedPath resolvedPath = ResolvedPath.resolve(dir, false);
            if (!resolvedPath.hasTarget()) {
                throw new NoSuchFileException(dir.toString());
            }
            if (!resolvedPath.getTarget().isDir()) {
                throw new FileSystemException(dir + " : is Not a directory");
            }
            ResolvedPath existingResolved = ResolvedPath.resolve(existing);
            if (!existingResolved.hasTarget()) {
                throw new NoSuchFileException(link.toString());
            }
            if (existingResolved.getTarget().isDir()) {
                throw new FileSystemException(link + " -> " + existing + ": Operation not permitted");
            }
            resolvedPath.getTarget().add(link.getFileName(), existingResolved.getTarget());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete(EphemeralFsPath path) throws IOException {
        Object object = this.fsLock;
        synchronized (object) {
            INode iNode;
            ResolvedPath resolvedPath = ResolvedPath.resolve(path, true);
            if (resolvedPath.hasTarget() && (iNode = resolvedPath.getTarget()).isDir() && !iNode.isEmpty()) {
                throw new DirectoryNotEmptyException(path.toString());
            }
            if (!resolvedPath.didResolve()) {
                throw new NoSuchFileException(path.toString());
            }
            if (this.getSettings().isWindows() && resolvedPath.getResolvedProperties().getDosIsReadOnly()) {
                throw new AccessDeniedException(path.toString());
            }
            resolvedPath.getParent().remove(resolvedPath.getPath().getFileName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void move(EphemeralFsPath source, EphemeralFsPath target, CopyOption[] options) throws IOException {
        EnumSet<StandardCopyOption> optionsSet = EnumSet.noneOf(StandardCopyOption.class);
        if (options != null) {
            for (CopyOption option : options) {
                if (!(option instanceof StandardCopyOption)) {
                    throw new IllegalArgumentException("unrecognized option:" + option);
                }
                optionsSet.add((StandardCopyOption)option);
            }
        }
        if (this.isSameFile(source, target)) {
            return;
        }
        Object object = this.fsLock;
        synchronized (object) {
            ResolvedPath sourceResolved = ResolvedPath.resolve(source, true);
            ResolvedPath targetResolved = ResolvedPath.resolve(target);
            if (!sourceResolved.hasTarget() && !sourceResolved.resolvedToSymbolicLink()) {
                throw new NoSuchFileException(source.toString());
            }
            if (sourceResolved.hasTarget() && sourceResolved.getTarget() == this.root) {
                throw new IOException("cant move root");
            }
            if (!targetResolved.hasValidParent()) {
                throw new NoSuchFileException(target.toString());
            }
            if (targetResolved.hasTarget()) {
                if (!optionsSet.contains(StandardCopyOption.REPLACE_EXISTING) && !optionsSet.contains(StandardCopyOption.ATOMIC_MOVE)) {
                    throw new FileAlreadyExistsException(target.toString());
                }
                if (this.getSettings().isWindows() && optionsSet.contains(StandardCopyOption.ATOMIC_MOVE)) {
                    throw new AccessDeniedException(target.toString());
                }
                if (targetResolved.getTarget().isDir() && !targetResolved.getTarget().isEmpty()) {
                    throw new DirectoryNotEmptyException(target.toString());
                }
                targetResolved.getParent().remove(target.getFileName());
            }
            if (sourceResolved.resolvedToSymbolicLink()) {
                targetResolved.getParent().addSymlink(target.getFileName(), sourceResolved.getRawSymbolicLink());
            } else {
                targetResolved.getParent().add(target.getFileName(), sourceResolved.getTarget());
            }
            sourceResolved.getParent().remove(source.getFileName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(EphemeralFsPath source, EphemeralFsPath target, CopyOption ... options) throws IOException {
        boolean noFollowLinks = false;
        EnumSet<StandardCopyOption> optionsSet = EnumSet.noneOf(StandardCopyOption.class);
        if (options != null) {
            for (CopyOption option : options) {
                if (option instanceof StandardCopyOption) {
                    optionsSet.add((StandardCopyOption)option);
                    continue;
                }
                if (option != LinkOption.NOFOLLOW_LINKS) continue;
                noFollowLinks = true;
            }
        }
        if (optionsSet.contains(StandardCopyOption.ATOMIC_MOVE)) {
            throw new UnsupportedOperationException("Atomic Move is not supported");
        }
        Object object = this.fsLock;
        synchronized (object) {
            ResolvedPath resolvedSource = ResolvedPath.resolve(source, noFollowLinks);
            ResolvedPath resolvedTarget = ResolvedPath.resolve(target);
            if (resolvedSource.hasTarget() && resolvedTarget.hasTarget() && resolvedSource.getTarget() == resolvedTarget.getTarget()) {
                return;
            }
            if (resolvedSource.hasTarget() && resolvedSource.getTarget() == this.root) {
                throw new IOException("can't copy root");
            }
            if (!resolvedSource.didResolve()) {
                throw new NoSuchFileException(source.toString());
            }
            if (resolvedTarget.didResolve() && !optionsSet.contains(StandardCopyOption.REPLACE_EXISTING)) {
                throw new FileAlreadyExistsException(target.toString());
            }
            if (resolvedTarget.hasTarget() && resolvedTarget.getTarget().isDir() && !resolvedTarget.getTarget().isEmpty()) {
                throw new DirectoryNotEmptyException(target.toString());
            }
            if (resolvedTarget.didResolve()) {
                resolvedTarget.getParent().remove(target.getFileName());
            } else if (!resolvedTarget.hasValidParent()) {
                throw new NoSuchFileException(target.toString());
            }
            INode modified = null;
            if (resolvedSource.hasTarget() && resolvedSource.getTarget().isDir()) {
                modified = resolvedTarget.getParent().addDir(target.getFileName(), FilePermissions.createDefaultDirectory());
            } else if (resolvedSource.resolvedToSymbolicLink()) {
                resolvedTarget.getParent().addSymlink(target.getFileName(), resolvedSource.getRawSymbolicLink());
            } else {
                modified = resolvedTarget.getParent().addFile(target.getFileName(), FilePermissions.createDefaultFile());
                try (EphemeralFsFileChannel targetChannel = this.newByteChannel(target, EnumSet.of(StandardOpenOption.WRITE), new FileAttribute[0]);
                     EphemeralFsFileChannel sourceChannel = this.newByteChannel(resolvedSource.getPath(), EnumSet.of(StandardOpenOption.READ), new FileAttribute[0]);){
                    ByteBuffer buf = ByteBuffer.allocate(Math.min(4096, resolvedSource.getTarget().getContentsSize()));
                    while (sourceChannel.read(buf) >= 0 || buf.position() != 0) {
                        buf.flip();
                        targetChannel.write(buf);
                        buf.compact();
                    }
                }
                modified.copyPermissions(resolvedSource.getTarget());
            }
            if (modified != null) {
                if (this.settings.isPosix()) {
                    if (optionsSet.contains(StandardCopyOption.COPY_ATTRIBUTES)) {
                        modified.getProperties().getFileTimes().setLastModifiedTime(resolvedSource.getResolvedProperties().getFileTimes().getLastModifiedTime());
                    }
                } else {
                    modified.getProperties().getFileTimes().setLastModifiedTime(resolvedSource.getResolvedProperties().getFileTimes().getLastModifiedTime());
                }
            }
        }
    }

    private void assertOpen() {
        if (!this.isOpen()) {
            throw new IllegalStateException("already closed");
        }
    }

    public EphemeralFsPath getRootPath() {
        return this.getPath(this.settings.getRoot(), new String[0]);
    }

    public INode getRoot() {
        return this.root;
    }

    public DirectoryStream<Path> newDirectoryStream(EphemeralFsPath dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        return this.newDirectoryStream(dir, dir, filter);
    }

    public <V extends FileAttributeView> V getFileAttributeView(EphemeralFsPathProvider pathProvider, Class<V> type, CloseChecker closeChecker, LinkOption ... options) {
        return this.getFileAttributesViewBuilder(pathProvider, closeChecker, options).build(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileAttributesViewBuilder getFileAttributesViewBuilder(EphemeralFsPathProvider pathProvider, CloseChecker closeChecker, LinkOption ... options) {
        FileAttributesViewBuilder builder;
        Object object = this.fsLock;
        synchronized (object) {
            builder = new FileAttributesViewBuilder(this, pathProvider, closeChecker, options);
        }
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DirectoryStream<Path> newDirectoryStream(EphemeralFsPath dir, EphemeralFsPath relativeDir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        Object object = this.fsLock;
        synchronized (object) {
            ResolvedPath resolvedDir = ResolvedPath.resolve(dir);
            if (!resolvedDir.hasTarget()) {
                throw new NoSuchFileException(dir.toString());
            }
            if (!resolvedDir.getTarget().isDir()) {
                throw new NotDirectoryException(dir.toString());
            }
            ArrayList<Path> parts = new ArrayList<Path>();
            for (EphemeralFsPath childName : resolvedDir.getTarget().getChildNames()) {
                EphemeralFsPath child = dir.resolve(childName);
                if (!filter.accept(child)) continue;
                parts.add(relativeDir.resolve(child.getFileName()));
            }
            return EphemeralFsSecureDirectoryStream.makeDirectoryStream(resolvedDir.getTarget(), relativeDir, parts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSameFile(EphemeralFsPath path1, EphemeralFsPath path2) throws FileSystemException {
        Object object = this.fsLock;
        synchronized (object) {
            ResolvedPath resolved1 = ResolvedPath.resolve(path1, false);
            ResolvedPath resolved2 = ResolvedPath.resolve(path2, false);
            if (!resolved1.hasTarget() || !resolved2.hasTarget()) {
                return false;
            }
            return resolved1.getTarget() == resolved2.getTarget();
        }
    }

    public Settings getSettings() {
        return this.settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path readSymbolicLink(EphemeralFsPath link) throws FileSystemException {
        Object object = this.fsLock;
        synchronized (object) {
            ResolvedPath resolved = ResolvedPath.resolve(link.getParent());
            if (!resolved.hasTarget()) {
                throw new NoSuchFileException(link.toString());
            }
            return resolved.getTarget().getRawSymbolicLink(link.getParent(), link.getFileName());
        }
    }

    public Limits getLimits() {
        return this.limits;
    }

    public void assertNoOpenResources() throws AssertionError {
        Object object = this.fsLock;
        synchronized (object) {
            HashSet<CloseTracker> open = new HashSet<CloseTracker>(this.notClosed);
            if (open.isEmpty()) {
                return;
            }
            StringBuilder builder = new StringBuilder("Failed to close " + open.size() + " resource(s)");
            int failedCount = 1;
            for (CloseTracker tracker : open) {
                builder.append("\n").append(failedCount).append(") ");
                builder.append(tracker.getErrorString().trim());
                if (++failedCount != 100) continue;
                builder.append("\n...");
                break;
            }
            throw new AssertionError((Object)builder.toString().trim());
        }
    }

    public void assertAllFilesFsynced(EphemeralFsPath path) throws AssertionError {
        Object object = this.fsLock;
        synchronized (object) {
            final ArrayList notFsynced = new ArrayList();
            try {
                ResolvedPath resolved = ResolvedPath.resolve(path);
                if (!resolved.didResolve() || resolved.resolvedToSymbolicLink()) {
                    throw new IllegalArgumentException("not found:" + path);
                }
                Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        ResolvedPath resolved = ResolvedPath.resolve((EphemeralFsPath)file);
                        if (resolved.getTarget().isDirty()) {
                            notFsynced.add(file);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
                if (notFsynced.isEmpty()) {
                    return;
                }
                throw new AssertionError((Object)("Failed to sync " + notFsynced));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public void assertAllDirectoriesFsynced(EphemeralFsPath dir, boolean recursive) {
        Object object = this.fsLock;
        synchronized (object) {
            final ArrayList notFsynced = new ArrayList();
            try {
                ResolvedPath resolved = ResolvedPath.resolve(dir);
                if (!resolved.didResolve() || resolved.resolvedToSymbolicLink()) {
                    throw new IllegalArgumentException("not found:" + dir);
                }
                if (resolved.getTarget().isFile()) {
                    throw new IllegalArgumentException(dir + " is not a directory");
                }
                if (!recursive && resolved.getTarget().isDirty()) {
                    throw new AssertionError((Object)("Failed to sync " + dir));
                }
                Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        ResolvedPath resolved = ResolvedPath.resolve((EphemeralFsPath)dir);
                        if (resolved.getTarget().isDirty()) {
                            notFsynced.add(dir);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
                if (notFsynced.isEmpty()) {
                    return;
                }
                throw new AssertionError((Object)("Failed to sync " + notFsynced));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

