/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbridges.ephemeralfs;

import com.github.sbridges.ephemeralfs.EphemeralFsFileSystemProvider;
import com.github.sbridges.ephemeralfs.OS;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.file.FileSystem;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public final class EphemeralFsFileSystemBuilder {
    private static final String UNIX = "unix";
    private static final String WINDOWS = "windows";
    private static final String MAC = "mac";
    private boolean built;
    private static final AtomicLong ID_PREFIX = new AtomicLong(0L);
    static final String SEPERATOR_PROP = "SEPERATOR";
    static final String ROOT_PROP = "ROOT";
    static final String CASE_SENSITIVE_PROP = "CASE_SENSITIVE";
    static final String MAX_FILE_HANDLES = "MAX_FILE_HANDLES";
    static final String TOTAL_SPACE = "TOTAL_SPACE";
    static final String RECORD_RESOURCE_CREATION_STACK_TRACES = "RECORD_RESOURCE_CREATION_STACK_TRACES";
    static final String MAX_PATH_LENGTH = "MAX_PATH_LENGTH";
    private String name;
    private final Map<String, String> props = new HashMap<String, String>();

    private EphemeralFsFileSystemBuilder(String type) {
        if (type.equals(MAC)) {
            this.props.put(SEPERATOR_PROP, "/");
            this.props.put(ROOT_PROP, "/");
            this.props.put(CASE_SENSITIVE_PROP, "false");
        } else if (type.equals(WINDOWS)) {
            this.props.put(SEPERATOR_PROP, "\\");
            this.props.put(ROOT_PROP, "m:\\");
            this.props.put(CASE_SENSITIVE_PROP, "false");
            this.props.put(MAX_PATH_LENGTH, "260");
        } else if (type.equals(UNIX)) {
            this.props.put(SEPERATOR_PROP, "/");
            this.props.put(ROOT_PROP, "/");
            this.props.put(CASE_SENSITIVE_PROP, "true");
        }
        this.name = "ephemeralFs_" + type + "_" + ID_PREFIX.incrementAndGet();
        this.setRecordStackTracesOnOpen(true);
    }

    public static EphemeralFsFileSystemBuilder defaultFs() {
        if (OS.isMac()) {
            return new EphemeralFsFileSystemBuilder(MAC);
        }
        if (OS.isWindows()) {
            return new EphemeralFsFileSystemBuilder(WINDOWS);
        }
        if (OS.isUnix()) {
            return new EphemeralFsFileSystemBuilder(UNIX);
        }
        throw new IllegalStateException();
    }

    public static EphemeralFsFileSystemBuilder windowsFs() {
        return new EphemeralFsFileSystemBuilder(WINDOWS);
    }

    public static EphemeralFsFileSystemBuilder macFs() {
        return new EphemeralFsFileSystemBuilder(MAC);
    }

    public static EphemeralFsFileSystemBuilder unixFs() {
        return new EphemeralFsFileSystemBuilder(UNIX);
    }

    public EphemeralFsFileSystemBuilder setRecordStackTracesOnOpen(boolean recordStackTracesOnOpen) {
        this.props.put(RECORD_RESOURCE_CREATION_STACK_TRACES, Boolean.toString(recordStackTracesOnOpen));
        return this;
    }

    public EphemeralFsFileSystemBuilder setName(String name) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        return this;
    }

    public EphemeralFsFileSystemBuilder setMaxFileHandles(long maxFileHandles) {
        if (maxFileHandles <= 0L) {
            throw new IllegalArgumentException("maxFileHandles must be > 0, not:" + maxFileHandles);
        }
        this.props.put(MAX_FILE_HANDLES, Long.toString(maxFileHandles));
        return this;
    }

    public EphemeralFsFileSystemBuilder setTotalSpace(long totalSpace) {
        if (totalSpace <= 0L) {
            throw new IllegalArgumentException("long totalSpace must be > 0, not:" + totalSpace);
        }
        this.props.put(TOTAL_SPACE, Long.toString(totalSpace));
        return this;
    }

    Map<String, ?> buildEnv() {
        return new HashMap<String, String>(this.props);
    }

    URI buildURI() {
        try {
            return URI.create("ephemeralfs://?name=" + URLEncoder.encode(this.name, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public FileSystem build() throws IllegalStateException {
        if (this.built) {
            throw new IllegalStateException("already built");
        }
        this.built = true;
        try {
            return new EphemeralFsFileSystemProvider().newFileSystem(this.buildURI(), this.buildEnv());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

