/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbridges.ephemeralfs;

import com.github.sbridges.ephemeralfs.EphemeralFsFileSystem;
import com.github.sbridges.ephemeralfs.EphemeralFsPath;
import java.nio.file.FileSystem;
import java.nio.file.Path;

public final class EphemeralFsFileSystemChecker {
    public static void assertNoOpenResources(FileSystem fs) throws AssertionError, ClassCastException {
        ((EphemeralFsFileSystem)fs).assertNoOpenResources();
    }

    public static void assertAllFilesFsynced(Path path) throws AssertionError, ClassCastException, IllegalArgumentException {
        EphemeralFsPath efsPath = (EphemeralFsPath)path;
        efsPath.getFileSystem().assertAllFilesFsynced(efsPath);
    }

    public static void assertAllDirectoriesFsynced(Path dir, boolean recursive) throws AssertionError, ClassCastException, IllegalArgumentException {
        EphemeralFsPath efsDir = (EphemeralFsPath)dir;
        efsDir.getFileSystem().assertAllDirectoriesFsynced(efsDir, recursive);
    }
}

