/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbridges.ephemeralfs;

import com.github.sbridges.ephemeralfs.Attribute;
import com.github.sbridges.ephemeralfs.CloseChecker;
import com.github.sbridges.ephemeralfs.EphemeralFsFileSystem;
import com.github.sbridges.ephemeralfs.EphemeralFsFileSystemBuilder;
import com.github.sbridges.ephemeralfs.EphemeralFsPath;
import com.github.sbridges.ephemeralfs.EphemeralFsPathProvider;
import com.github.sbridges.ephemeralfs.FileAttributesViewBuilder;
import com.github.sbridges.ephemeralfs.Settings;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.spi.FileSystemProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class EphemeralFsFileSystemProvider
extends FileSystemProvider {
    static final String SCHEME = "ephemeralfs";
    private static final Pattern URI_QUERY_PATTERN = Pattern.compile("name=([^&=]+)");
    private static final ConcurrentHashMap<String, EphemeralFsFileSystem> fileSystems = new ConcurrentHashMap();

    @Override
    public String getScheme() {
        return SCHEME;
    }

    static void closeAll() {
        for (EphemeralFsFileSystem fs : fileSystems.values()) {
            try {
                fs.close();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public FileSystem newFileSystem(URI uri, Map<String, ?> env) throws IOException {
        EphemeralFsFileSystem answer;
        if (uri == null || env == null) {
            throw new NullPointerException();
        }
        String name = this.validateUriAndGetName(uri);
        if (fileSystems.putIfAbsent(name, answer = new EphemeralFsFileSystem(name, new Settings(env), this)) != null) {
            throw new FileSystemAlreadyExistsException("A filesystem already exists with the name:" + name);
        }
        return answer;
    }

    @Override
    public FileSystem getFileSystem(URI uri) {
        String name = this.validateUriAndGetName(uri);
        EphemeralFsFileSystem answer = fileSystems.get(name);
        if (answer != null) {
            return answer;
        }
        throw new FileSystemNotFoundException("no filesystem with name:" + name + " for uri:" + uri);
    }

    String validateUriAndGetName(URI uri) {
        if (uri.getScheme() == null || !uri.getScheme().equalsIgnoreCase(this.getScheme())) {
            throw new IllegalArgumentException("expecting scheme of:" + this.getScheme() + " not:" + uri.getScheme() + " uri:" + uri);
        }
        if (uri.getFragment() != null) {
            throw new IllegalArgumentException("fragment must be null");
        }
        String query = uri.getQuery();
        Matcher matcher = URI_QUERY_PATTERN.matcher(query == null ? "" : query);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("expecting a query like, ?name=filesystemName, not:" + query);
        }
        return matcher.group(1);
    }

    @Override
    public Path getPath(URI uri) {
        String path;
        String name = this.validateUriAndGetName(uri);
        String uriPath = uri.getPath();
        if (uriPath == null) {
            throw new IllegalArgumentException("path required");
        }
        EphemeralFsFileSystem fs = fileSystems.get(name);
        if (fs == null) {
            fileSystems.putIfAbsent(name, new EphemeralFsFileSystem(name, new Settings(EphemeralFsFileSystemBuilder.defaultFs().buildEnv()), this));
            fs = fileSystems.get(name);
        }
        if (fs.getSettings().getSeperator().equals("/")) {
            path = uriPath;
        } else {
            path = uriPath.replaceAll("/", "\\\\");
            if (path.startsWith("\\")) {
                path = String.valueOf(fs.getSettings().getRoot()) + path;
            }
        }
        return fs.getPath(path, new String[0]).toAbsolutePath();
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        return this.getFs(path).newByteChannel(this.toEfsPath(path), options, attrs);
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        return this.getFs(dir).newDirectoryStream(this.toEfsPath(dir), filter);
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        this.getFs(dir).createDirectory((EphemeralFsPath)dir, attrs);
    }

    @Override
    public void createSymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) throws IOException {
        this.getFs(link).createSymbolicLink(this.toEfsPath(link), this.toEfsPath(target), attrs);
    }

    @Override
    public void createLink(Path link, Path existing) throws IOException {
        this.getFs(link).createLink(this.toEfsPath(link), this.toEfsPath(existing));
    }

    @Override
    public void delete(Path path) throws IOException {
        this.getFs(path).delete(this.toEfsPath(path));
    }

    @Override
    public void copy(Path source, Path target, CopyOption ... options) throws IOException {
        if (this.getFs(source) != this.getFs(target)) {
            throw new IllegalArgumentException("source and target have different file systems");
        }
        this.getFs(source).copy(this.toEfsPath(source), this.toEfsPath(target), options);
    }

    @Override
    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        this.assertSameFs(source, target);
        this.getFs(source).move(this.toEfsPath(source), this.toEfsPath(target), options);
    }

    @Override
    public boolean isSameFile(Path path, Path path2) throws IOException {
        if (path.getFileSystem() != path2.getFileSystem()) {
            return false;
        }
        if (path.equals(path2)) {
            return true;
        }
        return this.getFs(path).isSameFile(this.toEfsPath(path), this.toEfsPath(path2));
    }

    @Override
    public boolean isHidden(Path path) throws IOException {
        EphemeralFsFileSystem fs = this.getFs(path);
        if (!fs.getSettings().isPosix()) {
            DosFileAttributes atts = this.readAttributes(path, DosFileAttributes.class, new LinkOption[0]);
            if (atts.isDirectory()) {
                return false;
            }
            return atts.isHidden();
        }
        return path.getFileName().toString().startsWith(".");
    }

    @Override
    public FileStore getFileStore(Path path) throws IOException {
        return this.getFs(path).getFileStores().iterator().next();
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        this.getFs(path).checkAccess(this.toEfsPath(path), modes);
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        EphemeralFsPath efsPath = this.toEfsPath(path);
        return efsPath.fs.getFileAttributeView(new EphemeralFsPathProvider.ConstefsPathProvider(efsPath), type, CloseChecker.ALWAYS_OPEN, options);
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        return (A)this.getFileAttributeView(path, this.viewClassFor(type), options).readAttributes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        EphemeralFsPath efsPath = this.toEfsPath(path);
        Object object = efsPath.fs.fsLock;
        synchronized (object) {
            FileAttributesViewBuilder builder = efsPath.fs.getFileAttributesViewBuilder(new EphemeralFsPathProvider.ConstefsPathProvider(efsPath), CloseChecker.ALWAYS_OPEN, options);
            HashMap<String, Object> answer = new HashMap<String, Object>();
            for (Attribute a : efsPath.fs.getAttributes().getMultiple(attributes)) {
                answer.put(a.getName(), a.read(builder));
            }
            return answer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
        EphemeralFsPath efsPath = this.toEfsPath(path);
        Object object = efsPath.fs.fsLock;
        synchronized (object) {
            FileAttributesViewBuilder builder = efsPath.fs.getFileAttributesViewBuilder(new EphemeralFsPathProvider.ConstefsPathProvider(efsPath), CloseChecker.ALWAYS_OPEN, options);
            efsPath.fs.getAttributes().write(attribute, builder, value);
        }
    }

    @Override
    public Path readSymbolicLink(Path link) throws IOException {
        return this.getFs(link).readSymbolicLink(this.toEfsPath(link));
    }

    @Override
    public FileChannel newFileChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        return (FileChannel)this.newByteChannel(path, options, attrs);
    }

    @Override
    public AsynchronousFileChannel newAsynchronousFileChannel(Path path, Set<? extends OpenOption> options, ExecutorService executor, FileAttribute<?> ... attrs) throws IOException {
        return this.getFs(path).newAsynchronousByteChannel(this.toEfsPath(path), options, executor, attrs);
    }

    private EphemeralFsFileSystem getFs(Path p) {
        return this.toEfsPath(p).getFileSystem();
    }

    private EphemeralFsPath toEfsPath(Path p) {
        return (EphemeralFsPath)p;
    }

    void closing(EphemeralFsFileSystem efs) {
        fileSystems.remove(efs.getName(), efs);
    }

    private Class<? extends BasicFileAttributeView> viewClassFor(Class<? extends BasicFileAttributes> attributeClass) {
        if (attributeClass == BasicFileAttributes.class) {
            return BasicFileAttributeView.class;
        }
        if (attributeClass == PosixFileAttributes.class) {
            return PosixFileAttributeView.class;
        }
        if (attributeClass == DosFileAttributes.class) {
            return DosFileAttributeView.class;
        }
        throw new IllegalArgumentException("unrecognized view class:" + attributeClass);
    }

    private void assertSameFs(Path p1, Path p2) {
        if (p1.getFileSystem() != p2.getFileSystem()) {
            throw new IllegalArgumentException("paths have different file systems");
        }
    }
}

