/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbridges.ephemeralfs;

class EphemeralFsFileTimes {
    private long lastModifiedTime;
    private long creationTime;
    private long lastAccessTime;

    public EphemeralFsFileTimes() {
        this.setDefaultTimes();
    }

    private void setDefaultTimes() {
        this.lastAccessTime = this.creationTime = this.roundTime(System.currentTimeMillis());
        this.lastModifiedTime = this.creationTime;
    }

    private long roundTime(long timeMs) {
        return timeMs / 1000L * 1000L;
    }

    public void setLastModifiedTime(long timeMs) {
        this.lastModifiedTime = this.roundTime(timeMs);
    }

    public void setLastAccessTime(long timeMs) {
        this.lastAccessTime = this.roundTime(timeMs);
    }

    public void setCreationTime(long timeMs) {
        this.creationTime = this.roundTime(timeMs);
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("EphemeralFsFileTimes[lastModifiedTime=");
        builder.append(this.lastModifiedTime);
        builder.append(", creationTime=");
        builder.append(this.creationTime);
        builder.append(", lastAccessTime=");
        builder.append(this.lastAccessTime);
        builder.append("]");
        return builder.toString();
    }
}

