/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbridges.ephemeralfs;

import com.github.sbridges.ephemeralfs.EphemeralFsFileSystem;
import com.github.sbridges.ephemeralfs.EphemeralFsWatchKey;
import com.github.sbridges.ephemeralfs.EphemeralFsWatchService;
import com.github.sbridges.ephemeralfs.FileName;
import com.github.sbridges.ephemeralfs.ResolvedPath;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

class EphemeralFsPath
implements Path {
    final EphemeralFsFileSystem fs;
    private final String path;
    private List<String> cachedParts;

    private static String concat(String seperator, String first, String ... more) {
        StringBuilder builder = new StringBuilder();
        builder.append(first);
        for (String s : more) {
            if (s.isEmpty()) continue;
            if (builder.length() > 0) {
                builder.append(seperator);
            }
            builder.append(s);
        }
        String built = builder.toString();
        while (built.contains(seperator + seperator)) {
            built = built.replace(seperator + seperator, seperator);
        }
        return built;
    }

    EphemeralFsPath(EphemeralFsFileSystem fs, String first, String ... more) {
        this(fs, EphemeralFsPath.concat(fs.getSeparator(), first, more));
    }

    EphemeralFsPath(EphemeralFsFileSystem fs, String path) {
        if (path == null || fs == null) {
            throw new NullPointerException();
        }
        this.fs = fs;
        if (fs.getSettings().isPosix() && path.length() > 1 && path.endsWith(fs.getSeparator())) {
            path = path.substring(0, path.length() - 1);
        }
        if (!fs.getSettings().isPosix() && !path.matches("[A-Za-z]:\\\\") && path.endsWith(fs.getSeparator()) && path.length() > 1) {
            path = path.substring(0, path.length() - 1);
        }
        this.path = fs.getSettings().isPosix() ? path : path.replaceAll("/+", "\\\\");
        this.checkValidPath();
    }

    private void checkValidPath() {
        if (this.path.indexOf(0) != -1) {
            throw new InvalidPathException(this.path, "Nul character not allowed");
        }
    }

    @Override
    public EphemeralFsFileSystem getFileSystem() {
        return this.fs;
    }

    @Override
    public boolean isAbsolute() {
        return this.fs.getSettings().getAbsolutePathPattern().matcher(this.path).matches();
    }

    @Override
    public EphemeralFsPath getRoot() {
        if (!this.isAbsolute()) {
            return null;
        }
        return this.newPath(this.getRootString());
    }

    @Override
    public EphemeralFsPath getFileName() {
        List<String> parts = this.split();
        if (parts.isEmpty()) {
            return null;
        }
        return this.newPath(parts.get(parts.size() - 1));
    }

    @Override
    public EphemeralFsPath getParent() {
        List<String> parts = this.split();
        if (parts.isEmpty()) {
            return null;
        }
        if (!this.isAbsolute() && parts.size() == 1) {
            if (!this.fs.getSettings().isPosix() && this.path.startsWith("\\")) {
                return this.newPath("\\");
            }
            return null;
        }
        String newPath = EphemeralFsPath.join(this.fs, this.isAbsolute() ? this.getRootString() : null, parts.subList(0, parts.size() - 1));
        if (!this.fs.getSettings().isPosix() && this.path.startsWith("\\")) {
            newPath = "\\" + newPath;
        }
        return this.newPath(newPath);
    }

    @Override
    public int getNameCount() {
        return this.split().size();
    }

    @Override
    public EphemeralFsPath getName(int index) {
        List<String> parts = this.split();
        if (index < 0 || index >= parts.size()) {
            throw new IllegalArgumentException("invalid index:" + index + " nameCount:" + this.getNameCount());
        }
        return this.newPath(parts.get(index));
    }

    @Override
    public EphemeralFsPath subpath(int beginIndex, int endIndex) {
        List<String> parts = this.split();
        try {
            if (beginIndex >= parts.size()) {
                throw new IllegalArgumentException("beginIndex:" + beginIndex + " >=" + parts.size());
            }
            if (beginIndex >= endIndex) {
                throw new IllegalArgumentException("beginIndex:" + beginIndex + " >=" + endIndex);
            }
            return this.newPath(EphemeralFsPath.join(this.fs, null, parts.subList(beginIndex, endIndex)));
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public boolean startsWith(Path other) {
        if (other.getFileSystem() != this.getFileSystem()) {
            return false;
        }
        EphemeralFsPath otherFs = this.toEfsPath(other);
        if (this.isAbsolute() != other.isAbsolute()) {
            return false;
        }
        List<String> thisParts = this.split();
        List<String> otherParts = otherFs.split();
        if (otherParts.size() > thisParts.size()) {
            return false;
        }
        for (int i = 0; i < otherParts.size(); ++i) {
            if (this.areEqual(otherParts.get(i), thisParts.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean startsWith(String other) {
        return this.startsWith(this.newPath(other));
    }

    @Override
    public boolean endsWith(Path other) {
        if (other.getFileSystem() != this.getFileSystem()) {
            return false;
        }
        EphemeralFsPath otherFs = this.toEfsPath(other);
        List<String> thisParts = this.split();
        List<String> otherParts = otherFs.split();
        if (otherFs.isAbsolute()) {
            if (!this.isAbsolute()) {
                return false;
            }
            if (otherParts.size() != thisParts.size()) {
                return false;
            }
            for (int i = 0; i < otherParts.size(); ++i) {
                if (this.areEqual(otherParts.get(i), thisParts.get(i))) continue;
                return false;
            }
        } else {
            if (otherParts.size() > thisParts.size()) {
                return false;
            }
            int offset = thisParts.size() - otherParts.size();
            for (int i = 0; i < otherParts.size(); ++i) {
                if (this.areEqual(otherParts.get(i), thisParts.get(i + offset))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean endsWith(String other) {
        return this.endsWith(this.newPath(other));
    }

    @Override
    public EphemeralFsPath normalize() {
        return this.normalize(false);
    }

    public EphemeralFsPath normalize(boolean skipDots) {
        List<String> parts = this.split();
        ArrayList<String> normalizedParts = new ArrayList<String>();
        for (String s : parts) {
            if (!skipDots && s.equals(".")) continue;
            if (s.equals("..")) {
                if (!normalizedParts.isEmpty() && !((String)normalizedParts.get(normalizedParts.size() - 1)).equals("..")) {
                    normalizedParts.remove(normalizedParts.size() - 1);
                    continue;
                }
                if (this.isAbsolute()) continue;
                normalizedParts.add(s);
                continue;
            }
            normalizedParts.add(s);
        }
        if (normalizedParts.isEmpty() && !this.isAbsolute()) {
            normalizedParts.add("");
        }
        return this.newPath(EphemeralFsPath.join(this.fs, this.isAbsolute() ? this.getRootString() : null, normalizedParts));
    }

    @Override
    public EphemeralFsPath resolve(Path other) {
        EphemeralFsPath otherFs = this.toEfsPath(other);
        if (otherFs.isAbsolute()) {
            return otherFs;
        }
        if (otherFs.isEmpty()) {
            return this;
        }
        ArrayList<String> parts = new ArrayList<String>(this.split());
        parts.addAll(otherFs.split());
        String newPath = EphemeralFsPath.join(this.fs, this.isAbsolute() ? this.getRootString() : null, parts);
        if (!this.fs.getSettings().isPosix() && this.path.startsWith("\\")) {
            newPath = "\\" + newPath;
        }
        return this.newPath(newPath);
    }

    private boolean isEmpty() {
        return this.path.isEmpty();
    }

    @Override
    public EphemeralFsPath resolve(String other) {
        return this.resolve(this.newPath(other));
    }

    @Override
    public EphemeralFsPath resolveSibling(Path other) {
        this.toEfsPath(other);
        if (this.getParent() == null) {
            return (EphemeralFsPath)other;
        }
        if (other.isAbsolute()) {
            return (EphemeralFsPath)other;
        }
        return this.getParent().resolve(other);
    }

    @Override
    public EphemeralFsPath resolveSibling(String other) {
        return this.resolveSibling(this.newPath(other));
    }

    @Override
    public EphemeralFsPath relativize(Path other) {
        int j;
        String thisPart;
        String otherPart;
        EphemeralFsPath otherFs = this.toEfsPath(other);
        if (otherFs.equals(this)) {
            return this.newPath("");
        }
        if (this.isAbsolute() != other.isAbsolute()) {
            throw new IllegalArgumentException("paths must both be absolute, or not");
        }
        if (!this.fs.getSettings().isPosix() && this.path.startsWith("\\") != otherFs.path.startsWith("\\")) {
            throw new IllegalArgumentException("'other' is different type of Path");
        }
        if (this.isEmpty()) {
            return otherFs;
        }
        ArrayList<String> newParts = new ArrayList<String>();
        List<String> thisParts = this.split();
        List<String> otherParts = otherFs.split();
        for (int i = 0; i < thisParts.size() && i < otherParts.size() && (otherPart = otherParts.get(i)).equals(thisPart = thisParts.get(i)); ++i) {
        }
        for (j = i; j < thisParts.size(); ++j) {
            newParts.add("..");
        }
        for (j = i; j < otherParts.size(); ++j) {
            newParts.add(otherParts.get(j));
        }
        return this.newPath(EphemeralFsPath.join(this.fs, null, newParts));
    }

    @Override
    public URI toUri() {
        try {
            return new URI("ephemeralfs", null, this.toAbsolutePath().toString(), "name=" + this.fs.getName(), null);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public EphemeralFsPath toAbsolutePath() {
        if (this.isAbsolute()) {
            return this;
        }
        return this.fs.getRootPath().resolve(this);
    }

    @Override
    public EphemeralFsPath toRealPath(LinkOption ... options) throws IOException {
        boolean noFollow = false;
        for (LinkOption option : options) {
            if (option != LinkOption.NOFOLLOW_LINKS) continue;
            noFollow = true;
        }
        ResolvedPath resolved = ResolvedPath.resolve(this, noFollow);
        if (!resolved.didResolve()) {
            throw new NoSuchFileException(this.toString());
        }
        return resolved.getPath().toAbsolutePath();
    }

    @Override
    public File toFile() {
        throw new UnsupportedOperationException("You can only call toFile on Path's associated with the default provider");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        if (modifiers != null && modifiers.length != 0) {
            throw new IllegalStateException("unsupported modifiers");
        }
        Object object = this.fs.fsLock;
        synchronized (object) {
            ResolvedPath resolvedThis = ResolvedPath.resolve(this, false);
            if (!resolvedThis.hasTarget()) {
                throw new NoSuchFileException(this.toString());
            }
            if (!resolvedThis.getTarget().isDir()) {
                throw new NotDirectoryException(this.toString());
            }
            if (!(watcher instanceof EphemeralFsWatchService)) {
                throw new IllegalArgumentException("watcher not created by this fs");
            }
            EphemeralFsWatchService service = (EphemeralFsWatchService)watcher;
            if (service.getFs() != this.fs) {
                throw new IllegalArgumentException("watch service from different fs");
            }
            EphemeralFsWatchKey answer = new EphemeralFsWatchKey(service, this, resolvedThis.getTarget(), this.fs, events);
            this.fs.getWatchRegistry().register(resolvedThis.getTarget(), answer);
            return answer;
        }
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) throws IOException {
        return this.register(watcher, events, new WatchEvent.Modifier[0]);
    }

    @Override
    public Iterator<Path> iterator() {
        return this.splitPaths().iterator();
    }

    public List<EphemeralFsPath> splitPaths() {
        final List<String> parts = this.split();
        return new AbstractList<EphemeralFsPath>(){

            @Override
            public EphemeralFsPath get(int index) {
                return EphemeralFsPath.this.newPath((String)parts.get(index));
            }

            @Override
            public int size() {
                return parts.size();
            }
        };
    }

    @Override
    public int compareTo(Path other) {
        EphemeralFsPath otherPath = (EphemeralFsPath)other;
        return this.normalizedToString().compareTo(otherPath.normalizedToString());
    }

    @Override
    public int hashCode() {
        return this.normalizedToString().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EphemeralFsPath other = (EphemeralFsPath)obj;
        if (this.fs != other.fs) {
            return false;
        }
        return this.normalizedToString().equals(other.normalizedToString());
    }

    private String normalizedToString() {
        if (this.fs.getSettings().isWindows()) {
            return this.path.toLowerCase(Locale.ENGLISH);
        }
        return this.path;
    }

    @Override
    public String toString() {
        return this.path;
    }

    FileName toFileName() {
        EphemeralFsPath fileName = this.getFileName();
        if (this.fs.getSettings().caseSensitive()) {
            return new FileName(fileName.toString(), fileName);
        }
        return new FileName(this.getFileName().toString().toLowerCase(Locale.ENGLISH), fileName);
    }

    private EphemeralFsPath toEfsPath(Path other) {
        if (other == null) {
            throw new NullPointerException();
        }
        try {
            return (EphemeralFsPath)other;
        }
        catch (ClassCastException e) {
            throw new ProviderMismatchException();
        }
    }

    static String join(EphemeralFsFileSystem fs, String rootString, List<String> parts) {
        StringBuilder builder = new StringBuilder();
        if (rootString != null) {
            builder.append(rootString);
        }
        Iterator<String> iter = parts.iterator();
        while (iter.hasNext()) {
            String part = iter.next();
            if (part.isEmpty()) continue;
            builder.append(part);
            if (!iter.hasNext()) continue;
            builder.append(fs.getSettings().getSeperator());
        }
        return builder.toString();
    }

    List<String> split() {
        if (this.path == null) {
            throw new NullPointerException();
        }
        if (this.path.isEmpty()) {
            return Collections.singletonList("");
        }
        if (this.cachedParts != null) {
            return this.cachedParts;
        }
        ArrayList<String> parts = new ArrayList<String>();
        parts.addAll(Arrays.asList(this.fs.getSettings().getSeperatorPattern().split(this.path)));
        Iterator iter = parts.iterator();
        while (iter.hasNext()) {
            if (!((String)iter.next()).isEmpty()) continue;
            iter.remove();
        }
        if (!parts.isEmpty() && this.isAbsolute() && !this.fs.getSettings().isPosix()) {
            parts.remove(0);
        }
        this.cachedParts = Collections.unmodifiableList(parts);
        return this.cachedParts;
    }

    static boolean isAbsolute(EphemeralFsFileSystem fs, String path) {
        return fs.getSettings().getAbsolutePathPattern().matcher(path).matches();
    }

    boolean areEqual(String path1, String path2) {
        if (this.fs.getSettings().caseSensitive()) {
            return path1.equals(path2);
        }
        return path1.toLowerCase(Locale.ENGLISH).equals(path2.toLowerCase(Locale.ENGLISH));
    }

    String getRootString() {
        if (!this.fs.getSettings().isPosix()) {
            return this.path.substring(0, this.path.indexOf(":")) + ":" + this.fs.getSeparator();
        }
        return this.fs.getSettings().getRoot();
    }

    private EphemeralFsPath newPath(String path) {
        return new EphemeralFsPath(this.fs, path);
    }
}

