/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbridges.ephemeralfs;

import com.github.sbridges.ephemeralfs.CloseChecker;
import com.github.sbridges.ephemeralfs.CloseTracker;
import com.github.sbridges.ephemeralfs.EphemeralFsPath;
import com.github.sbridges.ephemeralfs.EphemeralFsPathProvider;
import com.github.sbridges.ephemeralfs.INode;
import com.github.sbridges.ephemeralfs.ResolvedPath;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.ClosedDirectoryStreamException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystemException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SecureDirectoryStream;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

class EphemeralFsSecureDirectoryStream
implements SecureDirectoryStream<Path> {
    private boolean used = false;
    private volatile boolean closed = false;
    private final List<Path> paths;
    private final EphemeralFsPath myPath;
    private final INode myDirectory;
    private final CloseChecker closeChecker = new CloseChecker(){

        @Override
        public void assertNotClosed() throws FileSystemException {
            if (EphemeralFsSecureDirectoryStream.this.closed) {
                throw new ClosedDirectoryStreamException();
            }
        }
    };
    private final CloseTracker closeTracker;

    public static DirectoryStream<Path> makeDirectoryStream(INode directory, EphemeralFsPath path, List<Path> paths) {
        EphemeralFsSecureDirectoryStream answer = new EphemeralFsSecureDirectoryStream(directory, path, paths);
        if (directory.getFs().getSettings().isWindows() || directory.getFs().getSettings().isMac()) {
            return answer.nonSecure();
        }
        return answer;
    }

    private EphemeralFsSecureDirectoryStream(INode directory, EphemeralFsPath path, List<Path> paths) {
        this.paths = new ArrayList<Path>(paths);
        this.myDirectory = directory;
        this.myPath = path;
        this.closeTracker = path.getFileSystem().trackClose(DirectoryStream.class, path);
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.closeTracker.onClose();
    }

    @Override
    public Iterator<Path> iterator() {
        if (this.used) {
            throw new IllegalStateException("you can only iterate once over a DirectoryStream");
        }
        if (this.closed) {
            throw new IllegalStateException("already closed");
        }
        this.used = true;
        return new Iterator<Path>(){
            final Iterator<Path> delegate;
            Path peeked;
            {
                this.delegate = EphemeralFsSecureDirectoryStream.this.paths.iterator();
            }

            @Override
            public boolean hasNext() {
                if (EphemeralFsSecureDirectoryStream.this.closed) {
                    this.empty();
                }
                if (this.peeked != null) {
                    return true;
                }
                if (this.delegate.hasNext()) {
                    this.peeked = this.delegate.next();
                    return true;
                }
                return false;
            }

            @Override
            public Path next() {
                if (EphemeralFsSecureDirectoryStream.this.closed) {
                    this.empty();
                }
                if (this.peeked != null) {
                    Path answer = this.peeked;
                    this.peeked = null;
                    return answer;
                }
                return this.delegate.next();
            }

            private void empty() {
                while (this.delegate.hasNext()) {
                    this.delegate.next();
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SecureDirectoryStream<Path> newDirectoryStream(Path path, LinkOption ... options) throws IOException {
        EphemeralFsPath efsPath = this.cast(path);
        Object object = efsPath.fs.fsLock;
        synchronized (object) {
            EphemeralFsPath actualPath = this.translate(efsPath);
            for (LinkOption option : options) {
                ResolvedPath resolved;
                if (option != LinkOption.NOFOLLOW_LINKS || !(resolved = ResolvedPath.resolve(actualPath, true)).resolvedToSymbolicLink()) continue;
                throw new FileSystemException(path + ": Too many levels of symbolic links");
            }
            return (SecureDirectoryStream)actualPath.fs.newDirectoryStream(actualPath, efsPath.isAbsolute() ? efsPath : this.myPath.resolve(efsPath), (DirectoryStream.Filter<? super Path>)new DirectoryStream.Filter<Path>(){

                @Override
                public boolean accept(Path entry) throws IOException {
                    return true;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        EphemeralFsPath efsPath = this.cast(path);
        Object object = efsPath.fs.fsLock;
        synchronized (object) {
            EphemeralFsPath actualPath = this.translate(efsPath);
            return efsPath.fs.newByteChannel(actualPath, options, attrs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteFile(Path path) throws IOException {
        EphemeralFsPath efsPath = this.cast(path);
        Object object = efsPath.fs.fsLock;
        synchronized (object) {
            EphemeralFsPath actualPath = this.translate(efsPath);
            if (actualPath == null) {
                throw new NoSuchFileException(path.toString());
            }
            ResolvedPath resolved = ResolvedPath.resolve(actualPath, true);
            if (resolved.hasTarget() && resolved.getTarget().isDir()) {
                throw new FileSystemException(path + ": Is a directory");
            }
            actualPath.fs.delete(actualPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteDirectory(Path path) throws IOException {
        EphemeralFsPath efsPath = this.cast(path);
        Object object = efsPath.fs.fsLock;
        synchronized (object) {
            EphemeralFsPath actualPath = this.translate(efsPath);
            if (actualPath == null) {
                throw new NoSuchFileException(path.toString());
            }
            ResolvedPath resolved = ResolvedPath.resolve(actualPath, true);
            if (resolved.resolvedToSymbolicLink()) {
                throw new FileSystemException("symlink: Not a directory");
            }
            if (!resolved.getTarget().isDir()) {
                throw new FileSystemException(path + ": Not a directory");
            }
            actualPath.fs.delete(actualPath);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void move(Path srcpath, SecureDirectoryStream<Path> targetdir, Path targetpath) throws IOException {
        EphemeralFsPath efsSrcPath = this.cast(srcpath);
        EphemeralFsPath efsTargetPath = this.cast(targetpath);
        EphemeralFsSecureDirectoryStream efsTargetDir = this.cast(targetdir);
        Object object = efsSrcPath.fs.fsLock;
        synchronized (object) {
            EphemeralFsPath actualSrcPath = this.translate(efsSrcPath);
            EphemeralFsPath actualTargetPath = efsTargetDir.translate(efsTargetPath);
            efsSrcPath.fs.move(actualSrcPath, actualTargetPath, new CopyOption[]{StandardCopyOption.ATOMIC_MOVE});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Class<V> type) {
        Object object = this.myPath.fs.fsLock;
        synchronized (object) {
            return this.myPath.fs.getFileAttributeView(new EphemeralFsPathProvider(){

                @Override
                public EphemeralFsPath get() {
                    return EphemeralFsSecureDirectoryStream.this.myDirectory.getPathToRoot();
                }
            }, type, this.closeChecker, new LinkOption[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        final EphemeralFsPath efsPath = this.cast(path);
        Object object = efsPath.fs.fsLock;
        synchronized (object) {
            return efsPath.fs.getFileAttributeView(new EphemeralFsPathProvider(){

                @Override
                public EphemeralFsPath get() {
                    return EphemeralFsSecureDirectoryStream.this.translate(efsPath);
                }
            }, type, this.closeChecker, options);
        }
    }

    private EphemeralFsPath cast(Path p) {
        if (p.getFileSystem() != this.myPath.fs) {
            throw new IllegalStateException("wrong fs");
        }
        return (EphemeralFsPath)p;
    }

    private EphemeralFsSecureDirectoryStream cast(SecureDirectoryStream<Path> p) {
        if (!(p instanceof EphemeralFsSecureDirectoryStream)) {
            throw new IllegalStateException("wrong file system:" + p);
        }
        EphemeralFsSecureDirectoryStream answer = (EphemeralFsSecureDirectoryStream)p;
        if (answer.myPath.fs != this.myPath.fs) {
            throw new IllegalStateException("wrong fs");
        }
        return answer;
    }

    private EphemeralFsPath translate(EphemeralFsPath path) {
        if (path.isAbsolute()) {
            return path;
        }
        EphemeralFsPath pathToRoot = this.myDirectory.getPathToRoot();
        if (pathToRoot == null) {
            return null;
        }
        return pathToRoot.resolve(path);
    }

    private DirectoryStream<Path> nonSecure() {
        return new DirectoryStream<Path>(){

            @Override
            public void close() throws IOException {
                EphemeralFsSecureDirectoryStream.this.close();
            }

            @Override
            public Iterator<Path> iterator() {
                return EphemeralFsSecureDirectoryStream.this.iterator();
            }
        };
    }
}

