/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbridges.ephemeralfs;

import com.github.sbridges.ephemeralfs.EphemeralFsGroupPrincipal;
import com.github.sbridges.ephemeralfs.EphemeralFsUserPrincipal;
import java.io.IOException;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.attribute.UserPrincipalNotFoundException;

class EphemeralFsUserPrincipalLookupService
extends UserPrincipalLookupService {
    public static final String DEFAULT_USER = "username";
    public static final String DEFAULT_GROUP = "group";
    public final UserPrincipal userPrincipal = new EphemeralFsUserPrincipal("username", 1001);
    public final GroupPrincipal groupPrincipal = new EphemeralFsGroupPrincipal("group", 2001);

    EphemeralFsUserPrincipalLookupService() {
    }

    @Override
    public UserPrincipal lookupPrincipalByName(String name) throws IOException {
        if (name.equals(this.userPrincipal.getName())) {
            return this.userPrincipal;
        }
        throw new UserPrincipalNotFoundException(name);
    }

    @Override
    public GroupPrincipal lookupPrincipalByGroupName(String group) throws IOException {
        if (group.equals(this.groupPrincipal.getName())) {
            return this.groupPrincipal;
        }
        throw new UserPrincipalNotFoundException(group);
    }
}

