/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbridges.ephemeralfs;

import java.nio.file.Path;
import java.nio.file.WatchEvent;

class EphemeralFsWatchEvent
implements WatchEvent<Path> {
    private final Path path;
    private final WatchEvent.Kind<Path> kind;
    private int count;

    EphemeralFsWatchEvent(Path path, WatchEvent.Kind<Path> kind) {
        this.path = path;
        this.kind = kind;
        this.count = 1;
    }

    @Override
    public WatchEvent.Kind<Path> kind() {
        return this.kind;
    }

    @Override
    public int count() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    @Override
    public Path context() {
        return this.path.getFileName();
    }

    public boolean isSame(EphemeralFsWatchEvent other) {
        return other.path.equals(this.path) && other.kind.equals(this.kind);
    }

    public void addCount(EphemeralFsWatchEvent other) {
        this.count += other.count;
    }
}

