/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbridges.ephemeralfs;

import com.github.sbridges.ephemeralfs.EphemeralFsFileSystem;
import com.github.sbridges.ephemeralfs.EphemeralFsPath;
import com.github.sbridges.ephemeralfs.EphemeralFsWatchEvent;
import com.github.sbridges.ephemeralfs.EphemeralFsWatchService;
import com.github.sbridges.ephemeralfs.INode;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.Watchable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class EphemeralFsWatchKey
implements WatchKey {
    private final EphemeralFsWatchService watchService;
    private final INode iNode;
    private final Watchable watchable;
    private final Set<WatchEvent.Kind<?>> interestOps;
    private final List<EphemeralFsWatchEvent> events = new ArrayList<EphemeralFsWatchEvent>();
    private boolean cancelled = false;
    private boolean triggered = false;
    private final EphemeralFsFileSystem fs;

    EphemeralFsWatchKey(EphemeralFsWatchService watchService, EphemeralFsPath watchable, INode iNode, EphemeralFsFileSystem fs, WatchEvent.Kind<?> ... events) {
        this.watchService = watchService;
        if (!watchable.isAbsolute()) {
            throw new IllegalArgumentException("path must be absolute");
        }
        this.watchable = watchable;
        this.iNode = iNode;
        this.fs = fs;
        this.interestOps = new HashSet();
        for (WatchEvent.Kind<?> event : events) {
            this.interestOps.add(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid() {
        Object object = this.fs.fsLock;
        synchronized (object) {
            if (this.cancelled) {
                return false;
            }
            return !this.watchService.isClosed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WatchEvent<?>> pollEvents() {
        Object object = this.fs.fsLock;
        synchronized (object) {
            ArrayList answer = new ArrayList();
            answer.addAll(this.events);
            this.events.clear();
            return answer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean reset() {
        Object object = this.fs.fsLock;
        synchronized (object) {
            if (!this.iNode.exists()) {
                return false;
            }
            if (!this.isValid()) {
                return false;
            }
            if (!this.events.isEmpty()) {
                this.triggered = true;
                this.watchService.queue(this);
            } else {
                this.triggered = false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Object object = this.fs.fsLock;
        synchronized (object) {
            this.cancelled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hear(EphemeralFsWatchEvent e) {
        Object object = this.fs.fsLock;
        synchronized (object) {
            if (!this.isValid()) {
                return;
            }
            boolean consumed = false;
            for (EphemeralFsWatchEvent existing : this.events) {
                if (!existing.isSame(e)) continue;
                existing.addCount(e);
                consumed = true;
                break;
            }
            if (!consumed) {
                this.events.add(e);
            }
            if (!this.triggered) {
                this.triggered = true;
                this.watchService.queue(this);
            }
        }
    }

    @Override
    public Watchable watchable() {
        return this.watchable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTriggered() {
        Object object = this.fs.fsLock;
        synchronized (object) {
            this.triggered = true;
        }
    }
}

