/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbridges.ephemeralfs;

import com.github.sbridges.ephemeralfs.CloseTracker;
import com.github.sbridges.ephemeralfs.EphemeralFsFileSystem;
import com.github.sbridges.ephemeralfs.EphemeralFsWatchKey;
import java.io.IOException;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

class EphemeralFsWatchService
implements WatchService {
    private final EphemeralFsFileSystem fs;
    private boolean closed = false;
    private final LinkedBlockingQueue<EphemeralFsWatchKey> queue = new LinkedBlockingQueue();
    private final CloseTracker closeTracker;

    public EphemeralFsFileSystem getFs() {
        return this.fs;
    }

    public EphemeralFsWatchService(EphemeralFsFileSystem fs) {
        this.fs = fs;
        this.closeTracker = fs.trackClose(EphemeralFsWatchService.class, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.fs.fsLock;
        synchronized (object) {
            this.closed = true;
        }
        this.closeTracker.onClose();
    }

    @Override
    public WatchKey poll() {
        EphemeralFsWatchKey answer = this.queue.poll();
        if (answer != null) {
            answer.setTriggered();
        }
        return answer;
    }

    @Override
    public WatchKey poll(long timeout, TimeUnit unit) throws InterruptedException {
        EphemeralFsWatchKey answer = this.queue.poll(timeout, unit);
        if (answer != null) {
            answer.setTriggered();
        }
        return answer;
    }

    @Override
    public WatchKey take() throws InterruptedException {
        EphemeralFsWatchKey answer = this.queue.take();
        if (answer != null) {
            answer.setTriggered();
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isClosed() {
        Object object = this.fs.fsLock;
        synchronized (object) {
            return this.closed;
        }
    }

    public void queue(EphemeralFsWatchKey efsWatchKey) {
        this.queue.add(efsWatchKey);
    }
}

