/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbridges.ephemeralfs;

import com.github.sbridges.ephemeralfs.EphemeralFsFileSystem;
import com.github.sbridges.ephemeralfs.EphemeralFsGroupPrincipal;
import com.github.sbridges.ephemeralfs.EphemeralFsUserPrincipal;
import com.github.sbridges.ephemeralfs.EphemeralFsUserPrincipalLookupService;
import com.github.sbridges.ephemeralfs.FileProperties;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;

class FileAttributesSnapshot {
    private final EphemeralFsFileSystem fs;
    private final long lastModifiedTime;
    private final long lastAccessTime;
    private final long creationTime;
    private final boolean regularFile;
    private final boolean directory;
    private final boolean symbolicLink;
    private final boolean other;
    private final long size;
    private final Object key;
    private final Long iNodeNumber;
    private final Set<PosixFilePermission> permissions;
    private final boolean dosIsArchive;
    private final boolean dosIsHidden;
    private final boolean dosIsReadOnly;
    private final boolean dosIsSystem;
    private final EphemeralFsUserPrincipal owner;
    private final GroupPrincipal group;
    private final int nLink;

    public FileAttributesSnapshot(boolean regularFile, boolean directory, boolean symbolicLink, boolean other, long size, int nLink, FileProperties fileProperties) {
        this.fs = fileProperties.getFs();
        this.creationTime = fileProperties.getFileTimes().getCreationTime();
        this.lastModifiedTime = fileProperties.getFileTimes().getLastModifiedTime();
        this.lastAccessTime = fileProperties.getFileTimes().getLastAccessTime();
        this.regularFile = regularFile;
        this.directory = directory;
        this.symbolicLink = symbolicLink;
        this.other = other;
        this.size = size;
        this.nLink = nLink;
        this.key = fileProperties.getiNodeNumber();
        this.permissions = Collections.unmodifiableSet(EnumSet.copyOf(fileProperties.getFilePermissions().toPosixFilePermissions()));
        this.dosIsArchive = fileProperties.getDosIsArchive();
        this.dosIsHidden = fileProperties.getDosIsHidden();
        this.dosIsReadOnly = fileProperties.getDosIsReadOnly();
        this.dosIsSystem = fileProperties.getDosIsSystem();
        this.owner = fileProperties.getOwner();
        this.group = fileProperties.getGroup();
        this.iNodeNumber = fileProperties.getiNodeNumber();
    }

    public boolean isRegularFile() {
        return this.regularFile;
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public boolean isSymbolicLink() {
        return this.symbolicLink;
    }

    public boolean isOther() {
        return this.other;
    }

    public FileTime lastModifiedTime() {
        return FileTime.from(this.lastModifiedTime, TimeUnit.MILLISECONDS);
    }

    public FileTime lastAccessTime() {
        return FileTime.from(this.lastAccessTime, TimeUnit.MILLISECONDS);
    }

    public FileTime creationTime() {
        return FileTime.from(this.creationTime, TimeUnit.MILLISECONDS);
    }

    public long size() {
        return this.size;
    }

    public Object fileKey() {
        return this.key;
    }

    public Set<PosixFilePermission> permissions() {
        return this.permissions;
    }

    public EphemeralFsUserPrincipal getOwner() {
        return this.owner;
    }

    public EphemeralFsGroupPrincipal getGroup() {
        return (EphemeralFsGroupPrincipal)this.group;
    }

    public <V extends BasicFileAttributes> V cast(Class<V> type) {
        if (type == BasicFileAttributes.class) {
            return (V)new EphemeralFsBasicFileAttributes();
        }
        if (type == PosixFileAttributes.class) {
            return (V)new EphemeralFsPosixFileAttributes();
        }
        if (type == DosFileAttributes.class) {
            return (V)new EphemeralFsDosFileAttributes();
        }
        throw new UnsupportedOperationException("type:" + type + " is not supported");
    }

    public Long getINodeNumber() {
        return this.iNodeNumber;
    }

    public int getNLink() {
        return this.nLink;
    }

    class EphemeralFsDosFileAttributes
    extends EphemeralFsBasicFileAttributes
    implements DosFileAttributes {
        EphemeralFsDosFileAttributes() {
        }

        @Override
        public boolean isReadOnly() {
            return FileAttributesSnapshot.this.dosIsReadOnly;
        }

        @Override
        public boolean isHidden() {
            return FileAttributesSnapshot.this.dosIsHidden;
        }

        @Override
        public boolean isArchive() {
            return FileAttributesSnapshot.this.dosIsArchive;
        }

        @Override
        public boolean isSystem() {
            return FileAttributesSnapshot.this.dosIsSystem;
        }
    }

    class EphemeralFsPosixFileAttributes
    extends EphemeralFsBasicFileAttributes
    implements PosixFileAttributes {
        EphemeralFsPosixFileAttributes() {
        }

        @Override
        public UserPrincipal owner() {
            return FileAttributesSnapshot.this.owner;
        }

        @Override
        public GroupPrincipal group() {
            return ((EphemeralFsUserPrincipalLookupService)((FileAttributesSnapshot)FileAttributesSnapshot.this).fs.getUserPrincipalLookupService()).groupPrincipal;
        }

        @Override
        public Set<PosixFilePermission> permissions() {
            return FileAttributesSnapshot.this.permissions;
        }
    }

    class EphemeralFsBasicFileAttributes
    implements BasicFileAttributes {
        EphemeralFsBasicFileAttributes() {
        }

        @Override
        public FileTime lastModifiedTime() {
            return FileAttributesSnapshot.this.lastModifiedTime();
        }

        @Override
        public FileTime lastAccessTime() {
            return FileAttributesSnapshot.this.lastAccessTime();
        }

        @Override
        public FileTime creationTime() {
            return FileAttributesSnapshot.this.creationTime();
        }

        @Override
        public boolean isRegularFile() {
            return FileAttributesSnapshot.this.isRegularFile();
        }

        @Override
        public boolean isDirectory() {
            return FileAttributesSnapshot.this.isDirectory();
        }

        @Override
        public boolean isSymbolicLink() {
            return FileAttributesSnapshot.this.isSymbolicLink();
        }

        @Override
        public boolean isOther() {
            return FileAttributesSnapshot.this.isOther();
        }

        @Override
        public long size() {
            return FileAttributesSnapshot.this.size();
        }

        @Override
        public Object fileKey() {
            return FileAttributesSnapshot.this.fileKey();
        }
    }
}

