/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbridges.ephemeralfs;

import com.github.sbridges.ephemeralfs.CloseChecker;
import com.github.sbridges.ephemeralfs.DirectoryEntry;
import com.github.sbridges.ephemeralfs.EphemeralFsFileSystem;
import com.github.sbridges.ephemeralfs.EphemeralFsPath;
import com.github.sbridges.ephemeralfs.EphemeralFsPathProvider;
import com.github.sbridges.ephemeralfs.FileAttributesSnapshot;
import com.github.sbridges.ephemeralfs.ResolvedPath;
import java.io.IOException;
import java.nio.file.FileSystemException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.Set;

class FileAttributesViewBuilder {
    protected final EphemeralFsFileSystem fs;
    protected final EphemeralFsPathProvider pathProvider;
    protected final boolean noFollowLinks;
    protected final CloseChecker closeChecker;

    public FileAttributesViewBuilder(EphemeralFsFileSystem fs, EphemeralFsPathProvider path, CloseChecker closeChecker, LinkOption ... linkOptions) {
        this.fs = fs;
        this.pathProvider = path;
        this.closeChecker = closeChecker;
        boolean hasNoFollow = false;
        for (LinkOption opt : linkOptions) {
            if (opt != LinkOption.NOFOLLOW_LINKS) continue;
            hasNoFollow = true;
        }
        this.noFollowLinks = hasNoFollow;
    }

    public <V extends FileAttributeView> V build(Class<V> type) {
        if (type == BasicFileAttributeView.class) {
            return (V)new EphemeralFsBasicFileAttributesView();
        }
        if (type == PosixFileAttributeView.class) {
            return (V)new EphemeralFsPosixFileAttributesView();
        }
        if (type == DosFileAttributeView.class) {
            return (V)new EphemeralFsDosFileAttributesView();
        }
        if (type == FileOwnerAttributeView.class) {
            return (V)new EphemeralFsFileOwnerAttributeView();
        }
        throw new UnsupportedOperationException("type:" + type + " is not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FileAttributesSnapshot snapshotProperties() throws IOException {
        Object object = this.fs.fsLock;
        synchronized (object) {
            this.closeChecker.assertNotClosed();
            EphemeralFsPath path = this.pathProvider.get();
            ResolvedPath resolved = this.resolve(path);
            if (resolved.resolvedToSymbolicLink()) {
                DirectoryEntry entry = resolved.getParent().resolve(path.getFileName());
                return new FileAttributesSnapshot(false, false, true, false, 1L, 1, entry.getLinkProperties());
            }
            return resolved.getTarget().getAttributes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) throws IOException {
        this.closeChecker.assertNotClosed();
        Object object = this.fs.fsLock;
        synchronized (object) {
            ResolvedPath rs = this.resolve(this.pathProvider.get());
            if (!rs.resolvedToSymbolicLink()) {
                if (lastModifiedTime != null) {
                    rs.getResolvedProperties().getFileTimes().setLastModifiedTime(lastModifiedTime.toMillis());
                }
                if (createTime != null) {
                    rs.getResolvedProperties().getFileTimes().setCreationTime(createTime.toMillis());
                }
                if (lastAccessTime != null) {
                    rs.getResolvedProperties().getFileTimes().setLastModifiedTime(lastAccessTime.toMillis());
                }
                rs.getTarget().notifyChange(rs.getPath());
            }
        }
    }

    private ResolvedPath resolve(EphemeralFsPath path) throws FileSystemException, NoSuchFileException {
        ResolvedPath resolved = ResolvedPath.resolve(path, this.noFollowLinks);
        if (!resolved.didResolve()) {
            throw new NoSuchFileException(this.pathProvider.toString());
        }
        return resolved;
    }

    class EphemeralFsFileOwnerAttributeView
    implements FileOwnerAttributeView {
        EphemeralFsFileOwnerAttributeView() {
        }

        @Override
        public String name() {
            return "owner";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public UserPrincipal getOwner() throws IOException {
            FileAttributesViewBuilder.this.closeChecker.assertNotClosed();
            Object object = FileAttributesViewBuilder.this.fs.fsLock;
            synchronized (object) {
                ResolvedPath rs = FileAttributesViewBuilder.this.resolve(FileAttributesViewBuilder.this.pathProvider.get());
                return rs.getResolvedProperties().getOwner();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setOwner(UserPrincipal owner) throws IOException {
            FileAttributesViewBuilder.this.closeChecker.assertNotClosed();
            Object object = FileAttributesViewBuilder.this.fs.fsLock;
            synchronized (object) {
                ResolvedPath rs = FileAttributesViewBuilder.this.resolve(FileAttributesViewBuilder.this.pathProvider.get());
                rs.getResolvedProperties().setOwner(owner);
            }
        }
    }

    class EphemeralFsDosFileAttributesView
    implements DosFileAttributeView {
        EphemeralFsDosFileAttributesView() {
        }

        @Override
        public void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) throws IOException {
            FileAttributesViewBuilder.this.setTimes(lastModifiedTime, lastAccessTime, createTime);
        }

        @Override
        public DosFileAttributes readAttributes() throws IOException {
            return FileAttributesViewBuilder.this.snapshotProperties().cast(DosFileAttributes.class);
        }

        @Override
        public String name() {
            return "dos";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setReadOnly(boolean value) throws IOException {
            FileAttributesViewBuilder.this.closeChecker.assertNotClosed();
            Object object = FileAttributesViewBuilder.this.fs.fsLock;
            synchronized (object) {
                ResolvedPath rs = FileAttributesViewBuilder.this.resolve(FileAttributesViewBuilder.this.pathProvider.get());
                rs.getResolvedProperties().setDosIsReadOnly(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setHidden(boolean value) throws IOException {
            FileAttributesViewBuilder.this.closeChecker.assertNotClosed();
            Object object = FileAttributesViewBuilder.this.fs.fsLock;
            synchronized (object) {
                ResolvedPath rs = FileAttributesViewBuilder.this.resolve(FileAttributesViewBuilder.this.pathProvider.get());
                rs.getResolvedProperties().setDosIsHidden(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setSystem(boolean value) throws IOException {
            FileAttributesViewBuilder.this.closeChecker.assertNotClosed();
            Object object = FileAttributesViewBuilder.this.fs.fsLock;
            synchronized (object) {
                ResolvedPath rs = FileAttributesViewBuilder.this.resolve(FileAttributesViewBuilder.this.pathProvider.get());
                rs.getResolvedProperties().setDosIsSystem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setArchive(boolean value) throws IOException {
            FileAttributesViewBuilder.this.closeChecker.assertNotClosed();
            Object object = FileAttributesViewBuilder.this.fs.fsLock;
            synchronized (object) {
                ResolvedPath rs = FileAttributesViewBuilder.this.resolve(FileAttributesViewBuilder.this.pathProvider.get());
                rs.getResolvedProperties().setDosIsArchive(value);
            }
        }
    }

    class EphemeralFsPosixFileAttributesView
    implements PosixFileAttributeView {
        EphemeralFsPosixFileAttributesView() {
        }

        @Override
        public void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) throws IOException {
            FileAttributesViewBuilder.this.setTimes(lastModifiedTime, lastAccessTime, createTime);
        }

        @Override
        public PosixFileAttributes readAttributes() throws IOException {
            return FileAttributesViewBuilder.this.snapshotProperties().cast(PosixFileAttributes.class);
        }

        @Override
        public String name() {
            return "posix";
        }

        @Override
        public UserPrincipal getOwner() throws IOException {
            return this.readAttributes().owner();
        }

        @Override
        public void setOwner(UserPrincipal owner) throws IOException {
            if (owner != this.getOwner()) {
                throw new UnsupportedOperationException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setPermissions(Set<PosixFilePermission> perms) throws IOException {
            Object object = FileAttributesViewBuilder.this.fs.fsLock;
            synchronized (object) {
                EphemeralFsPath path = FileAttributesViewBuilder.this.pathProvider.get();
                ResolvedPath resolved = FileAttributesViewBuilder.this.resolve(path);
                if (!resolved.hasTarget()) {
                    throw new UnsupportedOperationException();
                }
                resolved.getTarget().setPermissions(perms);
            }
        }

        @Override
        public void setGroup(GroupPrincipal group) throws IOException {
            if (group != this.readAttributes().group()) {
                throw new UnsupportedOperationException();
            }
        }
    }

    class EphemeralFsBasicFileAttributesView
    implements BasicFileAttributeView {
        EphemeralFsBasicFileAttributesView() {
        }

        @Override
        public void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) throws IOException {
            FileAttributesViewBuilder.this.setTimes(lastModifiedTime, lastAccessTime, createTime);
        }

        @Override
        public BasicFileAttributes readAttributes() throws IOException {
            return FileAttributesViewBuilder.this.snapshotProperties().cast(BasicFileAttributes.class);
        }

        @Override
        public String name() {
            return "basic";
        }
    }
}

