/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbridges.ephemeralfs;

import com.github.sbridges.ephemeralfs.EphemeralFsFileChannel;
import com.github.sbridges.ephemeralfs.EphemeralFsFileLock;
import com.github.sbridges.ephemeralfs.EphemeralFsFileSystem;
import com.github.sbridges.ephemeralfs.INode;
import com.github.sbridges.ephemeralfs.ResolvedPath;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class FileContents {
    static final int INITIAL_BUFFER_SIZE = 1024;
    final Object lock = new Object();
    private ByteBuffer contents;
    private final EphemeralFsFileSystem fs;
    private int size = 0;
    private final List<EphemeralFsFileLock> locks = new ArrayList<EphemeralFsFileLock>();
    private final INode iNode;
    private boolean isDirty = true;

    public FileContents(EphemeralFsFileSystem fs, INode iNode) {
        this.fs = fs;
        this.iNode = iNode;
        this.createNewBuffer(1024, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EphemeralFsFileChannel newChannel(boolean canRead, boolean canWrite, boolean append, boolean deleteOnClose, boolean truncate, boolean sync, ResolvedPath resolvedPath, EphemeralFsFileSystem fs) {
        if (!canRead && !canWrite) {
            throw new IllegalArgumentException("can't read or write?");
        }
        Object object = fs.fsLock;
        synchronized (object) {
            this.iNode.addOpenFileHandle();
        }
        object = this.lock;
        synchronized (object) {
            EphemeralFsFileChannel answer = new EphemeralFsFileChannel(this, canRead, canWrite, deleteOnClose, sync, resolvedPath, fs);
            if (append) {
                try {
                    answer.position(this.size);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
            if (truncate) {
                try {
                    this.setSize(0);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
                this.createNewBuffer(1024, false);
            }
            return answer;
        }
    }

    public void setSize(int newSize) throws IOException {
        if (newSize == this.size) {
            return;
        }
        if (newSize > this.size) {
            this.fs.getLimits().tryAcquireDiskSpace(newSize - this.size);
        } else {
            this.fs.getLimits().releaseDiskSpace(this.size - newSize);
        }
        this.size = newSize;
    }

    public void createNewBuffer(int newSize, boolean copyOld) {
        ByteBuffer newContents = ByteBuffer.allocate(newSize);
        if (copyOld && this.size > 0) {
            this.contents.position(0);
            this.contents.limit(this.size);
            newContents.put(this.contents);
        }
        this.contents = newContents;
    }

    public ByteBuffer getContents() {
        return this.contents;
    }

    public FileLock tryLock(Channel channel, long start, long size, boolean shared) throws IOException {
        if (!channel.isOpen()) {
            throw new ClosedChannelException();
        }
        Iterator<EphemeralFsFileLock> iter = this.locks.iterator();
        while (iter.hasNext()) {
            EphemeralFsFileLock oldLock = iter.next();
            if (!oldLock.isValid()) {
                iter.remove();
                continue;
            }
            if (!oldLock.overlaps(start, size)) continue;
            throw new OverlappingFileLockException();
        }
        EphemeralFsFileLock newLock = channel instanceof FileChannel ? new EphemeralFsFileLock((FileChannel)channel, start, size, shared) : new EphemeralFsFileLock((AsynchronousFileChannel)channel, start, size, shared);
        this.locks.add(newLock);
        return newLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        Object object = this.lock;
        synchronized (object) {
            return this.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDirty(boolean dirty) {
        Object object = this.lock;
        synchronized (object) {
            this.isDirty = dirty;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirty() {
        Object object = this.lock;
        synchronized (object) {
            return this.isDirty;
        }
    }
}

