/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbridges.ephemeralfs;

import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;

class FilePermissions {
    private final EnumSet<PosixFilePermission> permissions;

    public static FilePermissions createDefaultFile() {
        return new FilePermissions(EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_WRITE, PosixFilePermission.OTHERS_READ));
    }

    public static FilePermissions createDefaultDirectory() {
        return new FilePermissions(EnumSet.of(PosixFilePermission.OWNER_READ, new PosixFilePermission[]{PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_WRITE, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_READ, PosixFilePermission.OTHERS_EXECUTE}));
    }

    public static FilePermissions createDefaultSymlink() {
        return new FilePermissions(EnumSet.of(PosixFilePermission.OWNER_READ, new PosixFilePermission[]{PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_WRITE, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_READ, PosixFilePermission.OTHERS_WRITE, PosixFilePermission.OTHERS_EXECUTE}));
    }

    public FilePermissions(boolean isDirectory, FileAttribute<?> ... attributes) {
        this(FilePermissions.convertFromNioFileAttributes(isDirectory, attributes));
    }

    private FilePermissions(EnumSet<PosixFilePermission> permissions) {
        this.permissions = EnumSet.copyOf(permissions);
    }

    public void copyFrom(FilePermissions other) {
        this.permissions.clear();
        this.permissions.addAll(other.permissions);
    }

    public boolean canRead() {
        return this.permissions.contains((Object)PosixFilePermission.OWNER_READ) || this.permissions.contains((Object)PosixFilePermission.GROUP_READ) || this.permissions.contains((Object)PosixFilePermission.OTHERS_READ);
    }

    public boolean canWrite() {
        return this.permissions.contains((Object)PosixFilePermission.OWNER_WRITE) || this.permissions.contains((Object)PosixFilePermission.GROUP_WRITE) || this.permissions.contains((Object)PosixFilePermission.OTHERS_WRITE);
    }

    public boolean canExecute() {
        return this.permissions.contains((Object)PosixFilePermission.OWNER_EXECUTE) || this.permissions.contains((Object)PosixFilePermission.GROUP_EXECUTE) || this.permissions.contains((Object)PosixFilePermission.OTHERS_EXECUTE);
    }

    private static EnumSet<PosixFilePermission> convertFromNioFileAttributes(boolean isDirectory, FileAttribute<?> ... attributes) {
        if (attributes != null) {
            for (FileAttribute<?> attr : attributes) {
                if (!attr.name().equals("posix:permissions")) continue;
                Collection callerPerms = (Collection)attr.value();
                return EnumSet.copyOf(callerPerms);
            }
        }
        if (isDirectory) {
            return FilePermissions.createDefaultDirectory().permissions;
        }
        return FilePermissions.createDefaultFile().permissions;
    }

    public Set<PosixFilePermission> toPosixFilePermissions() {
        EnumSet<PosixFilePermission> answer = EnumSet.noneOf(PosixFilePermission.class);
        answer.addAll(this.permissions);
        return answer;
    }

    public void setPermissions(Set<PosixFilePermission> perms) {
        this.permissions.clear();
        this.permissions.addAll(perms);
    }
}

