/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbridges.ephemeralfs;

import com.github.sbridges.ephemeralfs.EphemeralFsFileSystem;
import com.github.sbridges.ephemeralfs.EphemeralFsFileTimes;
import com.github.sbridges.ephemeralfs.EphemeralFsGroupPrincipal;
import com.github.sbridges.ephemeralfs.EphemeralFsUserPrincipal;
import com.github.sbridges.ephemeralfs.FilePermissions;
import java.io.IOException;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.UserPrincipal;
import java.util.concurrent.atomic.AtomicLong;

class FileProperties {
    private static final AtomicLong iNodeCounter = new AtomicLong();
    private final Long iNodeNumber = iNodeCounter.incrementAndGet();
    private FilePermissions filePermissions;
    private final EphemeralFsFileTimes fileTimes = new EphemeralFsFileTimes();
    private boolean dosIsArchive = false;
    private boolean dosIsHidden = false;
    private boolean dosIsReadOnly = false;
    private boolean dosIsSystem = false;
    private EphemeralFsUserPrincipal owner;
    private EphemeralFsGroupPrincipal group;
    private final EphemeralFsFileSystem fs;

    public FileProperties(EphemeralFsFileSystem fs, FilePermissions filePermissions, boolean isFile) {
        this.fs = fs;
        this.filePermissions = filePermissions;
        try {
            this.owner = (EphemeralFsUserPrincipal)fs.getUserPrincipalLookupService().lookupPrincipalByName("username");
            this.group = (EphemeralFsGroupPrincipal)fs.getUserPrincipalLookupService().lookupPrincipalByGroupName("group");
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        if (isFile && fs.getSettings().isWindows()) {
            this.dosIsArchive = true;
        }
    }

    public FilePermissions getFilePermissions() {
        return this.filePermissions;
    }

    public void setFilePermissions(FilePermissions filePermissions) {
        this.filePermissions = filePermissions;
    }

    public boolean getDosIsArchive() {
        return this.dosIsArchive;
    }

    public void setDosIsArchive(boolean dosIsArchive) {
        this.dosIsArchive = dosIsArchive;
    }

    public boolean getDosIsHidden() {
        return this.dosIsHidden;
    }

    public void setDosIsHidden(boolean dosIsHidden) {
        this.dosIsHidden = dosIsHidden;
    }

    public boolean getDosIsReadOnly() {
        return this.dosIsReadOnly;
    }

    public void setDosIsReadOnly(boolean dosIsReadOnly) {
        this.dosIsReadOnly = dosIsReadOnly;
    }

    public boolean getDosIsSystem() {
        return this.dosIsSystem;
    }

    public void setDosIsSystem(boolean dosIsSystem) {
        this.dosIsSystem = dosIsSystem;
    }

    public EphemeralFsUserPrincipal getOwner() {
        return this.owner;
    }

    public void setOwner(UserPrincipal owner) throws IOException {
        if (owner != this.fs.getUserPrincipalLookupService().lookupPrincipalByName(owner.getName())) {
            throw new IOException("set owner using wrong fs");
        }
        this.owner = (EphemeralFsUserPrincipal)owner;
    }

    public GroupPrincipal getGroup() {
        return this.group;
    }

    public void setGroup(GroupPrincipal group) throws IOException {
        if (group != this.fs.getUserPrincipalLookupService().lookupPrincipalByGroupName(group.getName())) {
            throw new IOException("set group using wrong fs");
        }
        this.group = (EphemeralFsGroupPrincipal)group;
    }

    public static AtomicLong getInodecounter() {
        return iNodeCounter;
    }

    public Long getiNodeNumber() {
        return this.iNodeNumber;
    }

    public EphemeralFsFileTimes getFileTimes() {
        return this.fileTimes;
    }

    public EphemeralFsFileSystem getFs() {
        return this.fs;
    }

    public Long getInodeNumber() {
        return this.iNodeNumber;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("FileProperties[iNodeNumber=");
        builder.append(this.iNodeNumber);
        builder.append(", filePermissions=");
        builder.append(this.filePermissions);
        builder.append(", fileTimes=");
        builder.append(this.fileTimes);
        builder.append(", dosIsArchive=");
        builder.append(this.dosIsArchive);
        builder.append(", dosIsHidden=");
        builder.append(this.dosIsHidden);
        builder.append(", dosIsReadOnly=");
        builder.append(this.dosIsReadOnly);
        builder.append(", dosIsSystem=");
        builder.append(this.dosIsSystem);
        builder.append(", owner=");
        builder.append(this.owner);
        builder.append(", group=");
        builder.append(this.group);
        builder.append(", fs=");
        builder.append(this.fs);
        builder.append("]");
        return builder.toString();
    }
}

