/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbridges.ephemeralfs;

import java.util.regex.PatternSyntaxException;

class GlobUtil {
    GlobUtil() {
    }

    public static String globToRegex(String glob, boolean unixSeperators) {
        StringBuilder answer = new StringBuilder("^");
        CharStream stream = new CharStream(glob);
        while (stream.hasNext()) {
            char current = stream.current();
            switch (current) {
                case '[': {
                    GlobUtil.matchBracketExpression(stream, unixSeperators, answer);
                    break;
                }
                case '{': {
                    GlobUtil.matchSubpattern(stream, unixSeperators, answer);
                    break;
                }
                case '*': {
                    GlobUtil.handleStar(unixSeperators, answer, stream);
                    break;
                }
                case '?': {
                    GlobUtil.matchAllButPath(answer, unixSeperators);
                    break;
                }
                case '/': {
                    answer.append(GlobUtil.sperator(unixSeperators));
                    break;
                }
                case '\\': {
                    GlobUtil.handleEscape(answer, stream);
                    break;
                }
                default: {
                    GlobUtil.appendEscaped(answer, current);
                }
            }
            stream.next();
        }
        return answer.toString();
    }

    public static void handleStar(boolean unixSeperators, StringBuilder answer, CharStream stream) {
        if (stream.isNext('*')) {
            stream.next();
            answer.append(".*");
        } else {
            GlobUtil.matchAllButPath(answer, unixSeperators);
            answer.append("*");
        }
    }

    private static void matchSubpattern(CharStream stream, boolean unixSeperators, StringBuilder answer) {
        stream.next();
        answer.append("((:?");
        int state = 0;
        while (stream.hasNext()) {
            char current = stream.current();
            switch (current) {
                case '{': {
                    GlobUtil.fail(stream, "can't nest sub patterns");
                }
                case '}': {
                    if (state != 2) {
                        GlobUtil.fail(stream, "group not started");
                    }
                    answer.append("))");
                    return;
                }
                case '[': {
                    GlobUtil.matchBracketExpression(stream, unixSeperators, answer);
                    break;
                }
                case ',': {
                    if (state == 1) {
                        GlobUtil.fail(stream, "multiple consecutive commas");
                    }
                    if (state == 2) {
                        answer.append(")|(?:");
                    }
                    state = 1;
                    break;
                }
                case '*': {
                    GlobUtil.handleStar(unixSeperators, answer, stream);
                    break;
                }
                case '?': {
                    GlobUtil.matchAllButPath(answer, unixSeperators);
                    break;
                }
                case '\\': {
                    GlobUtil.handleEscape(answer, stream);
                    break;
                }
                default: {
                    GlobUtil.appendEscaped(answer, current);
                    state = 2;
                }
            }
            stream.next();
        }
        GlobUtil.fail(stream, "unterminated sub pattern");
    }

    private static void handleEscape(StringBuilder answer, CharStream stream) {
        if (!stream.hasNext()) {
            GlobUtil.fail(stream, "unterminated esacpe sequence");
        }
        stream.next();
        GlobUtil.appendEscaped(answer, stream.current());
    }

    private static void appendEscaped(StringBuilder answer, char current) {
        if (Character.isAlphabetic(current) || Character.isDigit(current)) {
            answer.append(current);
        } else if (current == '.') {
            answer.append("\\.");
        } else if (current == '*') {
            answer.append("\\*");
        } else {
            answer.append(String.format("\\u%04x", current));
        }
    }

    private static void matchBracketExpression(CharStream stream, boolean unixSeperators, StringBuilder answer) {
        stream.next();
        answer.append('[');
        if (stream.current() == '!') {
            answer.append("^");
            stream.next();
        }
        boolean rangeStartAllowed = false;
        if (stream.current() == '-') {
            answer.append('-');
            rangeStartAllowed = true;
            stream.next();
        }
        boolean inRange = false;
        while (stream.hasNext()) {
            char current = stream.current();
            switch (current) {
                case '[': {
                    GlobUtil.fail(stream, "can't nest bracket expressions");
                }
                case ']': {
                    if (inRange) {
                        GlobUtil.fail(stream, "unterminated range in bracket expression");
                    }
                    answer.append("&&[^").append(unixSeperators ? "/" : "\\\\").append("]]");
                    return;
                }
                case '-': {
                    if (!rangeStartAllowed) {
                        GlobUtil.fail(stream, "range requires a start token");
                    }
                    inRange = true;
                    answer.append("-");
                    break;
                }
                default: {
                    inRange = false;
                    rangeStartAllowed = true;
                    GlobUtil.appendEscaped(answer, current);
                }
            }
            stream.next();
        }
        GlobUtil.fail(stream, "unterminated bracket expression");
    }

    private static void fail(CharStream stream, String reason) {
        throw new PatternSyntaxException(reason, stream.getValue(), stream.getIndex());
    }

    private static void matchAllButPath(StringBuilder answer, boolean unixSeperators) {
        answer.append("[^").append(GlobUtil.sperator(unixSeperators)).append("]");
    }

    private static String sperator(boolean unixSeperators) {
        if (unixSeperators) {
            return "/";
        }
        return "\\\\";
    }

    static class CharStream {
        private final String value;
        private int index;

        public CharStream(String value) {
            this.value = value;
        }

        public int getIndex() {
            return this.index;
        }

        public String getValue() {
            return this.value;
        }

        boolean hasNext() {
            return this.index < this.value.length();
        }

        void next() {
            ++this.index;
        }

        boolean isNext(char c) {
            if (this.index + 1 < this.value.length()) {
                return this.value.charAt(this.index + 1) == c;
            }
            return false;
        }

        char current() {
            return this.value.charAt(this.index);
        }
    }
}

