/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbridges.ephemeralfs;

import com.github.sbridges.ephemeralfs.DirectoryEntry;
import com.github.sbridges.ephemeralfs.EphemeralFsFileChannel;
import com.github.sbridges.ephemeralfs.EphemeralFsFileSystem;
import com.github.sbridges.ephemeralfs.EphemeralFsPath;
import com.github.sbridges.ephemeralfs.EphemeralFsWatchEvent;
import com.github.sbridges.ephemeralfs.FileAttributesSnapshot;
import com.github.sbridges.ephemeralfs.FileContents;
import com.github.sbridges.ephemeralfs.FileName;
import com.github.sbridges.ephemeralfs.FilePermissions;
import com.github.sbridges.ephemeralfs.FileProperties;
import com.github.sbridges.ephemeralfs.ResolvedPath;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.NotLinkException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class INode {
    private final Map<FileName, DirectoryEntry> children;
    private final FileContents contents;
    private final EphemeralFsFileSystem fs;
    private final List<INode> parents = new ArrayList<INode>();
    private final boolean root;
    private int hardLinks = -1;
    private int openFileHandles;
    private final FileProperties fileProperties;

    private INode(Map<FileName, DirectoryEntry> children, EphemeralFsFileSystem fileSystem, FilePermissions filePermissions, boolean root) {
        this.children = children;
        this.contents = new FileContents(fileSystem, this);
        this.contents.setDirty(false);
        this.fs = fileSystem;
        this.root = root;
        this.fileProperties = new FileProperties(fileSystem, filePermissions, false);
    }

    private INode(EphemeralFsFileSystem fileSystem, FilePermissions filePermissions) {
        this.contents = new FileContents(fileSystem, this);
        this.children = null;
        this.fs = fileSystem;
        this.root = false;
        this.fileProperties = new FileProperties(fileSystem, filePermissions, true);
    }

    static INode createRoot(EphemeralFsFileSystem fileSystem) {
        return new INode(new HashMap<FileName, DirectoryEntry>(), fileSystem, FilePermissions.createDefaultDirectory(), true);
    }

    public INode addFile(EphemeralFsPath name, FilePermissions filePermissions) throws IOException {
        this.assertCanAddChild(name);
        INode answer = new INode(this.fs, filePermissions);
        this.add(name, answer);
        return answer;
    }

    public INode addDir(EphemeralFsPath name, FilePermissions filePermissions) throws IOException {
        this.assertCanAddChild(name);
        INode answer = new INode(new HashMap<FileName, DirectoryEntry>(), this.fs, filePermissions, false);
        this.add(name, answer);
        return answer;
    }

    public void add(EphemeralFsPath name, INode child) throws IOException {
        this.assertCanAddChild(name);
        this.children.put(name.toFileName(), new DirectoryEntry(child));
        child.parents.add(this);
        child.addLink();
        EphemeralFsWatchEvent event = new EphemeralFsWatchEvent(name, StandardWatchEventKinds.ENTRY_CREATE);
        this.fs.getWatchRegistry().hearChange(this, event);
        this.contents.setDirty(true);
    }

    public void remove(EphemeralFsPath name) {
        if (!this.isDir()) {
            throw new IllegalStateException();
        }
        this.assertOnlyFileName(name);
        DirectoryEntry entry = this.children.remove(name.toFileName());
        if (entry == null) {
            throw new IllegalStateException("removing but nothing exists, name:" + name);
        }
        if (!entry.isSymbolicLink() && !entry.getDestination().parents.remove(this)) {
            throw new IllegalStateException("failed to remove parent? this:" + this + " entry:" + entry);
        }
        if (entry.getDestination() != null) {
            entry.getDestination().removeLink();
        }
        EphemeralFsWatchEvent event = new EphemeralFsWatchEvent(name, StandardWatchEventKinds.ENTRY_DELETE);
        this.fs.getWatchRegistry().hearChange(this, event);
        this.contents.setDirty(true);
    }

    public boolean isSymbolicLink(EphemeralFsPath name) {
        this.assertOnlyFileName(name);
        DirectoryEntry de = this.children.get(name.toFileName());
        if (de == null) {
            return false;
        }
        return de.isSymbolicLink();
    }

    public void addSymlink(EphemeralFsPath name, EphemeralFsPath to) throws IOException {
        if (!this.fs.getSettings().allowSymlink()) {
            throw new FileSystemException("symlinks are not supported");
        }
        this.assertCanAddChild(name);
        this.children.put(name.toFileName(), new DirectoryEntry(to));
    }

    public void addOpenFileHandle() {
        ++this.openFileHandles;
    }

    public void removeOpenFileHandle() {
        --this.openFileHandles;
        if (this.openFileHandles < 0) {
            throw new IllegalStateException();
        }
        this.freeIfNoReferences();
    }

    EphemeralFsPath getPathToRoot() {
        ArrayDeque<String> paths = new ArrayDeque<String>();
        INode current = this;
        block0: while (true) {
            if (current == this.fs.getRoot()) {
                StringBuilder sb = new StringBuilder(this.fs.getSettings().getRoot());
                for (String path : paths) {
                    sb.append(path);
                    sb.append(this.fs.getSeparator());
                }
                return new EphemeralFsPath(this.fs, sb.toString());
            }
            if (current.parents.isEmpty()) {
                return null;
            }
            INode last = current;
            current = current.parents.get(0);
            Iterator<Object> i$ = current.children.entrySet().iterator();
            while (true) {
                if (!i$.hasNext()) continue block0;
                Map.Entry entry = (Map.Entry)i$.next();
                if (((DirectoryEntry)entry.getValue()).getDestination() != last) continue;
                paths.addFirst(((FileName)entry.getKey()).getPath().toString());
            }
            break;
        }
    }

    private void assertCanAddChild(EphemeralFsPath name) throws IOException {
        if (this.isFile()) {
            throw new NotDirectoryException("can't add children to file");
        }
        if (name.toString().equals(".") || name.toString().equals("..")) {
            throw new IllegalStateException("invalid path:" + name);
        }
        if (this.fs.getSettings().getMaxPathLength() != Long.MAX_VALUE && (long)this.getPathToRoot().resolve(name).toString().length() > this.fs.getSettings().getMaxPathLength()) {
            throw new FileSystemException("Path too long");
        }
        this.assertOnlyFileName(name);
        if (this.children.containsKey(name.toFileName())) {
            throw new FileAlreadyExistsException("a child with name:" + name + " already exists");
        }
    }

    public boolean isFile() {
        return this.children == null;
    }

    public boolean isDirty() {
        return this.contents.isDirty();
    }

    public boolean isDir() {
        return !this.isFile();
    }

    public DirectoryEntry resolve(EphemeralFsPath name) {
        this.assertOnlyFileName(name);
        if (this.isFile()) {
            return null;
        }
        FileName key = name.toFileName();
        if (!this.children.containsKey(key)) {
            return null;
        }
        return this.children.get(key);
    }

    public FileAttributesSnapshot getAttributes() throws IOException {
        int size = this.isFile() ? this.contents.getSize() : (this.fs.getSettings().isPosix() ? 4096 : 0);
        return new FileAttributesSnapshot(this.isFile(), this.isDir(), false, false, size, this.isDir() ? this.hardLinks + 1 : this.hardLinks, this.fileProperties);
    }

    public int getContentsSize() {
        if (!this.isFile()) {
            throw new IllegalStateException();
        }
        return this.contents.getSize();
    }

    public FileProperties getProperties() {
        return this.fileProperties;
    }

    public void notifyChange(EphemeralFsPath path) throws NoSuchFileException {
        ResolvedPath resolvedPath;
        try {
            resolvedPath = ResolvedPath.resolve(path.getParent(), false);
        }
        catch (FileSystemException e) {
            return;
        }
        if (!resolvedPath.hasTarget()) {
            return;
        }
        if (resolvedPath.getTarget().isDir() && resolvedPath.getTarget().getName(this) != null) {
            EphemeralFsWatchEvent event = new EphemeralFsWatchEvent(path, StandardWatchEventKinds.ENTRY_MODIFY);
            this.fs.getWatchRegistry().hearChange(resolvedPath.getTarget(), event);
        }
    }

    public EphemeralFsFileChannel newFileChannel(Set<? extends OpenOption> options, boolean deleteOnClose, ResolvedPath resolvedPath) throws IOException {
        boolean readable;
        if (options.contains(StandardOpenOption.CREATE_NEW) && options.contains(StandardOpenOption.WRITE)) {
            throw new FileAlreadyExistsException(resolvedPath.getPath().toString());
        }
        if (this.isDir()) {
            if (this.fs.getSettings().isWindows()) {
                throw new IOException("can't create channel for directory:" + resolvedPath.getPath().toString());
            }
            return this.contents.newChannel(true, false, true, false, false, false, resolvedPath, this.fs);
        }
        boolean writeable = options.contains(StandardOpenOption.WRITE) || options.contains(StandardOpenOption.APPEND);
        boolean bl = readable = options.contains(StandardOpenOption.READ) || !writeable;
        if (writeable && this.fs.getSettings().isWindows() && resolvedPath.getResolvedProperties().getDosIsReadOnly()) {
            throw new AccessDeniedException(resolvedPath.getPath().toString());
        }
        return this.contents.newChannel(readable, writeable, options.contains(StandardOpenOption.APPEND), deleteOnClose, options.contains(StandardOpenOption.TRUNCATE_EXISTING), options.contains(StandardOpenOption.SYNC), resolvedPath, this.fs);
    }

    public boolean isEmpty() {
        if (!this.isDir()) {
            throw new IllegalStateException("not a directory");
        }
        return this.children.isEmpty();
    }

    public Iterable<EphemeralFsPath> getChildNames() {
        if (!this.isDir()) {
            throw new IllegalStateException();
        }
        ArrayList<EphemeralFsPath> answer = new ArrayList<EphemeralFsPath>(this.children.size());
        for (FileName f : this.children.keySet()) {
            answer.add(f.getPath());
        }
        return answer;
    }

    public boolean exists() {
        if (this.root) {
            return true;
        }
        if (this.parents.isEmpty()) {
            return false;
        }
        for (INode parent : this.parents) {
            if (!parent.exists()) continue;
            return true;
        }
        return false;
    }

    private void assertOnlyFileName(EphemeralFsPath name) {
        if (name.getNameCount() != 1) {
            throw new IllegalStateException();
        }
        if (name.isAbsolute()) {
            throw new IllegalStateException();
        }
    }

    public EphemeralFsPath getName(INode iNode) {
        if (!this.isDir()) {
            throw new IllegalStateException("not a dir");
        }
        for (Map.Entry<FileName, DirectoryEntry> e : this.children.entrySet()) {
            if (e.getValue().getDestination() != iNode) continue;
            return e.getKey().getPath();
        }
        return null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("INode[children=");
        builder.append(this.children);
        builder.append(", contents=");
        builder.append(this.contents);
        builder.append(", fs=");
        builder.append(this.fs);
        builder.append(", parents=");
        builder.append(this.parents);
        builder.append(", root=");
        builder.append(this.root);
        builder.append(", hardLinks=");
        builder.append(this.hardLinks);
        builder.append(", openFileHandles=");
        builder.append(this.openFileHandles);
        builder.append(", fileProperties=");
        builder.append(this.fileProperties);
        builder.append("]");
        return builder.toString();
    }

    public EphemeralFsPath getSymbolicLink(Path parent, EphemeralFsPath fileName) throws FileSystemException {
        return (EphemeralFsPath)parent.resolve(this.getRawSymbolicLink(parent, fileName));
    }

    public EphemeralFsPath getRawSymbolicLink(Path parent, EphemeralFsPath fileName) throws FileSystemException {
        DirectoryEntry entry = this.children.get(fileName.toFileName());
        if (entry == null) {
            throw new NoSuchFileException(parent.resolve(fileName).toString());
        }
        if (!entry.isSymbolicLink()) {
            throw new NotLinkException(parent.resolve(fileName).toString());
        }
        return entry.getSymbolicLink();
    }

    public void copyPermissions(INode other) {
        this.fileProperties.getFilePermissions().copyFrom(other.fileProperties.getFilePermissions());
    }

    public void setPermissions(Set<PosixFilePermission> perms) {
        this.fileProperties.getFilePermissions().setPermissions(perms);
    }

    public boolean canWrite() {
        return this.fileProperties.getFilePermissions().canWrite();
    }

    public boolean canRead() {
        return this.fileProperties.getFilePermissions().canRead();
    }

    public boolean canExecute() {
        if (this.fs.getSettings().isWindows()) {
            return this.fileProperties.getFilePermissions().canWrite();
        }
        return this.fileProperties.getFilePermissions().canExecute();
    }

    public EphemeralFsFileSystem getFs() {
        return this.fs;
    }

    private void addLink() {
        if (this.hardLinks == -1) {
            this.hardLinks = 1;
            return;
        }
        if (this.hardLinks == 0) {
            throw new IllegalStateException("resurrecting unlinked file");
        }
        ++this.hardLinks;
    }

    void removeLink() {
        --this.hardLinks;
        if (this.hardLinks < 0) {
            throw new IllegalStateException("negative links?");
        }
        this.freeIfNoReferences();
    }

    private void freeIfNoReferences() {
        if (this.contents != null && this.hardLinks == 0 && this.openFileHandles == 0) {
            this.fs.getLimits().releaseDiskSpace(this.contents.getSize());
        }
    }
}

