/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbridges.ephemeralfs;

import com.github.sbridges.ephemeralfs.Settings;
import java.io.IOException;

class Limits {
    private final Object lock = new Object();
    private final Settings settings;
    private long diskRemaining;
    private long fileHandlesRemaining;

    public Limits(Settings settings) {
        this.settings = settings;
        this.diskRemaining = settings.getTotalSpace();
        this.fileHandlesRemaining = settings.getMaxOpenFileHandles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryAcquireFileHandle() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.fileHandlesRemaining > 0L) {
                --this.fileHandlesRemaining;
            } else {
                throw new IOException("file handles exhausted");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseFileHandle() {
        Object object = this.lock;
        synchronized (object) {
            ++this.fileHandlesRemaining;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryAcquireDiskSpace(long space) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.diskRemaining >= space) {
                this.diskRemaining -= space;
                if (this.diskRemaining < 0L) {
                    throw new IllegalStateException();
                }
            } else {
                throw new IOException("Out of disk space");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseDiskSpace(long space) {
        Object object = this.lock;
        synchronized (object) {
            this.diskRemaining += space;
            if (this.diskRemaining < 0L) {
                throw new IllegalStateException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDiskSpaceUsed() {
        Object object = this.lock;
        synchronized (object) {
            return this.settings.getTotalSpace() - this.diskRemaining;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFreeSpace() {
        Object object = this.lock;
        synchronized (object) {
            return this.diskRemaining;
        }
    }
}

