/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbridges.ephemeralfs;

import com.github.sbridges.ephemeralfs.DirectoryEntry;
import com.github.sbridges.ephemeralfs.EphemeralFsFileSystem;
import com.github.sbridges.ephemeralfs.EphemeralFsPath;
import com.github.sbridges.ephemeralfs.FileProperties;
import com.github.sbridges.ephemeralfs.INode;
import java.nio.file.FileSystemException;
import java.nio.file.FileSystemLoopException;
import java.nio.file.NoSuchFileException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class ResolvedPath {
    private final List<ResolvedStep> steps;
    private final INode target;
    private final DirectoryEntry symlinkDirectoryEntry;
    private final boolean hasValidParent;
    private final EphemeralFsFileSystem fs;

    public static ResolvedPath resolve(EphemeralFsPath path) throws FileSystemException {
        return ResolvedPath.resolve(path, false);
    }

    public static ResolvedPath resolve(EphemeralFsPath path, boolean noFollowLastSymlink) throws FileSystemException {
        try {
            if (!path.isAbsolute()) {
                EphemeralFsPath rootPath = path.getFileSystem().getRootPath();
                return ResolvedPath.resolve((EphemeralFsPath)rootPath.resolve(path), noFollowLastSymlink);
            }
            if (!path.getFileSystem().getSettings().isPosix()) {
                path = path.normalize();
            }
            ArrayList<EphemeralFsPath> parts = new ArrayList<EphemeralFsPath>(path.splitPaths());
            Collections.reverse(parts);
            ArrayList<ResolvedStep> steps = new ArrayList<ResolvedStep>(parts.size());
            return ResolvedPath.resolveAbsolutePath(path, path.getFileSystem(), path.getFileSystem().getRoot(), parts, steps, noFollowLastSymlink);
        }
        catch (StackOverflowError e) {
            throw new FileSystemLoopException(path + ": Too many levels of symbolic links");
        }
    }

    private static ResolvedPath resolveAbsolutePath(EphemeralFsPath oiginalPath, EphemeralFsFileSystem fs, INode current, List<EphemeralFsPath> remaining, List<ResolvedStep> steps, boolean noFollowLastSymlink) throws FileSystemException {
        DirectoryEntry entry;
        if (remaining.isEmpty()) {
            return new ResolvedPath(fs, steps, current, null, !steps.isEmpty());
        }
        EphemeralFsPath currentPath = remaining.remove(remaining.size() - 1);
        String fileName = currentPath.toString();
        if (fileName.equals(".")) {
            if (!current.isDir()) {
                throw new FileSystemException(oiginalPath + ": Not a directory");
            }
            return ResolvedPath.resolveAbsolutePath(oiginalPath, fs, current, remaining, steps, noFollowLastSymlink);
        }
        if (fileName.equals("..")) {
            if (!current.isDir()) {
                throw new FileSystemException(oiginalPath + ": Not a directory");
            }
            if (steps.isEmpty()) {
                return ResolvedPath.resolveAbsolutePath(oiginalPath, fs, fs.getRoot(), remaining, steps, noFollowLastSymlink);
            }
            ResolvedStep parent = steps.remove(steps.size() - 1);
            return ResolvedPath.resolveAbsolutePath(oiginalPath, fs, parent.directory, remaining, steps, noFollowLastSymlink);
        }
        if (current.isDir() && (entry = current.resolve(currentPath)) != null) {
            if (entry.isSymbolicLink()) {
                if (noFollowLastSymlink && remaining.isEmpty()) {
                    steps.add(new ResolvedStep(current, fileName));
                    return new ResolvedPath(fs, steps, null, entry, true);
                }
                EphemeralFsPath linkTarget = entry.getSymbolicLink();
                EphemeralFsPath absolutePathSoFar = ResolvedPath.getPaths(fs, steps);
                List<EphemeralFsPath> newParts = absolutePathSoFar.resolve(linkTarget).splitPaths();
                for (int i = newParts.size() - 1; i >= 0; --i) {
                    remaining.add(newParts.get(i));
                }
                steps.clear();
                return ResolvedPath.resolveAbsolutePath(oiginalPath, fs, fs.getRoot(), remaining, steps, noFollowLastSymlink);
            }
            steps.add(new ResolvedStep(current, fileName));
            return ResolvedPath.resolveAbsolutePath(oiginalPath, fs, entry.getDestination(), remaining, steps, noFollowLastSymlink);
        }
        steps.add(new ResolvedStep(current, fileName));
        if (remaining.isEmpty()) {
            return new ResolvedPath(fs, steps, null, null, true);
        }
        return new ResolvedPath(fs, steps, null, null, false);
    }

    private ResolvedPath(EphemeralFsFileSystem fs, List<ResolvedStep> steps, INode target, DirectoryEntry symlinkDirectoryEntry, boolean hasValidParent) {
        this.fs = fs;
        this.steps = steps;
        this.target = target;
        this.symlinkDirectoryEntry = symlinkDirectoryEntry;
        this.hasValidParent = hasValidParent;
    }

    public boolean didResolve() {
        return this.hasTarget() || this.resolvedToSymbolicLink();
    }

    List<String> getSteps() {
        return new AbstractList<String>(){

            @Override
            public String get(int index) {
                return ((ResolvedStep)((ResolvedPath)ResolvedPath.this).steps.get((int)index)).nextStep;
            }

            @Override
            public int size() {
                return ResolvedPath.this.steps.size();
            }
        };
    }

    public boolean hasTarget() {
        return this.target != null;
    }

    public boolean resolvedToSymbolicLink() {
        return this.symlinkDirectoryEntry != null;
    }

    public EphemeralFsPath getPath() {
        return ResolvedPath.getPaths(this.fs, this.steps);
    }

    private static EphemeralFsPath getPaths(EphemeralFsFileSystem fs, List<ResolvedStep> steps) {
        EphemeralFsPath answer = fs.getRootPath();
        for (int i = 0; i < steps.size(); ++i) {
            answer = answer.resolve(steps.get((int)i).nextStep);
        }
        return answer;
    }

    public INode getTarget() throws NoSuchFileException {
        if (this.target == null) {
            throw new IllegalStateException("no follow and last is symlink:" + this);
        }
        return this.target;
    }

    public boolean hasValidParent() {
        return this.hasValidParent;
    }

    public INode getParent() {
        if (!this.hasValidParent) {
            throw new IllegalStateException();
        }
        return this.steps.get((int)(this.steps.size() - 1)).directory;
    }

    public EphemeralFsPath getRawSymbolicLink() throws FileSystemException {
        if (!this.resolvedToSymbolicLink()) {
            throw new IllegalStateException();
        }
        return this.getParent().getRawSymbolicLink(null, this.fs.getPath(this.steps.get((int)(this.steps.size() - 1)).nextStep, new String[0]));
    }

    public FileProperties getResolvedProperties() {
        if (this.hasTarget()) {
            return this.target.getProperties();
        }
        if (this.resolvedToSymbolicLink()) {
            return this.symlinkDirectoryEntry.getLinkProperties();
        }
        throw new IllegalStateException("did not resolve");
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ResolvedPath[steps=");
        builder.append(this.steps);
        builder.append(", target=");
        builder.append(this.target);
        builder.append(", directoryContainingSymlink=");
        builder.append(this.symlinkDirectoryEntry);
        builder.append("]");
        return builder.toString();
    }

    static class ResolvedStep {
        final INode directory;
        final String nextStep;

        public ResolvedStep(INode directory, String nextStep) {
            this.directory = directory;
            this.nextStep = nextStep;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ResolvedStep[directory=");
            builder.append(this.directory);
            builder.append(", nextStep=");
            builder.append(this.nextStep);
            builder.append("]");
            return builder.toString();
        }
    }
}

