/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbridges.ephemeralfs;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

class Settings {
    private final String root;
    private final String seperator;
    private final boolean caseSensitive;
    private final Pattern seperatorPattern;
    private final Pattern absolutePathPattern;
    private final boolean posix;
    private final long maxOpenFileHandles;
    private final long totalSpace;
    private final long maxPathLength;
    private final boolean recordStackTracesOnOpen;

    public Settings(Map<String, ?> props) {
        HashMap<String, Object> propsCopy = new HashMap<String, Object>(props);
        this.root = this.getProp(propsCopy, "ROOT");
        this.seperator = this.getProp(propsCopy, "SEPERATOR");
        this.caseSensitive = Boolean.parseBoolean(this.getProp(propsCopy, "CASE_SENSITIVE"));
        if (this.seperator.equals("/")) {
            this.seperatorPattern = Pattern.compile("/");
            this.absolutePathPattern = Pattern.compile("/.*");
            this.posix = true;
        } else {
            this.seperatorPattern = Pattern.compile("\\\\");
            this.absolutePathPattern = Pattern.compile("[A-Za-z]:\\\\.*");
            this.posix = false;
        }
        this.maxOpenFileHandles = this.getOptionalLong(propsCopy, "MAX_FILE_HANDLES", Long.MAX_VALUE);
        this.totalSpace = this.getOptionalLong(propsCopy, "TOTAL_SPACE", Long.MAX_VALUE);
        this.maxPathLength = this.getOptionalLong(propsCopy, "MAX_PATH_LENGTH", Long.MAX_VALUE);
        this.recordStackTracesOnOpen = Boolean.valueOf(this.getProp(propsCopy, "RECORD_RESOURCE_CREATION_STACK_TRACES"));
        if (!propsCopy.isEmpty()) {
            throw new IllegalArgumentException("unrecognized props:" + propsCopy.keySet());
        }
    }

    public long getMaxOpenFileHandles() {
        return this.maxOpenFileHandles;
    }

    public long getTotalSpace() {
        return this.totalSpace;
    }

    private long getOptionalLong(Map<String, ?> propsCopy, String propertyName, long defaultValue) {
        Object val = propsCopy.remove(propertyName);
        if (val == null) {
            return defaultValue;
        }
        if (!(val instanceof String)) {
            throw new IllegalStateException("invalid prop:" + propertyName + " val:" + val);
        }
        long answer = Long.parseLong(val.toString());
        if (answer < 0L) {
            throw new IllegalStateException("invalid prop:" + propertyName + " val:" + val);
        }
        return answer;
    }

    private String getProp(Map<String, Object> propsCopy, String propertyName) {
        Object val = propsCopy.remove(propertyName);
        if (val == null || !(val instanceof String)) {
            throw new IllegalStateException("invalid prop:" + propertyName + " val:" + val);
        }
        return val.toString();
    }

    public String getRoot() {
        return this.root;
    }

    public String getSeperator() {
        return this.seperator;
    }

    public boolean caseSensitive() {
        return this.caseSensitive;
    }

    public Pattern getSeperatorPattern() {
        return this.seperatorPattern;
    }

    public Pattern getAbsolutePathPattern() {
        return this.absolutePathPattern;
    }

    public long getMaxPathLength() {
        return this.maxPathLength;
    }

    public boolean isWindows() {
        return !this.posix;
    }

    public boolean isPosix() {
        return this.posix;
    }

    public boolean isMac() {
        return !this.isWindows() && !this.caseSensitive;
    }

    public boolean allowSymlink() {
        return !this.isWindows();
    }

    public boolean getRecordStackTracesOnOpen() {
        return this.recordStackTracesOnOpen;
    }
}

