/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbridges.ephemeralfs;

import com.github.sbridges.ephemeralfs.EphemeralFsWatchEvent;
import com.github.sbridges.ephemeralfs.EphemeralFsWatchKey;
import com.github.sbridges.ephemeralfs.INode;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

class WatchRegistry {
    private final Object lock = new Object();
    private final Map<INode, CopyOnWriteArrayList<EphemeralFsWatchKey>> watches = new ConcurrentHashMap<INode, CopyOnWriteArrayList<EphemeralFsWatchKey>>();

    WatchRegistry() {
    }

    public void hearChange(INode directory, EphemeralFsWatchEvent event) {
        List watchKeys = this.watches.get(directory);
        if (watchKeys != null) {
            for (EphemeralFsWatchKey watchKey : watchKeys) {
                watchKey.hear(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(INode directory, EphemeralFsWatchKey watchKey) {
        Object object = this.lock;
        synchronized (object) {
            CopyOnWriteArrayList<EphemeralFsWatchKey> existing = this.watches.get(directory);
            if (existing != null) {
                existing.add(watchKey);
            } else {
                this.watches.put(directory, new CopyOnWriteArrayList());
                this.watches.get(directory).add(watchKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregister(INode directory, EphemeralFsWatchKey watchKey) {
        Object object = this.lock;
        synchronized (object) {
            CopyOnWriteArrayList<EphemeralFsWatchKey> existing = this.watches.get(directory);
            existing.remove(watchKey);
            if (existing.isEmpty()) {
                this.watches.remove(directory);
            }
        }
    }
}

