/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbt.junit.jupiter.internal;

import com.github.sbt.junit.jupiter.api.JupiterTestListener;
import com.github.sbt.junit.jupiter.api.StreamPair;
import com.github.sbt.junit.jupiter.internal.Configuration;
import com.github.sbt.junit.jupiter.internal.event.Dispatcher;
import com.github.sbt.junit.jupiter.internal.event.LoggingEventHandler;
import com.github.sbt.junit.jupiter.internal.filter.GlobFilter;
import com.github.sbt.junit.jupiter.internal.filter.TestFilter;
import com.github.sbt.junit.jupiter.internal.listeners.OutputCapturingTestListener;
import com.github.sbt.junit.jupiter.internal.listeners.SummaryPrintingTestListener;
import com.github.sbt.junit.jupiter.internal.options.Options;
import com.github.sbt.junit.jupiter.internal.options.OptionsParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.PostDiscoveryFilter;
import org.junit.platform.launcher.TagFilter;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;
import sbt.testing.EventHandler;
import sbt.testing.Logger;
import sbt.testing.Runner;
import sbt.testing.Task;
import sbt.testing.TaskDef;

public class JupiterRunner
implements Runner {
    private final StreamPair systemStreamPair;
    private final ClassLoader testClassLoader;
    private final String[] args;
    private final String[] remoteArgs;
    private final Options options;

    public JupiterRunner(String[] stringArray, String[] stringArray2, ClassLoader classLoader, StreamPair streamPair) {
        this.args = stringArray;
        this.remoteArgs = stringArray2;
        this.testClassLoader = classLoader;
        this.systemStreamPair = streamPair;
        this.options = new OptionsParser().parse(stringArray);
    }

    public String[] args() {
        return this.args;
    }

    public String done() {
        return "";
    }

    public String[] remoteArgs() {
        return this.remoteArgs;
    }

    public Task[] tasks(TaskDef[] taskDefArray) {
        return (Task[])Arrays.stream(taskDefArray).map(taskDef -> new JupiterTask((TaskDef)taskDef)).toArray(Task[]::new);
    }

    class JupiterTask
    implements Task {
        final TaskDef taskDef;

        JupiterTask(TaskDef taskDef) {
            this.taskDef = taskDef;
        }

        public String[] tags() {
            return new String[0];
        }

        public Task[] execute(EventHandler eventHandler, Logger[] loggerArray) {
            return new WithCustomProperties(new JupiterTaskExecutor(loggerArray, eventHandler, this.taskDef)).execute();
        }

        public TaskDef taskDef() {
            return this.taskDef;
        }
    }

    class WithCustomProperties {
        private final JupiterTaskExecutor wrapped;
        private final Map<String, String> tempProperties = new HashMap<String, String>();

        WithCustomProperties(JupiterTaskExecutor jupiterTaskExecutor) {
            this.wrapped = jupiterTaskExecutor;
        }

        Task[] execute() {
            try {
                this.createTempProperties(JupiterRunner.this.options.getSystemProperties());
                Task[] taskArray = this.wrapped.execute();
                return taskArray;
            }
            finally {
                this.restoreSystemProperties();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void createTempProperties(Map<String, String> map) {
            Properties properties = System.getProperties();
            synchronized (properties) {
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    this.tempProperties.put(entry.getKey(), entry.getValue());
                    System.setProperty(entry.getKey(), entry.getValue());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void restoreSystemProperties() {
            Properties properties = System.getProperties();
            synchronized (properties) {
                this.tempProperties.forEach((string, string2) -> {
                    if (null == string2) {
                        System.clearProperty(string);
                    } else {
                        System.setProperty(string, string2);
                    }
                });
                this.tempProperties.clear();
            }
        }
    }

    class JupiterTaskExecutor {
        final Logger[] loggers;
        final EventHandler eventHandler;
        final TaskDef taskDef;

        JupiterTaskExecutor(Logger[] loggerArray, EventHandler eventHandler, TaskDef taskDef) {
            this.loggers = loggerArray;
            this.taskDef = taskDef;
            this.eventHandler = JupiterRunner.this.options.getDispatchEventsTracePath().map(string -> new LoggingEventHandler((String)string, eventHandler)).orElse(eventHandler);
        }

        Task[] execute() {
            String string = this.taskDef.fullyQualifiedName();
            Configuration configuration = new Configuration(string, this.loggers, JupiterRunner.this.options);
            Dispatcher dispatcher = new Dispatcher(configuration, this.eventHandler);
            SummaryPrintingTestListener summaryPrintingTestListener = new SummaryPrintingTestListener(configuration);
            OutputCapturingTestListener outputCapturingTestListener = new OutputCapturingTestListener(configuration, JupiterRunner.this.systemStreamPair);
            JupiterTestListener jupiterTestListener = configuration.getTestListener();
            try {
                LauncherDiscoveryRequestBuilder launcherDiscoveryRequestBuilder = LauncherDiscoveryRequestBuilder.request();
                launcherDiscoveryRequestBuilder.selectors(new DiscoverySelector[]{this.testSelector(string)});
                launcherDiscoveryRequestBuilder.filters(this.testFilters(dispatcher));
                Launcher launcher = LauncherFactory.create();
                launcher.registerTestExecutionListeners(new TestExecutionListener[]{dispatcher});
                launcher.registerTestExecutionListeners(new TestExecutionListener[]{outputCapturingTestListener});
                launcher.registerTestExecutionListeners(new TestExecutionListener[]{summaryPrintingTestListener});
                launcher.registerTestExecutionListeners(new TestExecutionListener[]{jupiterTestListener});
                configuration.createRunListener(JupiterRunner.this.testClassLoader).ifPresent(testExecutionListener -> launcher.registerTestExecutionListeners(new TestExecutionListener[]{testExecutionListener}));
                launcher.execute(launcherDiscoveryRequestBuilder.build(), new TestExecutionListener[0]);
                return new Task[0];
            }
            catch (Throwable throwable) {
                dispatcher.executionFailed(string, throwable);
                throwable.printStackTrace();
                return new Task[0];
            }
        }

        private DiscoverySelector testSelector(String string) {
            if (string.contains("#")) {
                return DiscoverySelectors.selectMethod((String)string);
            }
            return DiscoverySelectors.selectClass((String)string);
        }

        private Filter[] testFilters(Dispatcher dispatcher) {
            ArrayList<PostDiscoveryFilter> arrayList = new ArrayList<PostDiscoveryFilter>();
            if (!JupiterRunner.this.options.getExcludeTags().isEmpty()) {
                arrayList.add(TagFilter.excludeTags(JupiterRunner.this.options.getExcludeTags()));
            }
            if (!JupiterRunner.this.options.getIncludeTags().isEmpty()) {
                arrayList.add(TagFilter.includeTags(JupiterRunner.this.options.getIncludeTags()));
            }
            TestFilter.create(JupiterRunner.this.options.getTestFilters(), dispatcher).ifPresent(arrayList::add);
            GlobFilter.create(JupiterRunner.this.options.getGlobPatterns(), dispatcher).ifPresent(arrayList::add);
            return arrayList.toArray(new Filter[arrayList.size()]);
        }
    }
}

