/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbt.junit.jupiter.internal.event;

import com.github.sbt.junit.jupiter.api.JupiterTestFingerprint;
import com.github.sbt.junit.jupiter.api.JupiterTestListener;
import com.github.sbt.junit.jupiter.internal.Configuration;
import com.github.sbt.junit.jupiter.internal.event.TaskName;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.launcher.TestIdentifier;
import sbt.testing.Event;
import sbt.testing.EventHandler;
import sbt.testing.Fingerprint;
import sbt.testing.NestedSuiteSelector;
import sbt.testing.NestedTestSelector;
import sbt.testing.OptionalThrowable;
import sbt.testing.Selector;
import sbt.testing.Status;
import sbt.testing.SuiteSelector;
import sbt.testing.TestSelector;

public class Dispatcher
implements JupiterTestListener {
    private static final Fingerprint fingerprint = new JupiterTestFingerprint();
    private final EventHandler eventHandler;
    private final Map<TestIdentifier, Boolean> reportedIds = new ConcurrentHashMap<TestIdentifier, Boolean>();
    private final Map<TestIdentifier, Long> startTimes = new ConcurrentHashMap<TestIdentifier, Long>();
    private final String testSuiteName;

    public Dispatcher(Configuration configuration, EventHandler eventHandler) {
        this.eventHandler = eventHandler;
        this.testSuiteName = configuration.getTestSuiteName();
    }

    public void executionSkipped(TestIdentifier testIdentifier, String string) {
        this.reportedIds.computeIfAbsent(testIdentifier, testIdentifier2 -> {
            long l = this.calculateDuration((TestIdentifier)testIdentifier2);
            TaskName taskName = TaskName.of(this.testSuiteName, testIdentifier);
            this.eventHandler.handle((Event)new DispatchEvent(taskName, Status.Skipped, l));
            return true;
        });
    }

    public void executionStarted(TestIdentifier testIdentifier2) {
        this.startTimes.computeIfAbsent(testIdentifier2, testIdentifier -> System.currentTimeMillis());
    }

    @Override
    public void executionFailed(String string, Throwable throwable) {
        TaskName taskName = TaskName.of(this.testSuiteName, string);
        this.eventHandler.handle((Event)new DispatchEvent(taskName, Status.Error, 0L, throwable));
    }

    @Override
    public void executionFiltered(TestDescriptor testDescriptor, String string) {
        TaskName taskName = TaskName.of(this.testSuiteName, TestIdentifier.from((TestDescriptor)testDescriptor));
        this.eventHandler.handle((Event)new DispatchEvent(taskName, Status.Skipped, 0L));
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        this.reportedIds.computeIfAbsent(testIdentifier, testIdentifier2 -> {
            Status status;
            Throwable throwable = testExecutionResult.getThrowable().orElse(null);
            TaskName taskName = TaskName.of(this.testSuiteName, testIdentifier);
            long l = this.calculateDuration(testIdentifier);
            boolean bl = testIdentifier.isTest();
            switch (testExecutionResult.getStatus()) {
                case ABORTED: {
                    status = Status.Canceled;
                    bl = true;
                    break;
                }
                case FAILED: {
                    status = Status.Failure;
                    bl = true;
                    break;
                }
                case SUCCESSFUL: {
                    status = Status.Success;
                    break;
                }
                default: {
                    status = Status.Pending;
                    bl = true;
                }
            }
            if (bl) {
                this.eventHandler.handle((Event)new DispatchEvent(taskName, status, l, throwable));
            }
            return true;
        });
    }

    private long calculateDuration(TestIdentifier testIdentifier) {
        long l = this.startTimes.getOrDefault(testIdentifier, 0L);
        return 0L == l ? l : System.currentTimeMillis() - l;
    }

    static class DispatchEvent
    implements Event {
        final Status status;
        final Throwable throwable;
        final long duration;
        final String className;
        final Selector selector;

        DispatchEvent(TaskName taskName, Status status, long l) {
            this(taskName, status, l, null);
        }

        DispatchEvent(TaskName taskName, Status status, long l, Throwable throwable) {
            this.status = status;
            this.throwable = throwable;
            this.duration = l;
            this.className = taskName.fullyQualifiedName();
            this.selector = DispatchEvent.toSelector(taskName);
        }

        static Selector toSelector(TaskName taskName) {
            Object object = taskName.testName();
            if (null != object && null != taskName.invocation()) {
                object = (String)object + ":" + taskName.invocation();
            }
            if (null != taskName.nestedSuiteId()) {
                if (null != taskName.testName()) {
                    return new NestedTestSelector(taskName.nestedSuiteId(), taskName.testName());
                }
                return new NestedSuiteSelector(taskName.nestedSuiteId());
            }
            if (null != object) {
                return new TestSelector((String)object);
            }
            return new SuiteSelector();
        }

        public String fullyQualifiedName() {
            return this.className;
        }

        public Fingerprint fingerprint() {
            return fingerprint;
        }

        public Selector selector() {
            return this.selector;
        }

        public Status status() {
            return this.status;
        }

        public OptionalThrowable throwable() {
            return Optional.ofNullable(this.throwable).map(OptionalThrowable::new).orElseGet(OptionalThrowable::new);
        }

        public long duration() {
            return this.duration;
        }

        public String toString() {
            return "DispatchEvent(" + String.valueOf(this.status) + ", " + this.className + ", " + String.valueOf(this.selector) + ")";
        }
    }
}

