/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbt.junit.jupiter.internal.listeners;

import com.github.sbt.junit.jupiter.api.JupiterTestListener;
import com.github.sbt.junit.jupiter.internal.ColorTheme;
import com.github.sbt.junit.jupiter.internal.Configuration;
import com.github.sbt.junit.jupiter.internal.TestLogger;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;

public class FlatPrintingTestListener
implements JupiterTestListener {
    private TestPlan testPlan;
    private final TestLogger logger;
    private final ColorTheme colorTheme;
    private final Configuration configuration;
    private final Map<String, Long> startTimes = new ConcurrentHashMap<String, Long>();

    public FlatPrintingTestListener(Configuration configuration) {
        this.colorTheme = configuration.getColorTheme();
        this.configuration = configuration;
        this.logger = configuration.getLogger();
    }

    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.testPlan = testPlan;
    }

    public void executionSkipped(TestIdentifier testIdentifier, String string2) {
        String string3 = this.configuration.formatIdentifier(this.testPlan, testIdentifier);
        String string4 = "Test " + string3 + " ignored" + Optional.ofNullable(string2).map(string -> ": " + string).orElse("");
        this.logger.info(string4, new Object[0]);
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        Object object;
        this.startTimes.putIfAbsent(testIdentifier.getUniqueId(), System.currentTimeMillis());
        if (!testIdentifier.getParentId().isPresent() && !this.testPlan.getChildren(testIdentifier).isEmpty()) {
            object = "Test run started (" + testIdentifier.getDisplayName() + ")";
            this.debugOrInfo(this.colorTheme.info().format((String)object));
        }
        if (testIdentifier.isTest()) {
            object = this.configuration.formatIdentifier(this.testPlan, testIdentifier);
            this.debugOrInfo("Test " + (String)object + " started");
        }
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        String string = this.calculateDurationSuffix(testIdentifier.getUniqueId());
        Throwable throwable = testExecutionResult.getThrowable().orElse(null);
        switch (testExecutionResult.getStatus()) {
            case ABORTED: {
                String string2 = this.configuration.buildErrorName(testIdentifier);
                Object object = this.configuration.buildErrorMessage(throwable);
                object = "Test assumption in test " + string2 + " failed: " + (String)object + string;
                this.logger.warn((String)object, new Object[0]);
                break;
            }
            case FAILED: {
                String string3 = this.configuration.buildErrorName(testIdentifier);
                Object object = this.configuration.buildErrorMessage(throwable);
                object = "Test " + string3 + " failed: " + (String)object + string;
                this.logger.error(this.configuration.extractClassNameOrDisplayName(testIdentifier), (String)object, throwable);
                break;
            }
            case SUCCESSFUL: {
                String string4 = this.configuration.formatIdentifier(this.testPlan, testIdentifier);
                String string5 = "Test " + string4 + " finished" + string;
                this.logger.debug(string5, new Object[0]);
            }
        }
    }

    public void reportingEntryPublished(TestIdentifier testIdentifier, ReportEntry reportEntry) {
    }

    private long calculateDuration(String string) {
        long l = this.startTimes.getOrDefault(string, 0L);
        return 0L == l ? l : System.currentTimeMillis() - l;
    }

    private String calculateDurationSuffix(String string) {
        long l = this.calculateDuration(string);
        return ", took " + (double)l / 1000.0 + "s";
    }

    private void debugOrInfo(String string) {
        if (this.configuration.getOptions().isVerbose()) {
            this.logger.info(string, new Object[0]);
            return;
        }
        this.logger.debug(string, new Object[0]);
    }
}

