/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbt.junit.jupiter.internal.listeners;

import com.github.sbt.junit.jupiter.api.StreamPair;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

public class OutputCapture {
    private static final InheritableThreadLocal<StreamRegistration> registrations = new InheritableThreadLocal();
    private static StreamPair previous;
    private static SharedProperty sharedProperty;

    public static synchronized void install(StreamPair streamPair) {
        previous = streamPair;
        if (sharedProperty.install()) {
            DelegateStream delegateStream = new DelegateStream(StreamPair.Type.OUT);
            DelegateStream delegateStream2 = new DelegateStream(StreamPair.Type.ERR);
            System.setOut(delegateStream);
            System.setErr(delegateStream2);
        }
    }

    public static synchronized void uninstall() {
        if (sharedProperty.uninstall()) {
            System.setOut(previous.get(StreamPair.Type.OUT));
            System.setErr(previous.get(StreamPair.Type.ERR));
        }
    }

    public static synchronized void register(PrintStream printStream, PrintStream printStream2) {
        if (null == previous) {
            throw new IllegalStateException("Output capture was not installed.");
        }
        StreamRegistration streamRegistration = OutputCapture.registration().orElse(null);
        StreamPair streamPair = new StreamPair(printStream, printStream2);
        StreamRegistration streamRegistration2 = new StreamRegistration(streamPair, streamRegistration);
        registrations.set(streamRegistration2);
    }

    public static synchronized void deregister() {
        OutputCapture.registration().ifPresent(streamRegistration -> registrations.set(streamRegistration.previous));
    }

    private static synchronized Optional<StreamRegistration> registration() {
        return Optional.ofNullable((StreamRegistration)registrations.get());
    }

    private static synchronized StreamPair current() {
        return OutputCapture.registration().map(streamRegistration -> streamRegistration.streams).orElse(previous);
    }

    static {
        sharedProperty = new SharedProperty();
    }

    private static class SharedProperty {
        private static final String NAME = SharedProperty.class.getName();
        private static final MethodHandle threadIdMethodHandle;

        private SharedProperty() {
        }

        String id() {
            try {
                long l = threadIdMethodHandle.invoke(Thread.currentThread());
                return ":" + l;
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }

        boolean install() {
            String string = Optional.ofNullable(System.getProperty(NAME)).orElse("");
            if (!string.isEmpty()) {
                if (!string.contains(this.id())) {
                    System.setProperty(NAME, string + this.id());
                }
                return false;
            }
            System.setProperty(NAME, this.id());
            return true;
        }

        boolean uninstall() {
            String string = Optional.ofNullable(System.getProperty(NAME)).orElse("");
            if (string.isEmpty()) {
                return false;
            }
            if (string.contains(this.id())) {
                string = string.replace(this.id(), "");
                System.setProperty(NAME, string);
            }
            return string.isEmpty();
        }

        static {
            String string = Arrays.stream(Thread.class.getMethods()).filter(method -> method.getName() == "threadId").findFirst().isPresent() ? "threadId" : "getId";
            try {
                threadIdMethodHandle = MethodHandles.lookup().findVirtual(Thread.class, string, MethodType.methodType(Long.TYPE));
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                throw new RuntimeException(reflectiveOperationException);
            }
        }
    }

    private static class DelegateStream
    extends PrintStream {
        private final StreamPair.Type type;
        private static final OutputStream NULL_OUTPUT = new ByteArrayOutputStream();

        DelegateStream(StreamPair.Type type) {
            super(NULL_OUTPUT);
            this.type = Objects.requireNonNull(type);
        }

        @Override
        public void write(int n) {
            this.get().write(n);
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.get().write(byArray, 0, byArray.length);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) {
            this.get().write(byArray, n, n2);
        }

        @Override
        public void flush() {
            this.get().flush();
        }

        @Override
        public void close() {
            this.get().close();
        }

        private PrintStream get() {
            return OutputCapture.current().get(this.type);
        }

        public String toString() {
            return "DelegateStream(" + String.valueOf((Object)this.type) + ", " + String.valueOf(this.get()) + ")";
        }
    }

    private static class StreamRegistration {
        final StreamPair streams;
        final StreamRegistration previous;

        StreamRegistration(StreamPair streamPair, StreamRegistration streamRegistration) {
            this.streams = Objects.requireNonNull(streamPair, "streamPair");
            this.previous = streamRegistration;
        }
    }
}

