/*
 * Decompiled with CFR 0.152.
 */
package com.jsuereth.pgp;

import com.jsuereth.pgp.PublicKey$;
import com.jsuereth.pgp.PublicKey$signatures$;
import com.jsuereth.pgp.PublicKey$userIDs$;
import com.jsuereth.pgp.PublicKeyLike;
import com.jsuereth.pgp.Signature;
import com.jsuereth.pgp.Signature$;
import com.jsuereth.pgp.StreamingSaveable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Date;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.jcajce.JcePGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyKeyEncryptionMethodGenerator;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Parallel;
import scala.collection.Parallelizable;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.TraversableView;
import scala.collection.generic.CanBuildFrom;
import scala.collection.generic.FilterMonadic;
import scala.collection.generic.GenericCompanion;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.StringBuilder;
import scala.collection.parallel.Combiner;
import scala.collection.parallel.ParIterable;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005mh\u0001\u0002\u0012$\u0001)B\u0001\u0002\u000f\u0001\u0003\u0006\u0004%\t!\u000f\u0005\t\t\u0002\u0011\t\u0011)A\u0005u!)Q\t\u0001C\u0001\r\")\u0011\n\u0001C\u0001\u0015\")a\n\u0001C\u0001\u001f\")1\u000b\u0001C\u0001)\")Q\f\u0001C\u0001=\")Q\r\u0001C\u0001M\")!\u000e\u0001C\u0001\u001f\")1\u000e\u0001C\u0001Y\u001e)1\u000f\u0001E\u0001i\u001a)a\u000f\u0001E\u0001o\"1Q\t\u0004C\u0001\u0003/Aq!!\u0007\r\t\u0003\tYbB\u0004\u0002F\u0001A\t!a\u0012\u0007\u000f\u0005%\u0003\u0001#\u0001\u0002L!1Q\t\u0005C\u0001\u0003+Bq!!\u0007\u0011\t\u0003\n9\u0006C\u0004\u0002d\u0001!\t!!\u001a\t\u000f\u0005-\u0004\u0001\"\u0001\u0002n!9\u0011q\u000e\u0001\u0005\u0002\u0005E\u0004bBAG\u0001\u0011\u0005\u0011q\u0012\u0005\b\u00033\u0003A\u0011AAN\u0011\u001d\t9\u000b\u0001C\u0001\u0003SCq!!,\u0001\t\u0003\ty\u000bC\u0005\u0002D\u0002\t\n\u0011\"\u0001\u0002F\"9\u00111\u001c\u0001\u0005\u0002\u0005u\u0007BCAq\u0001!\u0015\r\u0011\"\u0011\u0002d\u001e9\u0011Q]\u0012\t\u0002\u0005\u001dhA\u0002\u0012$\u0011\u0003\tI\u000f\u0003\u0004F=\u0011\u0005\u00111\u001e\u0005\b\u0003[tB\u0011AAx\u0011\u001d\t\u0019P\bC\u0002\u0003k\u0014\u0011\u0002U;cY&\u001c7*Z=\u000b\u0005\u0011*\u0013a\u00019ha*\u0011aeJ\u0001\tUN,XM]3uQ*\t\u0001&A\u0002d_6\u001c\u0001a\u0005\u0003\u0001WE*\u0004C\u0001\u00170\u001b\u0005i#\"\u0001\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Aj#AB!osJ+g\r\u0005\u00023g5\t1%\u0003\u00025G\ti\u0001+\u001e2mS\u000e\\U-\u001f'jW\u0016\u0004\"A\r\u001c\n\u0005]\u001a#!E*ue\u0016\fW.\u001b8h'\u00064X-\u00192mK\u00061a.Z:uK\u0012,\u0012A\u000f\t\u0003w\tk\u0011\u0001\u0010\u0006\u0003{y\nqa\u001c9f]B<\u0007O\u0003\u0002@\u0001\u0006a!m\\;oGf\u001c\u0017m\u001d;mK*\t\u0011)A\u0002pe\u001eL!a\u0011\u001f\u0003\u0019A;\u0005\u000bU;cY&\u001c7*Z=\u0002\u000f9,7\u000f^3eA\u00051A(\u001b8jiz\"\"a\u0012%\u0011\u0005I\u0002\u0001\"\u0002\u001d\u0004\u0001\u0004Q\u0014!B6fs&#U#A&\u0011\u00051b\u0015BA'.\u0005\u0011auN\\4\u0002\u0017\tLGo\u0015;sK:<G\u000f[\u000b\u0002!B\u0011A&U\u0005\u0003%6\u00121!\u00138u\u00031\u0019'/Z1uS>tG+[7f+\u0005)\u0006C\u0001,\\\u001b\u00059&B\u0001-Z\u0003\u0011)H/\u001b7\u000b\u0003i\u000bAA[1wC&\u0011Al\u0016\u0002\u0005\t\u0006$X-A\u0006gS:<WM\u001d9sS:$X#A0\u0011\u00071\u0002'-\u0003\u0002b[\t)\u0011I\u001d:bsB\u0011AfY\u0005\u0003I6\u0012AAQ=uK\u0006I\u0011n\u001d*fm>\\W\rZ\u000b\u0002OB\u0011A\u0006[\u0005\u0003S6\u0012qAQ8pY\u0016\fg.A\u0005bY\u001e|'/\u001b;i[\u0006i\u0011\r\\4pe&$\b.\u001c(b[\u0016,\u0012!\u001c\t\u0003]Fl\u0011a\u001c\u0006\u0003af\u000bA\u0001\\1oO&\u0011!o\u001c\u0002\u0007'R\u0014\u0018N\\4\u0002\u000fU\u001cXM]%EgB\u0011Q\u000fD\u0007\u0002\u0001\t9Qo]3s\u0013\u0012\u001b8c\u0001\u0007,qB)\u00110a\u0001\u0002\n9\u0011!p \b\u0003wzl\u0011\u0001 \u0006\u0003{&\na\u0001\u0010:p_Rt\u0014\"\u0001\u0018\n\u0007\u0005\u0005Q&A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u0015\u0011q\u0001\u0002\f)J\fg/\u001a:tC\ndWMC\u0002\u0002\u00025\u0002B!a\u0003\u0002\u00149!\u0011QBA\b!\tYX&C\u0002\u0002\u00125\na\u0001\u0015:fI\u00164\u0017b\u0001:\u0002\u0016)\u0019\u0011\u0011C\u0017\u0015\u0003Q\fqAZ8sK\u0006\u001c\u0007.\u0006\u0003\u0002\u001e\u0005MB\u0003BA\u0010\u0003K\u00012\u0001LA\u0011\u0013\r\t\u0019#\f\u0002\u0005+:LG\u000fC\u0004\u0002(9\u0001\r!!\u000b\u0002\u0003\u0019\u0004r\u0001LA\u0016\u0003\u0013\ty#C\u0002\u0002.5\u0012\u0011BR;oGRLwN\\\u0019\u0011\t\u0005E\u00121\u0007\u0007\u0001\t\u001d\t)D\u0004b\u0001\u0003o\u0011\u0011!V\t\u0005\u0003s\ty\u0004E\u0002-\u0003wI1!!\u0010.\u0005\u001dqu\u000e\u001e5j]\u001e\u00042\u0001LA!\u0013\r\t\u0019%\f\u0002\u0004\u0003:L\u0018AC:jO:\fG/\u001e:fgB\u0011Q\u000f\u0005\u0002\u000bg&<g.\u0019;ve\u0016\u001c8\u0003\u0002\t,\u0003\u001b\u0002R!_A\u0002\u0003\u001f\u00022AMA)\u0013\r\t\u0019f\t\u0002\n'&<g.\u0019;ve\u0016$\"!a\u0012\u0016\t\u0005e\u0013\u0011\r\u000b\u0005\u0003?\tY\u0006C\u0004\u0002(I\u0001\r!!\u0018\u0011\u000f1\nY#a\u0014\u0002`A!\u0011\u0011GA1\t\u001d\t)D\u0005b\u0001\u0003o\tqb]5h]\u0006$XO]3t\r>\u0014\u0018\n\u001a\u000b\u0005\u0003\u001b\n9\u0007C\u0004\u0002jM\u0001\r!!\u0003\u0002\u0005%$\u0017a\u00053je\u0016\u001cGoS3z'&<g.\u0019;ve\u0016\u001cXCAA'\u0003M1XM]5gs6+7o]1hKN#(/Z1n)\u00159\u00171OAB\u0011\u001d\t)(\u0006a\u0001\u0003o\nQ!\u001b8qkR\u0004B!!\u001f\u0002\u00005\u0011\u00111\u0010\u0006\u0004\u0003{J\u0016AA5p\u0013\u0011\t\t)a\u001f\u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\u001c\u0005\b\u0003\u000b+\u0002\u0019AAD\u0003\u0019yW\u000f\u001e9viB!\u0011\u0011PAE\u0013\u0011\tY)a\u001f\u0003\u0019=+H\u000f];u'R\u0014X-Y7\u0002-Y,'/\u001b4z'&<g.\u0019;ve\u0016\u001cFO]3b[N$RaZAI\u0003+Cq!a%\u0017\u0001\u0004\t9(A\u0002ng\u001eDq!a&\u0017\u0001\u0004\t9(A\u0005tS\u001et\u0017\r^;sK\u0006YQM\\2ssB$h)\u001b7f)\u0019\ty\"!(\u0002&\"9\u0011QO\fA\u0002\u0005}\u0005\u0003BA=\u0003CKA!a)\u0002|\t!a)\u001b7f\u0011\u001d\t)i\u0006a\u0001\u0003?\u000bQ\"\u001a8def\u0004Ho\u0015;sS:<G\u0003BA\u0005\u0003WCq!!\u001e\u0019\u0001\u0004\tI!A\u0004f]\u000e\u0014\u0018\u0010\u001d;\u0015\u0019\u0005}\u0011\u0011WA[\u0003o\u000bY,a0\t\u000f\u0005M\u0016\u00041\u0001\u0002x\u0005!A-\u0019;b\u0011\u001d\t))\u0007a\u0001\u0003\u000fCq!!/\u001a\u0001\u0004\tI!\u0001\u0005gS2,g*Y7f\u0011\u0019\ti,\u0007a\u0001\u0017\u0006!1/\u001b>f\u0011!\t\t-\u0007I\u0001\u0002\u0004)\u0016a\u00027bgRlu\u000eZ\u0001\u0012K:\u001c'/\u001f9uI\u0011,g-Y;mi\u0012*TCAAdU\r)\u0016\u0011Z\u0016\u0003\u0003\u0017\u0004B!!4\u0002X6\u0011\u0011q\u001a\u0006\u0005\u0003#\f\u0019.A\u0005v]\u000eDWmY6fI*\u0019\u0011Q[\u0017\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002Z\u0006='!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u000611/\u0019<f)>$B!a\b\u0002`\"9\u0011QQ\u000eA\u0002\u0005\u001d\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0016\u0005\u0005%\u0011!\u0003)vE2L7mS3z!\t\u0011dd\u0005\u0002\u001fWQ\u0011\u0011q]\u0001\u0006CB\u0004H.\u001f\u000b\u0004\u000f\u0006E\b\"\u0002\u001d!\u0001\u0004Q\u0014AB;ooJ\f\u0007\u000fF\u0002;\u0003oDa!!?\"\u0001\u00049\u0015aA6fs\u0002")
public class PublicKey
implements PublicKeyLike,
StreamingSaveable {
    private volatile PublicKey$userIDs$ userIDs$module;
    private volatile PublicKey$signatures$ signatures$module;
    private String toString;
    private final PGPPublicKey nested;
    private volatile boolean bitmap$0;

    public static PGPPublicKey unwrap(PublicKey publicKey) {
        return PublicKey$.MODULE$.unwrap(publicKey);
    }

    public static PublicKey apply(PGPPublicKey pGPPublicKey) {
        return PublicKey$.MODULE$.apply(pGPPublicKey);
    }

    @Override
    public void saveToFile(File file) {
        StreamingSaveable.saveToFile$(this, file);
    }

    @Override
    public String saveToString() {
        return StreamingSaveable.saveToString$(this);
    }

    @Override
    public final boolean verifyMessageFile(File input, File output) {
        return PublicKeyLike.verifyMessageFile$(this, input, output);
    }

    @Override
    public final String verifyMessageString(String input) {
        return PublicKeyLike.verifyMessageString$(this, input);
    }

    @Override
    public final boolean verifySignatureFile(File raw, File signature) {
        return PublicKeyLike.verifySignatureFile$(this, raw, signature);
    }

    @Override
    public final boolean verifySignatureString(String msg, String signature) {
        return PublicKeyLike.verifySignatureString$(this, msg, signature);
    }

    @Override
    public boolean verifyMessageStreamHelper(InputStream input, OutputStream output, Function1<Object, PGPPublicKey> getKey) {
        return PublicKeyLike.verifyMessageStreamHelper$(this, input, output, getKey);
    }

    @Override
    public boolean verifySignatureStreamsHelper(InputStream msg, InputStream signature, Function1<Object, PGPPublicKey> getKey) {
        return PublicKeyLike.verifySignatureStreamsHelper$(this, msg, signature, getKey);
    }

    public PublicKey$userIDs$ userIDs() {
        if (this.userIDs$module == null) {
            this.userIDs$lzycompute$1();
        }
        return this.userIDs$module;
    }

    public PublicKey$signatures$ signatures() {
        if (this.signatures$module == null) {
            this.signatures$lzycompute$1();
        }
        return this.signatures$module;
    }

    public PGPPublicKey nested() {
        return this.nested;
    }

    public long keyID() {
        return this.nested().getKeyID();
    }

    public int bitStrength() {
        return this.nested().getBitStrength();
    }

    public Date creationTime() {
        return this.nested().getCreationTime();
    }

    public byte[] fingerprint() {
        return this.nested().getFingerprint();
    }

    public boolean isRevoked() {
        return this.nested().isRevoked();
    }

    public int algorithm() {
        return this.nested().getAlgorithm();
    }

    public String algorithmName() {
        String string;
        int n = this.nested().getAlgorithm();
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                string = "RSA";
                break;
            }
            case 17: {
                string = "DSA";
                break;
            }
            case 18: {
                string = "EC";
                break;
            }
            case 16: 
            case 20: {
                string = "ElGamal";
                break;
            }
            case 19: {
                string = "ECDSA";
                break;
            }
            default: {
                string = "Unknown";
                break;
            }
        }
        return string;
    }

    public Traversable<Signature> signaturesForId(String id) {
        return new Traversable<Signature>(this, id){
            private final /* synthetic */ PublicKey $outer;
            private final String id$1;

            public GenericCompanion<Traversable> companion() {
                return Traversable.companion$((Traversable)this);
            }

            public Traversable<Signature> seq() {
                return Traversable.seq$((Traversable)this);
            }

            public Builder<Signature, Traversable<Signature>> newBuilder() {
                return GenericTraversableTemplate.newBuilder$((GenericTraversableTemplate)this);
            }

            public <B> Builder<B, Traversable<B>> genericBuilder() {
                return GenericTraversableTemplate.genericBuilder$((GenericTraversableTemplate)this);
            }

            public <A1, A2> Tuple2<Traversable<A1>, Traversable<A2>> unzip(Function1<Signature, Tuple2<A1, A2>> asPair) {
                return GenericTraversableTemplate.unzip$((GenericTraversableTemplate)this, asPair);
            }

            public <A1, A2, A3> Tuple3<Traversable<A1>, Traversable<A2>, Traversable<A3>> unzip3(Function1<Signature, Tuple3<A1, A2, A3>> asTriple) {
                return GenericTraversableTemplate.unzip3$((GenericTraversableTemplate)this, asTriple);
            }

            public GenTraversable flatten(Function1 asTraversable) {
                return GenericTraversableTemplate.flatten$((GenericTraversableTemplate)this, (Function1)asTraversable);
            }

            public GenTraversable transpose(Function1 asTraversable) {
                return GenericTraversableTemplate.transpose$((GenericTraversableTemplate)this, (Function1)asTraversable);
            }

            public Object repr() {
                return TraversableLike.repr$((TraversableLike)this);
            }

            public final boolean isTraversableAgain() {
                return TraversableLike.isTraversableAgain$((TraversableLike)this);
            }

            public Traversable<Signature> thisCollection() {
                return TraversableLike.thisCollection$((TraversableLike)this);
            }

            public Traversable toCollection(Object repr) {
                return TraversableLike.toCollection$((TraversableLike)this, (Object)repr);
            }

            public Combiner<Signature, ParIterable<Signature>> parCombiner() {
                return TraversableLike.parCombiner$((TraversableLike)this);
            }

            public boolean isEmpty() {
                return TraversableLike.isEmpty$((TraversableLike)this);
            }

            public boolean hasDefiniteSize() {
                return TraversableLike.hasDefiniteSize$((TraversableLike)this);
            }

            public <B, That> That $plus$plus(GenTraversableOnce<B> that, CanBuildFrom<Traversable<Signature>, B, That> bf) {
                return (That)TraversableLike.$plus$plus$((TraversableLike)this, that, bf);
            }

            public <B, That> That $plus$plus$colon(TraversableOnce<B> that, CanBuildFrom<Traversable<Signature>, B, That> bf) {
                return (That)TraversableLike.$plus$plus$colon$((TraversableLike)this, that, bf);
            }

            public <B, That> That $plus$plus$colon(Traversable<B> that, CanBuildFrom<Traversable<Signature>, B, That> bf) {
                return (That)TraversableLike.$plus$plus$colon$((TraversableLike)this, that, bf);
            }

            public <B, That> That map(Function1<Signature, B> f, CanBuildFrom<Traversable<Signature>, B, That> bf) {
                return (That)TraversableLike.map$((TraversableLike)this, f, bf);
            }

            public <B, That> That flatMap(Function1<Signature, GenTraversableOnce<B>> f, CanBuildFrom<Traversable<Signature>, B, That> bf) {
                return (That)TraversableLike.flatMap$((TraversableLike)this, f, bf);
            }

            public Object filterImpl(Function1 p, boolean isFlipped) {
                return TraversableLike.filterImpl$((TraversableLike)this, (Function1)p, (boolean)isFlipped);
            }

            public Object filter(Function1 p) {
                return TraversableLike.filter$((TraversableLike)this, (Function1)p);
            }

            public Object filterNot(Function1 p) {
                return TraversableLike.filterNot$((TraversableLike)this, (Function1)p);
            }

            public <B, That> That collect(PartialFunction<Signature, B> pf, CanBuildFrom<Traversable<Signature>, B, That> bf) {
                return (That)TraversableLike.collect$((TraversableLike)this, pf, bf);
            }

            public Tuple2<Traversable<Signature>, Traversable<Signature>> partition(Function1<Signature, Object> p) {
                return TraversableLike.partition$((TraversableLike)this, p);
            }

            public <K> Map<K, Traversable<Signature>> groupBy(Function1<Signature, K> f) {
                return TraversableLike.groupBy$((TraversableLike)this, f);
            }

            public boolean forall(Function1<Signature, Object> p) {
                return TraversableLike.forall$((TraversableLike)this, p);
            }

            public boolean exists(Function1<Signature, Object> p) {
                return TraversableLike.exists$((TraversableLike)this, p);
            }

            public Option<Signature> find(Function1<Signature, Object> p) {
                return TraversableLike.find$((TraversableLike)this, p);
            }

            public <B, That> That scan(B z, Function2<B, B, B> op, CanBuildFrom<Traversable<Signature>, B, That> cbf) {
                return (That)TraversableLike.scan$((TraversableLike)this, z, op, cbf);
            }

            public <B, That> That scanLeft(B z, Function2<B, Signature, B> op, CanBuildFrom<Traversable<Signature>, B, That> bf) {
                return (That)TraversableLike.scanLeft$((TraversableLike)this, z, op, bf);
            }

            public <B, That> That scanRight(B z, Function2<Signature, B, B> op, CanBuildFrom<Traversable<Signature>, B, That> bf) {
                return (That)TraversableLike.scanRight$((TraversableLike)this, z, op, bf);
            }

            public Object head() {
                return TraversableLike.head$((TraversableLike)this);
            }

            public Option<Signature> headOption() {
                return TraversableLike.headOption$((TraversableLike)this);
            }

            public Object tail() {
                return TraversableLike.tail$((TraversableLike)this);
            }

            public Object last() {
                return TraversableLike.last$((TraversableLike)this);
            }

            public Option<Signature> lastOption() {
                return TraversableLike.lastOption$((TraversableLike)this);
            }

            public Object init() {
                return TraversableLike.init$((TraversableLike)this);
            }

            public Object take(int n) {
                return TraversableLike.take$((TraversableLike)this, (int)n);
            }

            public Object drop(int n) {
                return TraversableLike.drop$((TraversableLike)this, (int)n);
            }

            public Object slice(int from, int until) {
                return TraversableLike.slice$((TraversableLike)this, (int)from, (int)until);
            }

            public Object sliceWithKnownDelta(int from, int until, int delta) {
                return TraversableLike.sliceWithKnownDelta$((TraversableLike)this, (int)from, (int)until, (int)delta);
            }

            public Object sliceWithKnownBound(int from, int until) {
                return TraversableLike.sliceWithKnownBound$((TraversableLike)this, (int)from, (int)until);
            }

            public Object takeWhile(Function1 p) {
                return TraversableLike.takeWhile$((TraversableLike)this, (Function1)p);
            }

            public Object dropWhile(Function1 p) {
                return TraversableLike.dropWhile$((TraversableLike)this, (Function1)p);
            }

            public Tuple2<Traversable<Signature>, Traversable<Signature>> span(Function1<Signature, Object> p) {
                return TraversableLike.span$((TraversableLike)this, p);
            }

            public Tuple2<Traversable<Signature>, Traversable<Signature>> splitAt(int n) {
                return TraversableLike.splitAt$((TraversableLike)this, (int)n);
            }

            public Iterator<Traversable<Signature>> tails() {
                return TraversableLike.tails$((TraversableLike)this);
            }

            public Iterator<Traversable<Signature>> inits() {
                return TraversableLike.inits$((TraversableLike)this);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                TraversableLike.copyToArray$((TraversableLike)this, (Object)xs, (int)start, (int)len);
            }

            public Traversable<Signature> toTraversable() {
                return TraversableLike.toTraversable$((TraversableLike)this);
            }

            public Iterator<Signature> toIterator() {
                return TraversableLike.toIterator$((TraversableLike)this);
            }

            public Stream<Signature> toStream() {
                return TraversableLike.toStream$((TraversableLike)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, Signature, Col> cbf) {
                return (Col)TraversableLike.to$((TraversableLike)this, cbf);
            }

            public String toString() {
                return TraversableLike.toString$((TraversableLike)this);
            }

            public String stringPrefix() {
                return TraversableLike.stringPrefix$((TraversableLike)this);
            }

            public TraversableView<Signature, Traversable<Signature>> view() {
                return TraversableLike.view$((TraversableLike)this);
            }

            public TraversableView<Signature, Traversable<Signature>> view(int from, int until) {
                return TraversableLike.view$((TraversableLike)this, (int)from, (int)until);
            }

            public FilterMonadic<Signature, Traversable<Signature>> withFilter(Function1<Signature, Object> p) {
                return TraversableLike.withFilter$((TraversableLike)this, p);
            }

            public Parallel par() {
                return Parallelizable.par$((Parallelizable)this);
            }

            public List<Signature> reversed() {
                return TraversableOnce.reversed$((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.size$((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.nonEmpty$((TraversableOnce)this);
            }

            public int count(Function1<Signature, Object> p) {
                return TraversableOnce.count$((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<Signature, B> pf) {
                return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, Signature, B> op) {
                return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<Signature, B, B> op) {
                return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, Signature, B> op) {
                return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<Signature, B, B> op) {
                return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, Signature, B> op) {
                return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<Signature, B, B> op) {
                return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, Signature, B> op) {
                return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<Signature, B, B> op) {
                return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.reduceOption$((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, Signature, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.sum$((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.product$((TraversableOnce)this, num);
            }

            public Object min(Ordering cmp) {
                return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object max(Ordering cmp) {
                return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
            }

            public List<Signature> toList() {
                return TraversableOnce.toList$((TraversableOnce)this);
            }

            public Iterable<Signature> toIterable() {
                return TraversableOnce.toIterable$((TraversableOnce)this);
            }

            public Seq<Signature> toSeq() {
                return TraversableOnce.toSeq$((TraversableOnce)this);
            }

            public IndexedSeq<Signature> toIndexedSeq() {
                return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.toBuffer$((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.toSet$((TraversableOnce)this);
            }

            public Vector<Signature> toVector() {
                return TraversableOnce.toVector$((TraversableOnce)this);
            }

            public <T, U> Map<T, U> toMap(Predef$.less.colon.less<Signature, Tuple2<T, U>> ev) {
                return TraversableOnce.toMap$((TraversableOnce)this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.mkString$((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
            }

            public int sizeHintIfCheap() {
                return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
            }

            public <U> void foreach(Function1<Signature, U> f) {
                java.util.Iterator i = this.$outer.nested().getSignaturesForID(this.id$1);
                while (i.hasNext()) {
                    f.apply((Object)Signature$.MODULE$.apply((PGPSignature)i.next()));
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.id$1 = id$1;
                GenTraversableOnce.$init$((GenTraversableOnce)this);
                TraversableOnce.$init$((TraversableOnce)this);
                Parallelizable.$init$((Parallelizable)this);
                TraversableLike.$init$((TraversableLike)this);
                GenericTraversableTemplate.$init$((GenericTraversableTemplate)this);
                GenTraversable.$init$((GenTraversable)this);
                Traversable.$init$((Traversable)this);
            }
        };
    }

    public Traversable<Signature> directKeySignatures() {
        return this.signatures().view().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)PublicKey.$anonfun$directKeySignatures$1(x$1)));
    }

    @Override
    public boolean verifyMessageStream(InputStream input, OutputStream output) {
        return this.verifyMessageStreamHelper(input, output, (Function1<Object, PGPPublicKey>)(Function1 & Serializable & scala.Serializable)id -> PublicKey.$anonfun$verifyMessageStream$1(this, BoxesRunTime.unboxToLong((Object)id)));
    }

    @Override
    public boolean verifySignatureStreams(InputStream msg, InputStream signature) {
        return this.verifySignatureStreamsHelper(msg, signature, (Function1<Object, PGPPublicKey>)(Function1 & Serializable & scala.Serializable)id -> PublicKey.$anonfun$verifySignatureStreams$1(this, BoxesRunTime.unboxToLong((Object)id)));
    }

    public void encryptFile(File input, File output) {
        FileInputStream in = new FileInputStream(input);
        FileOutputStream out = new FileOutputStream(output);
        try {
            this.encrypt(in, out, input.getName(), input.length(), new Date(input.lastModified()));
        }
        finally {
            in.close();
            out.close();
        }
    }

    public String encryptString(String input) {
        byte[] bytes = input.getBytes();
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.encrypt(in, out, "", bytes.length, new Date());
        }
        finally {
            in.close();
            out.close();
        }
        return out.toString(Charset.defaultCharset().name());
    }

    public void encrypt(InputStream data, OutputStream output, String fileName, long size, Date lastMod) {
        ArmoredOutputStream aout = new ArmoredOutputStream(output);
        byte[] bytes = (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte());
        SecureRandom rand = new SecureRandom();
        Provider provider = Security.getProvider("BC");
        int encAlgorithm = 3;
        boolean withIntegrityPacket = true;
        JcePGPDataEncryptorBuilder encryptorBuilder = new JcePGPDataEncryptorBuilder(encAlgorithm).setWithIntegrityPacket(withIntegrityPacket).setSecureRandom(rand).setProvider(provider);
        PGPEncryptedDataGenerator encGen = new PGPEncryptedDataGenerator((PGPDataEncryptorBuilder)encryptorBuilder);
        encGen.addMethod((PGPKeyEncryptionMethodGenerator)new JcePublicKeyKeyEncryptionMethodGenerator(this.nested()).setProvider(provider).setSecureRandom(rand));
        OutputStream cOut = encGen.open((OutputStream)aout, new byte[1024]);
        PGPLiteralDataGenerator lit = new PGPLiteralDataGenerator();
        OutputStream lOut = lit.open(cOut, 'b', fileName, size, lastMod);
        byte[] buffer = new byte[1024];
        this.read$1(data, buffer, lOut);
        lit.close();
        cOut.close();
        aout.close();
        data.close();
    }

    public Date encrypt$default$5() {
        return new Date();
    }

    @Override
    public void saveTo(OutputStream output) {
        ArmoredOutputStream armoredOut = new ArmoredOutputStream(output);
        this.nested().encode((OutputStream)armoredOut);
        armoredOut.close();
    }

    private String toString$lzycompute() {
        PublicKey publicKey = this;
        synchronized (publicKey) {
            if (!this.bitmap$0) {
                this.toString = new StringOps(Predef$.MODULE$.augmentString("PublicKey(%x, %s, %s@%d)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.keyID()), this.userIDs().mkString(","), this.algorithmName(), BoxesRunTime.boxToInteger((int)this.bitStrength())}));
                this.bitmap$0 = true;
            }
        }
        return this.toString;
    }

    public String toString() {
        return !this.bitmap$0 ? this.toString$lzycompute() : this.toString;
    }

    private final void userIDs$lzycompute$1() {
        PublicKey publicKey = this;
        synchronized (publicKey) {
            if (this.userIDs$module == null) {
                this.userIDs$module = new PublicKey$userIDs$(this);
            }
        }
    }

    private final void signatures$lzycompute$1() {
        PublicKey publicKey = this;
        synchronized (publicKey) {
            if (this.signatures$module == null) {
                this.signatures$module = new PublicKey$signatures$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$directKeySignatures$1(Signature x$1) {
        return x$1.signatureType() == 31;
    }

    public static final /* synthetic */ PGPPublicKey $anonfun$verifyMessageStream$1(PublicKey $this, long id) {
        Predef$.MODULE$.assert(id == $this.keyID());
        return $this.nested();
    }

    public static final /* synthetic */ PGPPublicKey $anonfun$verifySignatureStreams$1(PublicKey $this, long id) {
        if ($this.keyID() != id) {
            throw package$.MODULE$.error(new StringOps(Predef$.MODULE$.augmentString("Signature is not for this key.  %x != %x")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)id), BoxesRunTime.boxToLong((long)$this.keyID())})));
        }
        return $this.nested();
    }

    private final void read$1(InputStream data$1, byte[] buffer$1, OutputStream lOut$1) {
        while (true) {
            int n = data$1.read(buffer$1);
            switch (n) {
                default: 
            }
            if (n <= 0) break;
            lOut$1.write(buffer$1, 0, n);
        }
    }

    public PublicKey(PGPPublicKey nested) {
        this.nested = nested;
        PublicKeyLike.$init$(this);
        StreamingSaveable.$init$(this);
    }
}

