/*
 * Decompiled with CFR 0.152.
 */
package com.jsuereth.pgp;

import com.jsuereth.pgp.PublicKey$;
import com.jsuereth.pgp.PublicKey$signatures$;
import com.jsuereth.pgp.PublicKey$userIDs$;
import com.jsuereth.pgp.PublicKeyLike;
import com.jsuereth.pgp.Signature;
import com.jsuereth.pgp.Signature$;
import com.jsuereth.pgp.StreamingSaveable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.Charset;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Date;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.jcajce.JcePGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyKeyEncryptionMethodGenerator;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Parallel;
import scala.collection.Parallelizable;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.TraversableView;
import scala.collection.generic.CanBuildFrom;
import scala.collection.generic.FilterMonadic;
import scala.collection.generic.GenericCompanion;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.StringBuilder;
import scala.collection.parallel.Combiner;
import scala.collection.parallel.ParIterable;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\t5a\u0001\u0002\u0013&\u00011B\u0001B\u000f\u0001\u0003\u0006\u0004%\ta\u000f\u0005\t\r\u0002\u0011\t\u0011)A\u0005y!)q\t\u0001C\u0001\u0011\")1\n\u0001C\u0001\u0019\")\u0001\u000b\u0001C\u0001#\")Q\u000b\u0001C\u0001-\")q\f\u0001C\u0001A\")q\r\u0001C\u0001Q\")A\u000e\u0001C\u0001#\")Q\u000e\u0001C\u0001]\u001e)Q\u000f\u0001E\u0001m\u001a)\u0001\u0010\u0001E\u0001s\"1q\t\u0004C\u0001\u00037Aq!!\b\r\t\u0003\ny\u0002C\u0004\u0002J1!\t!a\u0013\b\u000f\u0005M\u0003\u0001#\u0001\u0002V\u00199\u0011q\u000b\u0001\t\u0002\u0005e\u0003BB$\u0012\t\u0003\t\u0019\u0007C\u0004\u0002\u001eE!\t%!\u001a\t\u000f\u0005%\u0013\u0003\"\u0001\u0002r!9\u0011Q\u000f\u0001\u0005\u0002\u0005]\u0004bBA?\u0001\u0011\u0005\u0011q\u0010\u0005\b\u0003\u0003\u0003A\u0011AAB\u0011\u001d\ty\n\u0001C\u0001\u0003CCq!a+\u0001\t\u0003\ti\u000bC\u0004\u0002:\u0002!\t!a/\t\u000f\u0005}\u0006\u0001\"\u0001\u0002B\"I\u0011Q\u001b\u0001\u0012\u0002\u0013\u0005\u0011q\u001b\u0005\b\u0003[\u0004A\u0011AAx\u0011)\t\u0019\u0010\u0001EC\u0002\u0013\u0005\u0013Q_\u0004\b\u0003o,\u0003\u0012AA}\r\u0019!S\u0005#\u0001\u0002|\"1q\t\tC\u0001\u0003{Dq!a@!\t\u0003\u0011\t\u0001C\u0004\u0003\u0006\u0001\"\u0019Aa\u0002\u0003\u0013A+(\r\\5d\u0017\u0016L(B\u0001\u0014(\u0003\r\u0001x\r\u001d\u0006\u0003Q%\n\u0001B[:vKJ,G\u000f\u001b\u0006\u0002U\u0005\u00191m\\7\u0004\u0001M!\u0001!L\u001a8!\tq\u0013'D\u00010\u0015\u0005\u0001\u0014!B:dC2\f\u0017B\u0001\u001a0\u0005\u0019\te.\u001f*fMB\u0011A'N\u0007\u0002K%\u0011a'\n\u0002\u000e!V\u0014G.[2LKfd\u0015n[3\u0011\u0005QB\u0014BA\u001d&\u0005E\u0019FO]3b[&twmU1wK\u0006\u0014G.Z\u0001\u0007]\u0016\u001cH/\u001a3\u0016\u0003q\u0002\"!\u0010#\u000e\u0003yR!a\u0010!\u0002\u000f=\u0004XM\u001c9ha*\u0011\u0011IQ\u0001\rE>,hnY=dCN$H.\u001a\u0006\u0002\u0007\u0006\u0019qN]4\n\u0005\u0015s$\u0001\u0004)H!B+(\r\\5d\u0017\u0016L\u0018a\u00028fgR,G\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005%S\u0005C\u0001\u001b\u0001\u0011\u0015Q4\u00011\u0001=\u0003\u0015YW-_%E+\u0005i\u0005C\u0001\u0018O\u0013\tyuF\u0001\u0003M_:<\u0017a\u00032jiN#(/\u001a8hi\",\u0012A\u0015\t\u0003]MK!\u0001V\u0018\u0003\u0007%sG/\u0001\u0007de\u0016\fG/[8o)&lW-F\u0001X!\tAV,D\u0001Z\u0015\tQ6,\u0001\u0003vi&d'\"\u0001/\u0002\t)\fg/Y\u0005\u0003=f\u0013A\u0001R1uK\u0006Ya-\u001b8hKJ\u0004(/\u001b8u+\u0005\t\u0007c\u0001\u0018cI&\u00111m\f\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003]\u0015L!AZ\u0018\u0003\t\tKH/Z\u0001\nSN\u0014VM^8lK\u0012,\u0012!\u001b\t\u0003])L!a[\u0018\u0003\u000f\t{w\u000e\\3b]\u0006I\u0011\r\\4pe&$\b.\\\u0001\u000eC2<wN]5uQ6t\u0015-\\3\u0016\u0003=\u0004\"\u0001]:\u000e\u0003ET!A].\u0002\t1\fgnZ\u0005\u0003iF\u0014aa\u0015;sS:<\u0017aB;tKJLEi\u001d\t\u0003o2i\u0011\u0001\u0001\u0002\bkN,'/\u0013#t'\raQF\u001f\t\u0006w\u0006\u001d\u0011Q\u0002\b\u0004y\u0006\rabA?\u0002\u00025\taP\u0003\u0002\u0000W\u00051AH]8pizJ\u0011\u0001M\u0005\u0004\u0003\u000by\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003\u0013\tYAA\u0006Ue\u00064XM]:bE2,'bAA\u0003_A!\u0011qBA\f\u001d\u0011\t\t\"a\u0005\u0011\u0005u|\u0013bAA\u000b_\u00051\u0001K]3eK\u001aL1\u0001^A\r\u0015\r\t)b\f\u000b\u0002m\u00069am\u001c:fC\u000eDW\u0003BA\u0011\u0003o!B!a\t\u0002*A\u0019a&!\n\n\u0007\u0005\u001drF\u0001\u0003V]&$\bbBA\u0016\u001d\u0001\u0007\u0011QF\u0001\u0002MB9a&a\f\u0002\u000e\u0005M\u0012bAA\u0019_\tIa)\u001e8di&|g.\r\t\u0005\u0003k\t9\u0004\u0004\u0001\u0005\u000f\u0005ebB1\u0001\u0002<\t\tQ+\u0005\u0003\u0002>\u0005\r\u0003c\u0001\u0018\u0002@%\u0019\u0011\u0011I\u0018\u0003\u000f9{G\u000f[5oOB\u0019a&!\u0012\n\u0007\u0005\u001dsFA\u0002B]f\f\u0001\"\u001b;fe\u0006$xN]\u000b\u0003\u0003\u001b\u0002Ra_A(\u0003\u001bIA!!\u0015\u0002\f\tA\u0011\n^3sCR|'/\u0001\u0006tS\u001et\u0017\r^;sKN\u0004\"a^\t\u0003\u0015MLwM\\1ukJ,7o\u0005\u0003\u0012[\u0005m\u0003#B>\u0002\b\u0005u\u0003c\u0001\u001b\u0002`%\u0019\u0011\u0011M\u0013\u0003\u0013MKwM\\1ukJ,GCAA++\u0011\t9'a\u001c\u0015\t\u0005\r\u0012\u0011\u000e\u0005\b\u0003W\u0019\u0002\u0019AA6!\u001dq\u0013qFA/\u0003[\u0002B!!\u000e\u0002p\u00119\u0011\u0011H\nC\u0002\u0005mRCAA:!\u0015Y\u0018qJA/\u0003=\u0019\u0018n\u001a8biV\u0014Xm\u001d$pe&#G\u0003BA.\u0003sBq!a\u001f\u0016\u0001\u0004\ti!\u0001\u0002jI\u0006\u0019B-\u001b:fGR\\U-_*jO:\fG/\u001e:fgV\u0011\u00111L\u0001\u0014m\u0016\u0014\u0018NZ=NKN\u001c\u0018mZ3TiJ,\u0017-\u001c\u000b\u0006S\u0006\u0015\u0015Q\u0013\u0005\b\u0003\u000f;\u0002\u0019AAE\u0003\u0015Ig\u000e];u!\u0011\tY)!%\u000e\u0005\u00055%bAAH7\u0006\u0011\u0011n\\\u0005\u0005\u0003'\u000biIA\u0006J]B,Ho\u0015;sK\u0006l\u0007bBAL/\u0001\u0007\u0011\u0011T\u0001\u0007_V$\b/\u001e;\u0011\t\u0005-\u00151T\u0005\u0005\u0003;\u000biI\u0001\u0007PkR\u0004X\u000f^*ue\u0016\fW.\u0001\fwKJLg-_*jO:\fG/\u001e:f'R\u0014X-Y7t)\u0015I\u00171UAT\u0011\u001d\t)\u000b\u0007a\u0001\u0003\u0013\u000b1!\\:h\u0011\u001d\tI\u000b\u0007a\u0001\u0003\u0013\u000b\u0011b]5h]\u0006$XO]3\u0002\u0017\u0015t7M]=qi\u001aKG.\u001a\u000b\u0007\u0003G\ty+a.\t\u000f\u0005\u001d\u0015\u00041\u0001\u00022B!\u00111RAZ\u0013\u0011\t),!$\u0003\t\u0019KG.\u001a\u0005\b\u0003/K\u0002\u0019AAY\u00035)gn\u0019:zaR\u001cFO]5oOR!\u0011QBA_\u0011\u001d\t9I\u0007a\u0001\u0003\u001b\tq!\u001a8def\u0004H\u000f\u0006\u0007\u0002$\u0005\r\u0017qYAe\u0003\u001b\f\t\u000eC\u0004\u0002Fn\u0001\r!!#\u0002\t\u0011\fG/\u0019\u0005\b\u0003/[\u0002\u0019AAM\u0011\u001d\tYm\u0007a\u0001\u0003\u001b\t\u0001BZ5mK:\u000bW.\u001a\u0005\u0007\u0003\u001f\\\u0002\u0019A'\u0002\tML'0\u001a\u0005\t\u0003'\\\u0002\u0013!a\u0001/\u00069A.Y:u\u001b>$\u0017!E3oGJL\b\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%kU\u0011\u0011\u0011\u001c\u0016\u0004/\u0006m7FAAo!\u0011\ty.!;\u000e\u0005\u0005\u0005(\u0002BAr\u0003K\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u001dx&\u0001\u0006b]:|G/\u0019;j_:LA!a;\u0002b\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\rM\fg/\u001a+p)\u0011\t\u0019#!=\t\u000f\u0005]U\u00041\u0001\u0002\u001a\u0006AAo\\*ue&tw-\u0006\u0002\u0002\u000e\u0005I\u0001+\u001e2mS\u000e\\U-\u001f\t\u0003i\u0001\u001a\"\u0001I\u0017\u0015\u0005\u0005e\u0018!B1qa2LHcA%\u0003\u0004!)!H\ta\u0001y\u00051QO\\<sCB$2\u0001\u0010B\u0005\u0011\u0019\u0011Ya\ta\u0001\u0013\u0006\u00191.Z=")
public class PublicKey
implements PublicKeyLike,
StreamingSaveable {
    private volatile PublicKey$userIDs$ userIDs$module;
    private volatile PublicKey$signatures$ signatures$module;
    private String toString;
    private final PGPPublicKey nested;
    private volatile boolean bitmap$0;

    public static PGPPublicKey unwrap(PublicKey publicKey) {
        return PublicKey$.MODULE$.unwrap(publicKey);
    }

    public static PublicKey apply(PGPPublicKey pGPPublicKey) {
        return PublicKey$.MODULE$.apply(pGPPublicKey);
    }

    @Override
    public void saveToFile(File file) {
        StreamingSaveable.saveToFile$(this, file);
    }

    @Override
    public String saveToString() {
        return StreamingSaveable.saveToString$(this);
    }

    @Override
    public final boolean verifyMessageFile(File input, File output) {
        return PublicKeyLike.verifyMessageFile$(this, input, output);
    }

    @Override
    public final String verifyMessageString(String input) {
        return PublicKeyLike.verifyMessageString$(this, input);
    }

    @Override
    public final boolean verifySignatureFile(File raw, File signature) {
        return PublicKeyLike.verifySignatureFile$(this, raw, signature);
    }

    @Override
    public final boolean verifySignatureString(String msg, String signature) {
        return PublicKeyLike.verifySignatureString$(this, msg, signature);
    }

    @Override
    public boolean verifyMessageStreamHelper(InputStream input, OutputStream output, Function1<Object, PGPPublicKey> getKey) {
        return PublicKeyLike.verifyMessageStreamHelper$(this, input, output, getKey);
    }

    @Override
    public boolean verifySignatureStreamsHelper(InputStream msg, InputStream signature, Function1<Object, PGPPublicKey> getKey) {
        return PublicKeyLike.verifySignatureStreamsHelper$(this, msg, signature, getKey);
    }

    public PublicKey$userIDs$ userIDs() {
        if (this.userIDs$module == null) {
            this.userIDs$lzycompute$1();
        }
        return this.userIDs$module;
    }

    public PublicKey$signatures$ signatures() {
        if (this.signatures$module == null) {
            this.signatures$lzycompute$1();
        }
        return this.signatures$module;
    }

    public PGPPublicKey nested() {
        return this.nested;
    }

    public long keyID() {
        return this.nested().getKeyID();
    }

    public int bitStrength() {
        return this.nested().getBitStrength();
    }

    public Date creationTime() {
        return this.nested().getCreationTime();
    }

    public byte[] fingerprint() {
        return this.nested().getFingerprint();
    }

    public boolean isRevoked() {
        return this.nested().isRevoked();
    }

    public int algorithm() {
        return this.nested().getAlgorithm();
    }

    public String algorithmName() {
        String string;
        int n = this.nested().getAlgorithm();
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                string = "RSA";
                break;
            }
            case 17: {
                string = "DSA";
                break;
            }
            case 18: {
                string = "EC";
                break;
            }
            case 16: 
            case 20: {
                string = "ElGamal";
                break;
            }
            case 19: {
                string = "ECDSA";
                break;
            }
            default: {
                string = "Unknown";
                break;
            }
        }
        return string;
    }

    public Traversable<Signature> signaturesForId(String id) {
        return new Traversable<Signature>(this, id){
            private final /* synthetic */ PublicKey $outer;
            private final String id$1;

            public GenericCompanion<Traversable> companion() {
                return Traversable.companion$((Traversable)this);
            }

            public Traversable<Signature> seq() {
                return Traversable.seq$((Traversable)this);
            }

            public Builder<Signature, Traversable<Signature>> newBuilder() {
                return GenericTraversableTemplate.newBuilder$((GenericTraversableTemplate)this);
            }

            public <B> Builder<B, Traversable<B>> genericBuilder() {
                return GenericTraversableTemplate.genericBuilder$((GenericTraversableTemplate)this);
            }

            public <A1, A2> Tuple2<Traversable<A1>, Traversable<A2>> unzip(Function1<Signature, Tuple2<A1, A2>> asPair) {
                return GenericTraversableTemplate.unzip$((GenericTraversableTemplate)this, asPair);
            }

            public <A1, A2, A3> Tuple3<Traversable<A1>, Traversable<A2>, Traversable<A3>> unzip3(Function1<Signature, Tuple3<A1, A2, A3>> asTriple) {
                return GenericTraversableTemplate.unzip3$((GenericTraversableTemplate)this, asTriple);
            }

            public GenTraversable flatten(Function1 asTraversable) {
                return GenericTraversableTemplate.flatten$((GenericTraversableTemplate)this, (Function1)asTraversable);
            }

            public GenTraversable transpose(Function1 asTraversable) {
                return GenericTraversableTemplate.transpose$((GenericTraversableTemplate)this, (Function1)asTraversable);
            }

            public Object repr() {
                return TraversableLike.repr$((TraversableLike)this);
            }

            public final boolean isTraversableAgain() {
                return TraversableLike.isTraversableAgain$((TraversableLike)this);
            }

            public Traversable<Signature> thisCollection() {
                return TraversableLike.thisCollection$((TraversableLike)this);
            }

            public Traversable toCollection(Object repr) {
                return TraversableLike.toCollection$((TraversableLike)this, (Object)repr);
            }

            public Combiner<Signature, ParIterable<Signature>> parCombiner() {
                return TraversableLike.parCombiner$((TraversableLike)this);
            }

            public boolean isEmpty() {
                return TraversableLike.isEmpty$((TraversableLike)this);
            }

            public boolean hasDefiniteSize() {
                return TraversableLike.hasDefiniteSize$((TraversableLike)this);
            }

            public <B, That> That $plus$plus(GenTraversableOnce<B> that, CanBuildFrom<Traversable<Signature>, B, That> bf) {
                return (That)TraversableLike.$plus$plus$((TraversableLike)this, that, bf);
            }

            public <B, That> That $plus$plus$colon(TraversableOnce<B> that, CanBuildFrom<Traversable<Signature>, B, That> bf) {
                return (That)TraversableLike.$plus$plus$colon$((TraversableLike)this, that, bf);
            }

            public <B, That> That $plus$plus$colon(Traversable<B> that, CanBuildFrom<Traversable<Signature>, B, That> bf) {
                return (That)TraversableLike.$plus$plus$colon$((TraversableLike)this, that, bf);
            }

            public <B, That> That map(Function1<Signature, B> f, CanBuildFrom<Traversable<Signature>, B, That> bf) {
                return (That)TraversableLike.map$((TraversableLike)this, f, bf);
            }

            public <B, That> That flatMap(Function1<Signature, GenTraversableOnce<B>> f, CanBuildFrom<Traversable<Signature>, B, That> bf) {
                return (That)TraversableLike.flatMap$((TraversableLike)this, f, bf);
            }

            public Object filterImpl(Function1 p, boolean isFlipped) {
                return TraversableLike.filterImpl$((TraversableLike)this, (Function1)p, (boolean)isFlipped);
            }

            public Object filter(Function1 p) {
                return TraversableLike.filter$((TraversableLike)this, (Function1)p);
            }

            public Object filterNot(Function1 p) {
                return TraversableLike.filterNot$((TraversableLike)this, (Function1)p);
            }

            public <B, That> That collect(PartialFunction<Signature, B> pf, CanBuildFrom<Traversable<Signature>, B, That> bf) {
                return (That)TraversableLike.collect$((TraversableLike)this, pf, bf);
            }

            public Tuple2<Traversable<Signature>, Traversable<Signature>> partition(Function1<Signature, Object> p) {
                return TraversableLike.partition$((TraversableLike)this, p);
            }

            public <K> Map<K, Traversable<Signature>> groupBy(Function1<Signature, K> f) {
                return TraversableLike.groupBy$((TraversableLike)this, f);
            }

            public boolean forall(Function1<Signature, Object> p) {
                return TraversableLike.forall$((TraversableLike)this, p);
            }

            public boolean exists(Function1<Signature, Object> p) {
                return TraversableLike.exists$((TraversableLike)this, p);
            }

            public Option<Signature> find(Function1<Signature, Object> p) {
                return TraversableLike.find$((TraversableLike)this, p);
            }

            public <B, That> That scan(B z, Function2<B, B, B> op, CanBuildFrom<Traversable<Signature>, B, That> cbf) {
                return (That)TraversableLike.scan$((TraversableLike)this, z, op, cbf);
            }

            public <B, That> That scanLeft(B z, Function2<B, Signature, B> op, CanBuildFrom<Traversable<Signature>, B, That> bf) {
                return (That)TraversableLike.scanLeft$((TraversableLike)this, z, op, bf);
            }

            public <B, That> That scanRight(B z, Function2<Signature, B, B> op, CanBuildFrom<Traversable<Signature>, B, That> bf) {
                return (That)TraversableLike.scanRight$((TraversableLike)this, z, op, bf);
            }

            public Object head() {
                return TraversableLike.head$((TraversableLike)this);
            }

            public Option<Signature> headOption() {
                return TraversableLike.headOption$((TraversableLike)this);
            }

            public Object tail() {
                return TraversableLike.tail$((TraversableLike)this);
            }

            public Object last() {
                return TraversableLike.last$((TraversableLike)this);
            }

            public Option<Signature> lastOption() {
                return TraversableLike.lastOption$((TraversableLike)this);
            }

            public Object init() {
                return TraversableLike.init$((TraversableLike)this);
            }

            public Object take(int n) {
                return TraversableLike.take$((TraversableLike)this, (int)n);
            }

            public Object drop(int n) {
                return TraversableLike.drop$((TraversableLike)this, (int)n);
            }

            public Object slice(int from, int until) {
                return TraversableLike.slice$((TraversableLike)this, (int)from, (int)until);
            }

            public Object sliceWithKnownDelta(int from, int until, int delta) {
                return TraversableLike.sliceWithKnownDelta$((TraversableLike)this, (int)from, (int)until, (int)delta);
            }

            public Object sliceWithKnownBound(int from, int until) {
                return TraversableLike.sliceWithKnownBound$((TraversableLike)this, (int)from, (int)until);
            }

            public Object takeWhile(Function1 p) {
                return TraversableLike.takeWhile$((TraversableLike)this, (Function1)p);
            }

            public Object dropWhile(Function1 p) {
                return TraversableLike.dropWhile$((TraversableLike)this, (Function1)p);
            }

            public Tuple2<Traversable<Signature>, Traversable<Signature>> span(Function1<Signature, Object> p) {
                return TraversableLike.span$((TraversableLike)this, p);
            }

            public Tuple2<Traversable<Signature>, Traversable<Signature>> splitAt(int n) {
                return TraversableLike.splitAt$((TraversableLike)this, (int)n);
            }

            public Iterator<Traversable<Signature>> tails() {
                return TraversableLike.tails$((TraversableLike)this);
            }

            public Iterator<Traversable<Signature>> inits() {
                return TraversableLike.inits$((TraversableLike)this);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                TraversableLike.copyToArray$((TraversableLike)this, (Object)xs, (int)start, (int)len);
            }

            public Traversable<Signature> toTraversable() {
                return TraversableLike.toTraversable$((TraversableLike)this);
            }

            public Iterator<Signature> toIterator() {
                return TraversableLike.toIterator$((TraversableLike)this);
            }

            public Stream<Signature> toStream() {
                return TraversableLike.toStream$((TraversableLike)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, Signature, Col> cbf) {
                return (Col)TraversableLike.to$((TraversableLike)this, cbf);
            }

            public String toString() {
                return TraversableLike.toString$((TraversableLike)this);
            }

            public String stringPrefix() {
                return TraversableLike.stringPrefix$((TraversableLike)this);
            }

            public TraversableView<Signature, Traversable<Signature>> view() {
                return TraversableLike.view$((TraversableLike)this);
            }

            public TraversableView<Signature, Traversable<Signature>> view(int from, int until) {
                return TraversableLike.view$((TraversableLike)this, (int)from, (int)until);
            }

            public FilterMonadic<Signature, Traversable<Signature>> withFilter(Function1<Signature, Object> p) {
                return TraversableLike.withFilter$((TraversableLike)this, p);
            }

            public Parallel par() {
                return Parallelizable.par$((Parallelizable)this);
            }

            public List<Signature> reversed() {
                return TraversableOnce.reversed$((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.size$((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.nonEmpty$((TraversableOnce)this);
            }

            public int count(Function1<Signature, Object> p) {
                return TraversableOnce.count$((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<Signature, B> pf) {
                return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, Signature, B> op) {
                return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<Signature, B, B> op) {
                return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, Signature, B> op) {
                return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<Signature, B, B> op) {
                return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, Signature, B> op) {
                return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<Signature, B, B> op) {
                return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, Signature, B> op) {
                return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<Signature, B, B> op) {
                return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.reduceOption$((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, Signature, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.sum$((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.product$((TraversableOnce)this, num);
            }

            public Object min(Ordering cmp) {
                return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object max(Ordering cmp) {
                return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
            }

            public List<Signature> toList() {
                return TraversableOnce.toList$((TraversableOnce)this);
            }

            public Iterable<Signature> toIterable() {
                return TraversableOnce.toIterable$((TraversableOnce)this);
            }

            public Seq<Signature> toSeq() {
                return TraversableOnce.toSeq$((TraversableOnce)this);
            }

            public IndexedSeq<Signature> toIndexedSeq() {
                return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.toBuffer$((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.toSet$((TraversableOnce)this);
            }

            public Vector<Signature> toVector() {
                return TraversableOnce.toVector$((TraversableOnce)this);
            }

            public <T, U> Map<T, U> toMap(Predef$.less.colon.less<Signature, Tuple2<T, U>> ev) {
                return TraversableOnce.toMap$((TraversableOnce)this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.mkString$((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
            }

            public int sizeHintIfCheap() {
                return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
            }

            public <U> void foreach(Function1<Signature, U> f) {
                this.iterator().foreach(f);
            }

            private Iterator<Signature> iterator() {
                return ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(this.$outer.nested().getSignaturesForID(this.id$1)).asScala()).map((Function1 & Serializable & scala.Serializable)sig -> Signature$.MODULE$.apply((PGPSignature)sig));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.id$1 = id$1;
                GenTraversableOnce.$init$((GenTraversableOnce)this);
                TraversableOnce.$init$((TraversableOnce)this);
                Parallelizable.$init$((Parallelizable)this);
                TraversableLike.$init$((TraversableLike)this);
                GenericTraversableTemplate.$init$((GenericTraversableTemplate)this);
                GenTraversable.$init$((GenTraversable)this);
                Traversable.$init$((Traversable)this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$iterator$2(org.bouncycastle.openpgp.PGPSignature )}, serializedLambda);
            }
        };
    }

    public Traversable<Signature> directKeySignatures() {
        return this.signatures().view().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)PublicKey.$anonfun$directKeySignatures$1(x$1)));
    }

    @Override
    public boolean verifyMessageStream(InputStream input, OutputStream output) {
        return this.verifyMessageStreamHelper(input, output, (Function1<Object, PGPPublicKey>)(Function1 & Serializable & scala.Serializable)id -> PublicKey.$anonfun$verifyMessageStream$1(this, BoxesRunTime.unboxToLong((Object)id)));
    }

    @Override
    public boolean verifySignatureStreams(InputStream msg, InputStream signature) {
        return this.verifySignatureStreamsHelper(msg, signature, (Function1<Object, PGPPublicKey>)(Function1 & Serializable & scala.Serializable)id -> PublicKey.$anonfun$verifySignatureStreams$1(this, BoxesRunTime.unboxToLong((Object)id)));
    }

    public void encryptFile(File input, File output) {
        FileInputStream in = new FileInputStream(input);
        FileOutputStream out = new FileOutputStream(output);
        try {
            this.encrypt(in, out, input.getName(), input.length(), new Date(input.lastModified()));
        }
        finally {
            in.close();
            out.close();
        }
    }

    public String encryptString(String input) {
        byte[] bytes = input.getBytes();
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.encrypt(in, out, "", bytes.length, new Date());
        }
        finally {
            in.close();
            out.close();
        }
        return out.toString(Charset.defaultCharset().name());
    }

    public void encrypt(InputStream data, OutputStream output, String fileName, long size, Date lastMod) {
        ArmoredOutputStream aout = new ArmoredOutputStream(output);
        byte[] bytes = (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte());
        SecureRandom rand = new SecureRandom();
        Provider provider = Security.getProvider("BC");
        int encAlgorithm = 3;
        boolean withIntegrityPacket = true;
        JcePGPDataEncryptorBuilder encryptorBuilder = new JcePGPDataEncryptorBuilder(encAlgorithm).setWithIntegrityPacket(withIntegrityPacket).setSecureRandom(rand).setProvider(provider);
        PGPEncryptedDataGenerator encGen = new PGPEncryptedDataGenerator((PGPDataEncryptorBuilder)encryptorBuilder);
        encGen.addMethod((PGPKeyEncryptionMethodGenerator)new JcePublicKeyKeyEncryptionMethodGenerator(this.nested()).setProvider(provider).setSecureRandom(rand));
        OutputStream cOut = encGen.open((OutputStream)aout, new byte[1024]);
        PGPLiteralDataGenerator lit = new PGPLiteralDataGenerator();
        OutputStream lOut = lit.open(cOut, 'b', fileName, size, lastMod);
        byte[] buffer = new byte[1024];
        this.read$1(data, buffer, lOut);
        lit.close();
        cOut.close();
        aout.close();
        data.close();
    }

    public Date encrypt$default$5() {
        return new Date();
    }

    @Override
    public void saveTo(OutputStream output) {
        ArmoredOutputStream armoredOut = new ArmoredOutputStream(output);
        this.nested().encode((OutputStream)armoredOut);
        armoredOut.close();
    }

    private String toString$lzycompute() {
        PublicKey publicKey = this;
        synchronized (publicKey) {
            if (!this.bitmap$0) {
                this.toString = new StringOps(Predef$.MODULE$.augmentString("PublicKey(%x, %s, %s@%d)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.keyID()), this.userIDs().mkString(","), this.algorithmName(), BoxesRunTime.boxToInteger((int)this.bitStrength())}));
                this.bitmap$0 = true;
            }
        }
        return this.toString;
    }

    public String toString() {
        return !this.bitmap$0 ? this.toString$lzycompute() : this.toString;
    }

    private final void userIDs$lzycompute$1() {
        PublicKey publicKey = this;
        synchronized (publicKey) {
            if (this.userIDs$module == null) {
                this.userIDs$module = new PublicKey$userIDs$(this);
            }
        }
    }

    private final void signatures$lzycompute$1() {
        PublicKey publicKey = this;
        synchronized (publicKey) {
            if (this.signatures$module == null) {
                this.signatures$module = new PublicKey$signatures$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$directKeySignatures$1(Signature x$1) {
        return x$1.signatureType() == 31;
    }

    public static final /* synthetic */ PGPPublicKey $anonfun$verifyMessageStream$1(PublicKey $this, long id) {
        Predef$.MODULE$.assert(id == $this.keyID());
        return $this.nested();
    }

    public static final /* synthetic */ PGPPublicKey $anonfun$verifySignatureStreams$1(PublicKey $this, long id) {
        if ($this.keyID() != id) {
            throw package$.MODULE$.error(new StringOps(Predef$.MODULE$.augmentString("Signature is not for this key.  %x != %x")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)id), BoxesRunTime.boxToLong((long)$this.keyID())})));
        }
        return $this.nested();
    }

    private final void read$1(InputStream data$1, byte[] buffer$1, OutputStream lOut$1) {
        while (true) {
            int n = data$1.read(buffer$1);
            switch (n) {
                default: 
            }
            if (n <= 0) break;
            lOut$1.write(buffer$1, 0, n);
        }
    }

    public PublicKey(PGPPublicKey nested) {
        this.nested = nested;
        PublicKeyLike.$init$(this);
        StreamingSaveable.$init$(this);
    }
}

