/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbt.jacoco.report;

import com.github.sbt.jacoco.filter.FilteringAnalyzer;
import com.github.sbt.jacoco.report.DirectoriesSourceFileLocator;
import com.github.sbt.jacoco.report.JacocoReportSettings;
import com.github.sbt.jacoco.report.JacocoSourceSettings;
import com.github.sbt.jacoco.report.formats.JacocoReportFormat;
import java.io.File;
import java.io.Serializable;
import java.text.DecimalFormat;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.analysis.ICounter;
import org.jacoco.core.analysis.ICoverageVisitor;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.data.SessionInfoStore;
import org.jacoco.core.tools.ExecFileLoader;
import org.jacoco.report.IReportVisitor;
import org.jacoco.report.ISourceFileLocator;
import sbt.internal.util.Init;
import sbt.std.TaskStreams;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Md\u0001\u0002\n\u0014\u0001yA\u0001\"\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\tu\u0001\u0011\t\u0011)A\u0005M!A1\b\u0001B\u0001B\u0003%a\u0005\u0003\u0005=\u0001\t\u0005\t\u0015!\u0003>\u0011!\t\u0005A!A!\u0002\u0013\u0011\u0005\u0002C#\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001a\t\u0011\u0019\u0003!\u0011!Q\u0001\n\u001dC\u0001\"\u0015\u0001\u0003\u0002\u0003\u0006IA\u0015\u0005\u0006+\u0002!\tA\u0016\u0005\bA\u0002\u0011\r\u0011\"\u0003b\u0011\u0019A\u0007\u0001)A\u0005E\")\u0011\u000e\u0001C\u0001U\")\u0011\u000b\u0001C\u0001]\"1A\u0010\u0001C\u0001+uDq!a\f\u0001\t\u0013\t\t\u0004C\u0004\u0002L\u0001!I!!\u0014\t\u000f\u0005]\u0003\u0001\"\u0003\u0002Z\t1!+\u001a9peRT!\u0001F\u000b\u0002\rI,\u0007o\u001c:u\u0015\t1r#\u0001\u0004kC\u000e|7m\u001c\u0006\u00031e\t1a\u001d2u\u0015\tQ2$\u0001\u0004hSRDWO\u0019\u0006\u00029\u0005\u00191m\\7\u0004\u0001M\u0011\u0001a\b\t\u0003A\rj\u0011!\t\u0006\u0002E\u0005)1oY1mC&\u0011A%\t\u0002\u0007\u0003:L(+\u001a4\u0002%\u0015DXmY;uS>tG)\u0019;b\r&dWm\u001d\t\u0004O=\u0012dB\u0001\u0015.\u001d\tIC&D\u0001+\u0015\tYS$\u0001\u0004=e>|GOP\u0005\u0002E%\u0011a&I\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0001\u0014GA\u0002TKFT!AL\u0011\u0011\u0005MBT\"\u0001\u001b\u000b\u0005U2\u0014AA5p\u0015\u00059\u0014\u0001\u00026bm\u0006L!!\u000f\u001b\u0003\t\u0019KG.Z\u0001\u0011G2\f7o\u001d#je\u0016\u001cGo\u001c:jKN\f\u0011c]8ve\u000e,G)\u001b:fGR|'/[3t\u00039\u0019x.\u001e:dKN+G\u000f^5oON\u0004\"AP \u000e\u0003MI!\u0001Q\n\u0003))\u000b7m\\2p'>,(oY3TKR$\u0018N\\4t\u00039\u0011X\r]8siN+G\u000f^5oON\u0004\"AP\"\n\u0005\u0011\u001b\"\u0001\u0006&bG>\u001cwNU3q_J$8+\u001a;uS:<7/A\bsKB|'\u000f\u001e#je\u0016\u001cGo\u001c:z\u0003\u001d\u0019HO]3b[N\u0004\"\u0001\u0013(\u000f\u0005%[eBA\u0015K\u0013\u0005A\u0012B\u0001'N\u0003\u0011YU-_:\u000b\u0003aI!a\u0014)\u0003\u0017Q\u000b7o[*ue\u0016\fWn\u001d\u0006\u0003\u00196\u000bQb\u00195fG.\u001cuN^3sC\u001e,\u0007C\u0001\u0011T\u0013\t!\u0016EA\u0004C_>dW-\u00198\u0002\rqJg.\u001b;?)%9\u0006,\u0017.\\9vsv\f\u0005\u0002?\u0001!)Q%\u0003a\u0001M!)!(\u0003a\u0001M!)1(\u0003a\u0001M!)A(\u0003a\u0001{!)\u0011)\u0003a\u0001\u0005\")Q)\u0003a\u0001e!)a)\u0003a\u0001\u000f\")\u0011+\u0003a\u0001%\u0006\u0001\u0002/\u001a:dK:$\u0018mZ3G_Jl\u0017\r^\u000b\u0002EB\u00111MZ\u0007\u0002I*\u0011QMN\u0001\u0005i\u0016DH/\u0003\u0002hI\niA)Z2j[\u0006dgi\u001c:nCR\f\u0011\u0003]3sG\u0016tG/Y4f\r>\u0014X.\u0019;!\u0003!9WM\\3sCR,G#A6\u0011\u0005\u0001b\u0017BA7\"\u0005\u0011)f.\u001b;\u0015\u0005I{\u0007\"\u00029\u000e\u0001\u0004\t\u0018A\u00022v]\u0012dW\r\u0005\u0002su6\t1O\u0003\u0002uk\u0006A\u0011M\\1msNL7O\u0003\u0002wo\u0006!1m\u001c:f\u0015\t1\u0002PC\u0001z\u0003\ry'oZ\u0005\u0003wN\u0014q\"\u0013\"v]\u0012dWmQ8wKJ\fw-Z\u0001\rG\",7m[\"pk:$XM\u001d\u000b\t%z\f\t\"a\u0007\u0002&!1qP\u0004a\u0001\u0003\u0003\tA!\u001e8jiB!\u00111AA\u0006\u001d\u0011\t)!a\u0002\u0011\u0005%\n\u0013bAA\u0005C\u00051\u0001K]3eK\u001aLA!!\u0004\u0002\u0010\t11\u000b\u001e:j]\u001eT1!!\u0003\"\u0011\u001d\t\u0019B\u0004a\u0001\u0003+\t\u0011a\u0019\t\u0004e\u0006]\u0011bAA\rg\nA\u0011jQ8v]R,'\u000fC\u0004\u0002\u001e9\u0001\r!a\b\u0002\u0011I,\u0017/^5sK\u0012\u00042\u0001IA\u0011\u0013\r\t\u0019#\t\u0002\u0007\t>,(\r\\3\t\u000f\u0005\u001db\u00021\u0001\u0002*\u0005q1/^7nCJL()^5mI\u0016\u0014\bcA\u0014\u0002,%\u0019\u0011QF\u0019\u0003\u001bM#(/\u001b8h\u0005VLG\u000eZ3s\u0003Eaw.\u00193Fq\u0016\u001cW\u000f^5p]\u0012\u000bG/Y\u000b\u0003\u0003g\u0001r\u0001IA\u001b\u0003s\t)%C\u0002\u00028\u0005\u0012a\u0001V;qY\u0016\u0014\u0004\u0003BA\u001e\u0003\u0003j!!!\u0010\u000b\u0007\u0005}R/\u0001\u0003eCR\f\u0017\u0002BA\"\u0003{\u0011!#\u0012=fGV$\u0018n\u001c8ECR\f7\u000b^8sKB!\u00111HA$\u0013\u0011\tI%!\u0010\u0003!M+7o]5p]&sgm\\*u_J,\u0017\u0001E1oC2L(0Z*ueV\u001cG/\u001e:f)\u0015\t\u0018qJA*\u0011\u001d\t\t\u0006\u0005a\u0001\u0003s\t!#\u001a=fGV$\u0018n\u001c8ECR\f7\u000b^8sK\"9\u0011Q\u000b\tA\u0002\u0005\u0015\u0013\u0001E:fgNLwN\\%oM>\u001cFo\u001c:f\u00031\u0019'/Z1uKJ+\u0007o\u001c:u)%Y\u00171LA6\u0003_\n\t\bC\u0004\u0002^E\u0001\r!a\u0018\u0002\u0019I,\u0007o\u001c:u\r>\u0014X.\u0019;\u0011\t\u0005\u0005\u0014qM\u0007\u0003\u0003GR1!!\u001a\u0014\u0003\u001d1wN]7biNLA!!\u001b\u0002d\t\u0011\"*Y2pG>\u0014V\r]8si\u001a{'/\\1u\u0011\u0019\ti'\u0005a\u0001c\u0006q!-\u001e8eY\u0016\u001cuN^3sC\u001e,\u0007bBA)#\u0001\u0007\u0011\u0011\b\u0005\b\u0003+\n\u0002\u0019AA#\u0001")
public class Report {
    private final Seq<File> executionDataFiles;
    private final Seq<File> classDirectories;
    private final Seq<File> sourceDirectories;
    private final JacocoSourceSettings sourceSettings;
    private final JacocoReportSettings reportSettings;
    private final File reportDirectory;
    private final TaskStreams<Init.ScopedKey<?>> streams;
    private final boolean checkCoverage;
    private final DecimalFormat percentageFormat;

    private DecimalFormat percentageFormat() {
        return this.percentageFormat;
    }

    public void generate() {
        Tuple2<ExecutionDataStore, SessionInfoStore> tuple2 = this.loadExecutionData();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        ExecutionDataStore executionDataStore = (ExecutionDataStore)tuple2._1();
        SessionInfoStore sessionInfoStore = (SessionInfoStore)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)executionDataStore, (Object)sessionInfoStore);
        Tuple2 tuple23 = tuple22;
        ExecutionDataStore executionDataStore2 = (ExecutionDataStore)tuple23._1();
        SessionInfoStore sessionInfoStore2 = (SessionInfoStore)tuple23._2();
        IBundleCoverage bundleCoverage = this.analyzeStructure(executionDataStore2, sessionInfoStore2);
        this.reportSettings.formats().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            this.createReport(x$2, bundleCoverage, executionDataStore2, sessionInfoStore2);
            return BoxedUnit.UNIT;
        });
        if (this.checkCoverage && !this.checkCoverage(bundleCoverage)) {
            throw scala.sys.package$.MODULE$.error("Required coverage is not met");
        }
    }

    public boolean checkCoverage(IBundleCoverage bundle) {
        StringBuilder sb = package$.MODULE$.StringBuilder().newBuilder();
        sb.$plus$plus$eq("\n------- ");
        sb.$plus$plus$eq(this.reportSettings.title());
        sb.$plus$plus$eq(" -------\n\n");
        boolean bl = this.checkCounter("Lines", bundle.getLineCounter(), this.reportSettings.thresholds().line(), sb);
        boolean bl2 = this.checkCounter("Instructions", bundle.getInstructionCounter(), this.reportSettings.thresholds().instruction(), sb);
        boolean bl3 = this.checkCounter("Branches", bundle.getBranchCounter(), this.reportSettings.thresholds().branch(), sb);
        boolean bl4 = this.checkCounter("Methods", bundle.getMethodCounter(), this.reportSettings.thresholds().method(), sb);
        boolean bl5 = this.checkCounter("Complexity", bundle.getComplexityCounter(), this.reportSettings.thresholds().complexity(), sb);
        boolean bl6 = this.checkCounter("Class", bundle.getClassCounter(), this.reportSettings.thresholds().clazz(), sb);
        List checkResult = Nil$.MODULE$.$colon$colon((Object)BoxesRunTime.boxToBoolean((boolean)bl6)).$colon$colon((Object)BoxesRunTime.boxToBoolean((boolean)bl5)).$colon$colon((Object)BoxesRunTime.boxToBoolean((boolean)bl4)).$colon$colon((Object)BoxesRunTime.boxToBoolean((boolean)bl3)).$colon$colon((Object)BoxesRunTime.boxToBoolean((boolean)bl2)).$colon$colon((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        sb.$plus$plus$eq("\nCheck ");
        sb.$plus$plus$eq(this.reportDirectory.getAbsolutePath());
        sb.$plus$plus$eq(" for detailed report\n ");
        this.streams.log().info((Function0 & Serializable & scala.Serializable)() -> sb.toString());
        return !checkResult.contains((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    public boolean checkCounter(String unit, ICounter c, double required, StringBuilder summaryBuilder) {
        int missedCount = c.getMissedCount();
        int totalCount = c.getTotalCount();
        double coveredRatio = Double.isNaN(c.getCoveredRatio()) ? 0.0 : c.getCoveredRatio();
        double ratioPercent = coveredRatio * (double)100;
        boolean success = ratioPercent >= required;
        String sign = success ? ">=" : "<";
        String status = success ? "OK" : "NOK";
        String formattedRatio = this.percentageFormat().format(ratioPercent);
        summaryBuilder.$plus$plus$eq(unit);
        summaryBuilder.$plus$plus$eq(": ");
        summaryBuilder.$plus$plus$eq(formattedRatio);
        summaryBuilder.$plus$plus$eq("% (");
        summaryBuilder.$plus$plus$eq(sign);
        summaryBuilder.$plus$plus$eq(" required ");
        summaryBuilder.$plus$plus$eq(Double.toString(required));
        summaryBuilder.$plus$plus$eq("%) covered, ");
        summaryBuilder.$plus$plus$eq(Integer.toString(missedCount));
        summaryBuilder.$plus$plus$eq(" of ");
        summaryBuilder.$plus$plus$eq(Integer.toString(totalCount));
        summaryBuilder.$plus$plus$eq(" missed, ");
        summaryBuilder.$plus$plus$eq(status);
        summaryBuilder.$plus$plus$eq("\n");
        return success;
    }

    private Tuple2<ExecutionDataStore, SessionInfoStore> loadExecutionData() {
        ExecFileLoader loader = new ExecFileLoader();
        this.executionDataFiles.foreach((Function1 & Serializable & scala.Serializable)f -> {
            Report.$anonfun$loadExecutionData$1(loader, f);
            return BoxedUnit.UNIT;
        });
        return new Tuple2((Object)loader.getExecutionDataStore(), (Object)loader.getSessionInfoStore());
    }

    private IBundleCoverage analyzeStructure(ExecutionDataStore executionDataStore, SessionInfoStore sessionInfoStore) {
        CoverageBuilder coverageBuilder = new CoverageBuilder();
        FilteringAnalyzer analyzer = new FilteringAnalyzer(executionDataStore, (ICoverageVisitor)coverageBuilder);
        this.classDirectories.foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)analyzer.analyzeAll(x$1)));
        return coverageBuilder.getBundle(this.reportSettings.title());
    }

    private void createReport(JacocoReportFormat reportFormat, IBundleCoverage bundleCoverage, ExecutionDataStore executionDataStore, SessionInfoStore sessionInfoStore) {
        IReportVisitor visitor = reportFormat.createVisitor(this.reportDirectory, this.reportSettings.fileEncoding());
        visitor.visitInfo(sessionInfoStore.getInfos(), executionDataStore.getContents());
        visitor.visitBundle(bundleCoverage, (ISourceFileLocator)new DirectoriesSourceFileLocator(this.sourceDirectories, this.sourceSettings));
        visitor.visitEnd();
    }

    public static final /* synthetic */ void $anonfun$loadExecutionData$1(ExecFileLoader loader$1, File f) {
        block0: {
            if (!f.exists()) break block0;
            loader$1.load(f);
        }
    }

    public Report(Seq<File> executionDataFiles, Seq<File> classDirectories, Seq<File> sourceDirectories, JacocoSourceSettings sourceSettings, JacocoReportSettings reportSettings, File reportDirectory, TaskStreams<Init.ScopedKey<?>> streams, boolean checkCoverage) {
        this.executionDataFiles = executionDataFiles;
        this.classDirectories = classDirectories;
        this.sourceDirectories = sourceDirectories;
        this.sourceSettings = sourceSettings;
        this.reportSettings = reportSettings;
        this.reportDirectory = reportDirectory;
        this.streams = streams;
        this.checkCoverage = checkCoverage;
        this.percentageFormat = new DecimalFormat("#.##");
    }
}

