/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.sbt.packager.universal;

import com.typesafe.sbt.packager.permissions$;
import com.typesafe.sbt.packager.permissions$OctalString$;
import com.typesafe.sbt.packager.sourceDateEpoch$;
import com.typesafe.sbt.packager.universal.ZipHelper;
import com.typesafe.sbt.packager.universal.ZipHelper$FileMapping$;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import sbt.io.RichFile$;
import sbt.package$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.Traversable$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.sys.process.Process$;

public final class ZipHelper$ {
    public static ZipHelper$ MODULE$;

    static {
        new ZipHelper$();
    }

    public void zipNative(Traversable<Tuple2<File, String>> sources, File outputZip) {
        package$.MODULE$.IO().withTemporaryDirectory((Function1 & Serializable & scala.Serializable)dir -> {
            ZipHelper$.$anonfun$zipNative$1(outputZip, sources, dir);
            return BoxedUnit.UNIT;
        });
    }

    public void zip(Traversable<Tuple2<File, String>> sources, File outputZip) {
        Seq mappings = (Seq)((TraversableLike)sources.toSeq().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)ZipHelper$.$anonfun$zip$1(check$ifrefutable$3))).map((Function1 & Serializable & scala.Serializable)x$6 -> {
            Tuple2 tuple2 = x$6;
            if (tuple2 != null) {
                File file = (File)tuple2._1();
                int perm = file.isDirectory() || file.canExecute() ? permissions$OctalString$.MODULE$.oct$extension(permissions$.MODULE$.OctalString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0755"}))), (Seq<Object>)Nil$.MODULE$) : permissions$OctalString$.MODULE$.oct$extension(permissions$.MODULE$.OctalString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0644"}))), (Seq<Object>)Nil$.MODULE$);
                return new Tuple2((Object)tuple2, (Object)BoxesRunTime.boxToInteger((int)perm));
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$7 -> {
            Tuple2 tuple2 = x$7;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                int perm = tuple2._2$mcI$sp();
                if (tuple22 != null) {
                    File file = (File)tuple22._1();
                    String name = (String)tuple22._2();
                    return new ZipHelper.FileMapping(file, name, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)perm)));
                }
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
        this.archive((Seq<ZipHelper.FileMapping>)mappings, outputZip);
    }

    public void zipNIO(Traversable<Tuple2<File, String>> sources, File outputZip) {
        Predef$.MODULE$.require(!outputZip.isDirectory(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Specified output file ").append(outputZip).append(" is a directory.").toString());
        Seq mappings = (Seq)sources.toSeq().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                File file = (File)tuple2._1();
                String name = (String)tuple2._2();
                return new ZipHelper.FileMapping(file, name, ZipHelper$FileMapping$.MODULE$.apply$default$3());
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
        File outputDir = outputZip.getParentFile();
        package$.MODULE$.IO().createDirectory(outputDir);
        this.withZipFilesystem(outputZip, this.withZipFilesystem$default$2(), (Function1<FileSystem, BoxedUnit>)(Function1 & Serializable & scala.Serializable)system -> {
            mappings.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                ZipHelper.FileMapping fileMapping = x0$2;
                if (fileMapping != null) {
                    File dir = fileMapping.file();
                    String name = fileMapping.name();
                    if (dir.isDirectory()) {
                        return Files.createDirectories(system.getPath(name, new String[0]), new FileAttribute[0]);
                    }
                }
                if (fileMapping != null) {
                    File file = fileMapping.file();
                    String name = fileMapping.name();
                    Path dest = system.getPath(name, new String[0]);
                    Option$.MODULE$.apply((Object)dest.getParent()).foreach((Function1 & Serializable & scala.Serializable)x$8 -> Files.createDirectories(x$8, new FileAttribute[0]));
                    return Files.copy(file.toPath(), dest, StandardCopyOption.COPY_ATTRIBUTES);
                }
                throw new MatchError((Object)fileMapping);
            });
            return BoxedUnit.UNIT;
        });
    }

    private void archive(Seq<ZipHelper.FileMapping> sources, File outputFile) {
        if (outputFile.isDirectory()) {
            throw scala.sys.package$.MODULE$.error(new StringBuilder(38).append("Specified output file ").append(outputFile).append(" is a directory.").toString());
        }
        File outputDir = outputFile.getParentFile();
        package$.MODULE$.IO().createDirectory(outputDir);
        this.withZipOutput(outputFile, (Function1<ZipArchiveOutputStream, BoxedUnit>)(Function1 & Serializable & scala.Serializable)output -> {
            ZipHelper$.$anonfun$archive$1(sources, output);
            return BoxedUnit.UNIT;
        });
    }

    private void withZipOutput(File file, Function1<ZipArchiveOutputStream, BoxedUnit> f) {
        zipOut.setLevel(9);
        try (ZipArchiveOutputStream zipOut = new ZipArchiveOutputStream(file);){
            try {
                f.apply((Object)zipOut);
            }
            catch (Throwable t) {
                IOUtils.closeQuietly((Closeable)zipOut);
                throw t;
            }
        }
    }

    private String normalizePath(String path) {
        char sep = File.separatorChar;
        if (sep == '/') {
            return path;
        }
        return path.replace(sep, '/');
    }

    public void withZipFilesystem(File zipFile, boolean overwrite, Function1<FileSystem, BoxedUnit> f) {
        Object object = overwrite ? BoxesRunTime.boxToBoolean((boolean)Files.deleteIfExists(zipFile.toPath())) : BoxedUnit.UNIT;
        java.util.Map env = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"create"), (Object)"true")}))).asJava();
        URI uri = new URI("jar", zipFile.toPath().toUri().toString(), null);
        try (FileSystem system = FileSystems.newFileSystem(uri, env);){
            f.apply((Object)system);
        }
    }

    public boolean withZipFilesystem$default$2() {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$zipNative$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$zipNative$4(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$zipNative$5(Tuple2 x$2) {
        Tuple2 tuple2 = x$2;
        if (tuple2 != null) {
            File src = (File)tuple2._1();
            return src.canExecute();
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$zipNative$6(Tuple2 x$3) {
        Tuple2 tuple2 = x$3;
        if (tuple2 != null) {
            File target = (File)tuple2._2();
            return target.setExecutable(true, true);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$zipNative$1(File outputZip$1, Traversable sources$1, File dir) {
        String name = outputZip$1.getName();
        File zipDir = RichFile$.MODULE$.$div$extension(package$.MODULE$.fileToRichFile(dir), name.endsWith(".zip") ? (String)new StringOps(Predef$.MODULE$.augmentString(name)).dropRight(4) : name);
        Traversable files = (Traversable)sources$1.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ZipHelper$.$anonfun$zipNative$2(check$ifrefutable$1))).map((Function1 & Serializable & scala.Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                File file = (File)tuple2._1();
                String name = (String)tuple2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)file), (Object)RichFile$.MODULE$.$div$extension(package$.MODULE$.fileToRichFile(zipDir), name));
            }
            throw new MatchError((Object)tuple2);
        }, Traversable$.MODULE$.canBuildFrom());
        package$.MODULE$.IO().copy(files);
        files.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)ZipHelper$.$anonfun$zipNative$4(check$ifrefutable$2))).withFilter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ZipHelper$.$anonfun$zipNative$5(x$2))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ZipHelper$.$anonfun$zipNative$6(x$3)));
        sourceDateEpoch$.MODULE$.apply(zipDir);
        String[] dirFileNames = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Option$.MODULE$.apply((Object)zipDir.listFiles()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (File[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class))))).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getName(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        int n = Process$.MODULE$.apply((Seq)((TraversableLike)new .colon.colon((Object)"zip", (List)new .colon.colon((Object)"-o", (List)new .colon.colon((Object)"-r", (List)new .colon.colon((Object)name, (List)Nil$.MODULE$))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dirFileNames)), Seq$.MODULE$.canBuildFrom()), zipDir, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0])).$bang();
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw scala.sys.package$.MODULE$.error("Failed to run native zip application!");
            }
        }
        package$.MODULE$.IO().copyFile(RichFile$.MODULE$.$div$extension(package$.MODULE$.fileToRichFile(zipDir), name), outputZip$1);
    }

    public static final /* synthetic */ boolean $anonfun$zip$1(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$archive$2(ZipHelper.FileMapping check$ifrefutable$4) {
        ZipHelper.FileMapping fileMapping = check$ifrefutable$4;
        return fileMapping != null;
    }

    public static final /* synthetic */ void $anonfun$archive$1(Seq sources$2, ZipArchiveOutputStream output) {
        sources$2.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)ZipHelper$.$anonfun$archive$2(check$ifrefutable$4))).foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
            ZipHelper.FileMapping fileMapping = x$9;
            if (fileMapping != null) {
                Object object;
                block8: {
                    File file = fileMapping.file();
                    String name = fileMapping.name();
                    Option<Object> mode = fileMapping.unixMode();
                    String n = MODULE$.normalizePath(name);
                    String entryName = file.isDirectory() && !n.endsWith("/") ? new StringBuilder(1).append(n).append("/").toString() : n;
                    ZipArchiveEntry entry = new ZipArchiveEntry(entryName);
                    scala.sys.package$.MODULE$.env().get((Object)"SOURCE_DATE_EPOCH").foreach((Function1 & Serializable & scala.Serializable)epoch -> {
                        long millis = new StringOps(Predef$.MODULE$.augmentString(epoch)).toLong() * 1000L;
                        return entry.setLastModifiedTime(FileTime.fromMillis(millis));
                    });
                    mode.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$1 -> entry.setUnixMode(x$1));
                    output.putArchiveEntry(entry);
                    try {
                        if (file.isFile()) {
                            try (FileInputStream fis = new FileInputStream(file);){
                                object = BoxesRunTime.boxToLong((long)IOUtils.copy((InputStream)fis, (OutputStream)output));
                                break block8;
                            }
                        }
                        object = BoxedUnit.UNIT;
                    }
                    finally {
                        output.closeArchiveEntry();
                    }
                }
                return object;
            }
            throw new MatchError((Object)fileMapping);
        });
    }

    private ZipHelper$() {
        MODULE$ = this;
    }
}

