/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.sbt.packager.universal;

import com.typesafe.sbt.packager.universal.ZipHelper$;
import java.io.File;
import java.io.Serializable;
import sbt.io.RichFile$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function5;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.process.Process$;

public final class Archives$ {
    public static Archives$ MODULE$;
    private final Function5<File, String, Seq<Tuple2<File, String>>, Option<String>, Seq<String>, File> makeTxz;
    private final Function5<File, String, Seq<Tuple2<File, String>>, Option<String>, Seq<String>, File> makeTgz;

    static {
        new Archives$();
    }

    public File makeZip(File target, String name, Seq<Tuple2<File, String>> mappings, Option<String> top) {
        return this.makeZip(target, name, mappings, top, (Seq<String>)((Seq)Nil$.MODULE$));
    }

    public File makeZip(File target, String name, Seq<Tuple2<File, String>> mappings, Option<String> top, Seq<String> options) {
        File zip = RichFile$.MODULE$.$div$extension(sbt.package$.MODULE$.fileToRichFile(target), new StringBuilder(4).append(name).append(".zip").toString());
        Seq m2 = (Seq)top.map((Function1 & Serializable & scala.Serializable)dir -> (Seq)mappings.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            File f = (File)tuple2._1();
            String p = (String)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f), (Object)new StringBuilder(1).append((String)dir).append("/").append(p).toString());
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> mappings);
        ZipHelper$.MODULE$.zip((Traversable<Tuple2<File, String>>)m2, zip);
        return zip;
    }

    public File makeNativeZip(File target, String name, Seq<Tuple2<File, String>> mappings, Option<String> top) {
        return this.makeNativeZip(target, name, mappings, top, (Seq<String>)((Seq)Nil$.MODULE$));
    }

    public File makeNativeZip(File target, String name, Seq<Tuple2<File, String>> mappings, Option<String> top, Seq<String> options) {
        File zip = RichFile$.MODULE$.$div$extension(sbt.package$.MODULE$.fileToRichFile(target), new StringBuilder(4).append(name).append(".zip").toString());
        Seq m2 = (Seq)top.map((Function1 & Serializable & scala.Serializable)dir -> (Seq)mappings.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            File f = (File)tuple2._1();
            String p = (String)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f), (Object)new StringBuilder(1).append((String)dir).append("/").append(p).toString());
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> mappings);
        ZipHelper$.MODULE$.zipNative((Traversable<Tuple2<File, String>>)m2, zip);
        return zip;
    }

    public File makeDmg(File target, String name, Seq<Tuple2<File, String>> mappings, Option<String> top) {
        return this.makeDmg(target, name, mappings, top, (Seq<String>)((Seq)Nil$.MODULE$));
    }

    public File makeDmg(File target, String name, Seq<Tuple2<File, String>> mappings, Option<String> top, Seq<String> options) {
        File t = RichFile$.MODULE$.$div$extension(sbt.package$.MODULE$.fileToRichFile(target), "dmg");
        File dmg = RichFile$.MODULE$.$div$extension(sbt.package$.MODULE$.fileToRichFile(target), new StringBuilder(4).append(name).append(".dmg").toString());
        if (!t.isDirectory()) {
            sbt.package$.MODULE$.IO().createDirectory(t);
        }
        long sizeBytes = BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)((TraversableLike)mappings.map((Function1 & Serializable & scala.Serializable)x$1 -> (File)x$1._1(), Seq$.MODULE$.canBuildFrom())).filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isDirectory()))).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.length()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        long neededMegabytes = (long)package$.MODULE$.ceil((double)sizeBytes * 1.05 / (double)0x100000);
        int n = Process$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hdiutil", "create", "-megabytes", new StringOps(Predef$.MODULE$.augmentString("%d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)neededMegabytes)})), "-fs", "HFS+", "-volname", name, name})), (Option)new Some((Object)target), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0])).$bang();
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw scala.sys.package$.MODULE$.error(new StringBuilder(32).append("Error creating dmg: ").append(dmg).append(". Exit code ").append(n).toString());
            }
        }
        File mountPoint = RichFile$.MODULE$.$div$extension(sbt.package$.MODULE$.fileToRichFile(t), name);
        if (!mountPoint.isDirectory()) {
            sbt.package$.MODULE$.IO().createDirectory(mountPoint);
        }
        String mountedPath = mountPoint.getAbsolutePath();
        int n2 = Process$.MODULE$.apply((Seq)new .colon.colon((Object)"hdiutil", (List)new .colon.colon((Object)"attach", (List)new .colon.colon((Object)dmg.getAbsolutePath(), (List)new .colon.colon((Object)"-readwrite", (List)new .colon.colon((Object)"-mountpoint", (List)new .colon.colon((Object)mountedPath, (List)Nil$.MODULE$)))))), (Option)new Some((Object)target), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0])).$bang();
        switch (n2) {
            case 0: {
                break;
            }
            default: {
                throw scala.sys.package$.MODULE$.error(new StringBuilder(33).append("Unable to mount dmg: ").append(dmg).append(". Exit code ").append(n2).toString());
            }
        }
        Seq m2 = (Seq)mappings.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            File f = (File)tuple2._1();
            String p = (String)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f), (Object)RichFile$.MODULE$.$div$extension(sbt.package$.MODULE$.fileToRichFile(mountPoint), p));
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom());
        sbt.package$.MODULE$.IO().copy((Traversable)m2);
        m2.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Archives$.$anonfun$makeDmg$5(check$ifrefutable$1))).withFilter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)Archives$.$anonfun$makeDmg$6(x$4))).foreach((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)Archives$.$anonfun$makeDmg$7(x$5)));
        int n3 = Process$.MODULE$.apply((Seq)new .colon.colon((Object)"hdiutil", (List)new .colon.colon((Object)"detach", (List)new .colon.colon((Object)mountedPath, (List)Nil$.MODULE$))), (Option)new Some((Object)target), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0])).$bang();
        switch (n3) {
            case 0: {
                break;
            }
            default: {
                throw scala.sys.package$.MODULE$.error(new StringBuilder(36).append("Unable to dismount dmg: ").append(dmg).append(". Exit code ").append(n3).toString());
            }
        }
        sbt.package$.MODULE$.IO().delete(mountPoint);
        return dmg;
    }

    public File gzip(File f) {
        File par = f.getParentFile();
        int n = Process$.MODULE$.apply((Seq)new .colon.colon((Object)"gzip", (List)new .colon.colon((Object)"-9", (List)new .colon.colon((Object)f.getAbsolutePath(), (List)Nil$.MODULE$))), (Option)new Some((Object)par), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0])).$bang();
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw scala.sys.package$.MODULE$.error(new StringBuilder(27).append("Error gziping ").append(f).append(". Exit code: ").append(n).toString());
            }
        }
        return sbt.package$.MODULE$.file(new StringBuilder(3).append(f.getAbsolutePath()).append(".gz").toString());
    }

    public File xz(File f) {
        File par = f.getParentFile();
        int n = Process$.MODULE$.apply((Seq)new .colon.colon((Object)"xz", (List)new .colon.colon((Object)"-S", (List)new .colon.colon((Object)".xz", (List)new .colon.colon((Object)f.getAbsolutePath(), (List)Nil$.MODULE$)))), (Option)new Some((Object)par), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0])).$bang();
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw scala.sys.package$.MODULE$.error(new StringBuilder(26).append("Error xz-ing ").append(f).append(". Exit code: ").append(n).toString());
            }
        }
        return sbt.package$.MODULE$.file(new StringBuilder(3).append(f.getAbsolutePath()).append(".xz").toString());
    }

    public Function5<File, String, Seq<Tuple2<File, String>>, Option<String>, Seq<String>, File> makeTxz() {
        return this.makeTxz;
    }

    public Function5<File, String, Seq<Tuple2<File, String>>, Option<String>, Seq<String>, File> makeTgz() {
        return this.makeTgz;
    }

    public File makeTarball(Function1<File, File> compressor, String ext, File target, String name, Seq<Tuple2<File, String>> mappings, Option<String> top) {
        return this.makeTarballWithOptions(compressor, ext, target, name, mappings, top, (Seq<String>)((Seq)new .colon.colon((Object)"--force-local", (List)new .colon.colon((Object)"-pcvf", (List)Nil$.MODULE$))));
    }

    public File makeTarballWithOptions(Function1<File, File> compressor, String ext, File target, String name, Seq<Tuple2<File, String>> mappings, Option<String> topDirectory, Seq<String> options) {
        File tarball = RichFile$.MODULE$.$div$extension(sbt.package$.MODULE$.fileToRichFile(target), new StringBuilder(0).append(name).append(ext).toString());
        sbt.package$.MODULE$.IO().withTemporaryDirectory((Function1 & Serializable & scala.Serializable)tempDirectory -> {
            Archives$.$anonfun$makeTarballWithOptions$1(name, topDirectory, mappings, tarball, options, compressor, tempDirectory);
            return BoxedUnit.UNIT;
        });
        return tarball;
    }

    public static final /* synthetic */ boolean $anonfun$makeDmg$5(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$makeDmg$6(Tuple2 x$4) {
        Tuple2 tuple2 = x$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File from = (File)tuple2._1();
        boolean bl = from.canExecute();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$makeDmg$7(Tuple2 x$5) {
        Tuple2 tuple2 = x$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File to = (File)tuple2._2();
        boolean bl = to.setExecutable(true, true);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$makeTarballWithOptions$6(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$makeTarballWithOptions$7(Tuple2 x$6) {
        Tuple2 tuple2 = x$6;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File from = (File)tuple2._1();
        File to = (File)tuple2._2();
        boolean bl = to.getAbsolutePath().contains("/bin/") || from.canExecute();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$makeTarballWithOptions$8(Tuple2 x$7) {
        Tuple2 tuple2 = x$7;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File to = (File)tuple2._2();
        Predef$.MODULE$.println((Object)new StringBuilder(18).append("Making ").append(to.getAbsolutePath()).append(" executable").toString());
        boolean bl = to.setExecutable(true, false);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$makeTarballWithOptions$1(String name$1, Option topDirectory$1, Seq mappings$3, File tarball$1, Seq options$1, Function1 compressor$1, File tempDirectory) {
        File workingDirectory = RichFile$.MODULE$.$div$extension(sbt.package$.MODULE$.fileToRichFile(tempDirectory), name$1);
        Seq temporaryMappings = (Seq)topDirectory$1.map((Function1 & Serializable & scala.Serializable)dir -> (Seq)mappings$3.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            File f = (File)tuple2._1();
            String p = (String)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f), (Object)RichFile$.MODULE$.$div$extension(sbt.package$.MODULE$.fileToRichFile(RichFile$.MODULE$.$div$extension(sbt.package$.MODULE$.fileToRichFile(workingDirectory), dir)), p));
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)mappings$3.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            File f = (File)tuple2._1();
            String p = (String)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f), (Object)RichFile$.MODULE$.$div$extension(sbt.package$.MODULE$.fileToRichFile(workingDirectory), p));
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom()));
        sbt.package$.MODULE$.IO().createDirectory(workingDirectory);
        sbt.package$.MODULE$.IO().copy((Traversable)temporaryMappings);
        temporaryMappings.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)Archives$.$anonfun$makeTarballWithOptions$6(check$ifrefutable$2))).withFilter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)Archives$.$anonfun$makeTarballWithOptions$7(x$6))).foreach((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)Archives$.$anonfun$makeTarballWithOptions$8(x$7)));
        sbt.package$.MODULE$.IO().createDirectory(tarball$1.getParentFile());
        List distdirs = (List)topDirectory$1.map((Function1 & Serializable & scala.Serializable)x$8 -> {
            String string = x$8;
            return Nil$.MODULE$.$colon$colon((Object)string);
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sbt.package$.MODULE$.IO().listFiles(workingDirectory))).map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.getName(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toList());
        File temporaryTarFile = RichFile$.MODULE$.$div$extension(sbt.package$.MODULE$.fileToRichFile(tempDirectory), new StringBuilder(4).append(name$1).append(".tar").toString());
        Seq cmd = (Seq)((TraversableLike)((TraversableLike)((TraversableLike)new .colon.colon((Object)"tar", (List)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)options$1, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new .colon.colon((Object)temporaryTarFile.getAbsolutePath(), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)distdirs, Seq$.MODULE$.canBuildFrom());
        Predef$.MODULE$.println((Object)new StringBuilder(13).append("Running with ").append(cmd.mkString(" ")).toString());
        int n = Process$.MODULE$.apply(cmd, workingDirectory, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0])).$bang();
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw scala.sys.package$.MODULE$.error(new StringBuilder(30).append("Error tarballing ").append(tarball$1).append(". Exit code: ").append(n).toString());
            }
        }
        sbt.package$.MODULE$.IO().copyFile((File)compressor$1.apply((Object)temporaryTarFile), tarball$1);
    }

    private Archives$() {
        MODULE$ = this;
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)f -> MODULE$.xz((File)f);
        this.makeTxz = (Function5 & Serializable & scala.Serializable)(target, name, mappings, topDirectory, options) -> MODULE$.makeTarballWithOptions((Function1<File, File>)intersect, ".txz", (File)target, (String)name, (Seq<Tuple2<File, String>>)mappings, (Option<String>)topDirectory, (Seq<String>)options);
        Function1 & Serializable & scala.Serializable intersect2 = (Function1 & Serializable & scala.Serializable)f -> MODULE$.gzip((File)f);
        this.makeTgz = (Function5 & Serializable & scala.Serializable)(target, name, mappings, topDirectory, options) -> MODULE$.makeTarballWithOptions((Function1<File, File>)intersect2, ".tgz", (File)target, (String)name, (Seq<Tuple2<File, String>>)mappings, (Option<String>)topDirectory, (Seq<String>)options);
    }
}

