/*
 * Decompiled with CFR 0.152.
 */
package journal.io.api;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import journal.io.api.Journal;
import journal.io.util.IOHelper;

class DataFile
implements Comparable<DataFile> {
    private final File file;
    private final Integer dataFileId;
    private volatile Integer dataFileGeneration;
    private final AtomicLong length;
    private volatile DataFile next;

    DataFile(File file, int id) {
        this.file = file;
        this.dataFileId = id;
        this.dataFileGeneration = 0;
        this.length = new AtomicLong(file.exists() ? file.length() : 0L);
    }

    File getFile() {
        return this.file;
    }

    Integer getDataFileId() {
        return this.dataFileId;
    }

    Integer getDataFileGeneration() {
        return this.dataFileGeneration;
    }

    void incrementGeneration() {
        DataFile dataFile = this;
        Integer n = dataFile.dataFileGeneration;
        Integer n2 = dataFile.dataFileGeneration = Integer.valueOf(dataFile.dataFileGeneration + 1);
    }

    DataFile getNext() {
        return this.next;
    }

    void setNext(DataFile next) {
        this.next = next;
    }

    long getLength() {
        return this.length.get();
    }

    void setLength(long length) {
        this.length.set(length);
    }

    void incrementLength(int size) {
        this.length.addAndGet(size);
    }

    RandomAccessFile openRandomAccessFile() throws IOException {
        return new RandomAccessFile(this.file, "rw");
    }

    boolean delete() throws IOException {
        return this.file.delete();
    }

    void move(File targetDirectory) throws IOException {
        IOHelper.moveFile(this.file, targetDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeHeader() throws IOException {
        RandomAccessFile raf = this.openRandomAccessFile();
        try {
            raf.write(Journal.MAGIC_STRING);
            raf.writeInt(130);
            this.length.set(Journal.FILE_HEADER_SIZE);
        }
        finally {
            raf.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void verifyHeader() throws IOException {
        block5: {
            RandomAccessFile raf = this.openRandomAccessFile();
            try {
                byte[] magic = new byte[Journal.MAGIC_SIZE];
                if (raf.read(magic) == Journal.MAGIC_SIZE && Arrays.equals(magic, Journal.MAGIC_STRING)) {
                    int version = raf.readInt();
                    if (version != 130) {
                        throw new IllegalStateException("Incompatible storage version, found: " + version + ", required: " + 130);
                    }
                    break block5;
                }
                throw new IOException("Incompatible magic string!");
            }
            finally {
                raf.close();
            }
        }
    }

    @Override
    public int compareTo(DataFile df) {
        return this.dataFileId - df.dataFileId;
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof DataFile) {
            result = this.compareTo((DataFile)o) == 0;
        }
        return result;
    }

    public int hashCode() {
        return this.dataFileId;
    }

    public String toString() {
        return this.file.getName() + ", number = " + this.dataFileId + ", generation = " + this.dataFileGeneration + ", length = " + this.length;
    }
}

