/*
 * Decompiled with CFR 0.152.
 */
package journal.io.api;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import journal.io.api.ClosedJournalException;
import journal.io.api.CompactedDataFileException;
import journal.io.api.DataFile;
import journal.io.api.Journal;
import journal.io.api.Location;
import journal.io.util.IOHelper;
import journal.io.util.LogHelper;

class DataFileAccessor {
    private final ConcurrentMap<Thread, ConcurrentMap<Integer, RandomAccessFile>> perThreadDataFileRafs = new ConcurrentHashMap<Thread, ConcurrentMap<Integer, RandomAccessFile>>();
    private final ConcurrentMap<Thread, ConcurrentMap<Integer, Lock>> perThreadDataFileLocks = new ConcurrentHashMap<Thread, ConcurrentMap<Integer, Lock>>();
    private final ReadWriteLock accessorLock = new ReentrantReadWriteLock();
    private final Lock shared = this.accessorLock.readLock();
    private final Lock exclusive = this.accessorLock.writeLock();
    private volatile boolean opened;
    private final Journal journal;
    private volatile ScheduledExecutorService disposer;

    public DataFileAccessor(Journal journal) {
        this.journal = journal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateLocation(Location location, byte type, boolean sync) throws ClosedJournalException, CompactedDataFileException, IOException {
        block7: {
            Lock threadLock = this.getOrCreateLock(Thread.currentThread(), location.getDataFileId());
            this.shared.lock();
            threadLock.lock();
            try {
                if (this.opened) {
                    RandomAccessFile raf;
                    if (this.journal.getInflightWrites().containsKey(location)) {
                        this.journal.sync();
                    }
                    if (this.seekToLocation(raf = this.getOrCreateRaf(Thread.currentThread(), location.getDataFileId()), location, false, false)) {
                        int pointer = raf.readInt();
                        int size = raf.readInt();
                        location.setType(type);
                        raf.write(type);
                        if (sync) {
                            IOHelper.sync(raf.getFD());
                        }
                        IOHelper.skipBytes(raf, size - 9);
                        break block7;
                    }
                    throw new IOException("Cannot find location: " + location);
                }
                throw new ClosedJournalException("The journal is closed!");
            }
            finally {
                threadLock.unlock();
                this.shared.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteFromLocation(Location source) throws ClosedJournalException, CompactedDataFileException, IOException {
        block6: {
            Lock threadLock = this.getOrCreateLock(Thread.currentThread(), source.getDataFileId());
            this.shared.lock();
            threadLock.lock();
            try {
                if (this.opened) {
                    if (this.journal.getInflightWrites().containsKey(source)) {
                        this.journal.sync();
                    }
                    RandomAccessFile raf = this.getOrCreateRaf(Thread.currentThread(), source.getDataFileId());
                    long position = source.getThisFilePosition();
                    if (position != -1L) {
                        DataFile dataFile = this.journal.getDataFile(source.getDataFileId());
                        raf.setLength(position);
                        IOHelper.sync(raf.getFD());
                        dataFile.setLength(position);
                        break block6;
                    }
                    throw new IOException("Cannot find location: " + source);
                }
                throw new ClosedJournalException("The journal is closed!");
            }
            finally {
                threadLock.unlock();
                this.shared.unlock();
            }
        }
    }

    byte[] readLocation(Location location, boolean sync) throws IOException {
        if (location.getData() != null && !sync) {
            return location.getData();
        }
        Location read = this.readLocationDetails(location.getDataFileId(), location.getPointer());
        if (read != null && !read.isDeletedRecord()) {
            return read.getData();
        }
        throw new IOException("Invalid location: " + location + ", found: " + read);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Location readLocationDetails(int file, int pointer) throws ClosedJournalException, IOException {
        Journal.WriteCommand asyncWrite = (Journal.WriteCommand)this.journal.getInflightWrites().get(new Location(file, pointer));
        if (asyncWrite != null) {
            Location location = new Location(file, pointer);
            location.setPointer(asyncWrite.getLocation().getPointer());
            location.setSize(asyncWrite.getLocation().getSize());
            location.setType(asyncWrite.getLocation().getType());
            location.setData(asyncWrite.getData());
            return location;
        }
        Location location = new Location(file, pointer);
        Lock threadLock = this.getOrCreateLock(Thread.currentThread(), location.getDataFileId());
        this.shared.lock();
        threadLock.lock();
        try {
            if (this.opened) {
                RandomAccessFile raf = this.getOrCreateRaf(Thread.currentThread(), location.getDataFileId());
                if (this.seekToLocation(raf, location, true, true)) {
                    if (location.getSize() > 0) {
                        location.setDataFileGeneration(this.journal.getDataFile(file).getDataFileGeneration());
                        location.setNextFilePosition(raf.getFilePointer());
                        Location location2 = location;
                        return location2;
                    }
                    Location location3 = null;
                    return location3;
                }
                Location location4 = null;
                return location4;
            }
            try {
                throw new ClosedJournalException("The journal is closed!");
            }
            catch (CompactedDataFileException ex) {
                LogHelper.warn(ex.getMessage(), new Object[0]);
                Location location5 = null;
                return location5;
            }
        }
        finally {
            threadLock.unlock();
            this.shared.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Location readNextLocationDetails(Location start, int type) throws ClosedJournalException, IOException {
        Location asyncLocation = new Location(start.getDataFileId(), start.getPointer() + 1);
        Journal.WriteCommand asyncWrite = (Journal.WriteCommand)this.journal.getInflightWrites().get(asyncLocation);
        if (asyncWrite != null && asyncWrite.getLocation().isBatchControlRecord() && type != 2) {
            asyncLocation = new Location(start.getDataFileId(), start.getPointer() + 2);
            asyncWrite = (Journal.WriteCommand)this.journal.getInflightWrites().get(asyncLocation);
        }
        if (asyncWrite != null) {
            asyncLocation.setPointer(asyncWrite.getLocation().getPointer());
            asyncLocation.setSize(asyncWrite.getLocation().getSize());
            asyncLocation.setType(asyncWrite.getLocation().getType());
            asyncLocation.setData(asyncWrite.getData());
            return asyncLocation;
        }
        if (!this.journal.getInflightWrites().containsKey(start)) {
            Lock threadLock = this.getOrCreateLock(Thread.currentThread(), start.getDataFileId());
            this.shared.lock();
            threadLock.lock();
            try {
                if (this.opened) {
                    RandomAccessFile raf = this.getOrCreateRaf(Thread.currentThread(), start.getDataFileId());
                    if (this.isIntoNextLocation(raf, start) || this.seekToLocation(raf, start, true, false)) {
                        if (this.hasRecordHeader(raf, raf.getFilePointer())) {
                            Location location;
                            Location next = new Location(start.getDataFileId());
                            do {
                                next.setThisFilePosition(raf.getFilePointer());
                                ByteBuffer headerBuffer = ByteBuffer.allocate(9);
                                raf.getChannel().read(headerBuffer);
                                headerBuffer.flip();
                                next.setPointer(headerBuffer.getInt());
                                next.setSize(headerBuffer.getInt());
                                next.setType(headerBuffer.get());
                                if (type == 0 || next.getType() == type) break;
                                boolean skipped = this.skipLocationData(raf, next);
                                assert (skipped);
                            } while (this.hasRecordHeader(raf, raf.getFilePointer()));
                            if (type == 0 || next.getType() == type) {
                                next.setData(this.readLocationData(next, raf));
                                next.setDataFileGeneration(this.journal.getDataFile(start.getDataFileId()).getDataFileGeneration());
                                next.setNextFilePosition(raf.getFilePointer());
                                location = next;
                                return location;
                            }
                            raf.seek(0L);
                            location = null;
                            return location;
                        }
                        Location location = null;
                        return location;
                    }
                    Location location = null;
                    return location;
                }
                try {
                    throw new ClosedJournalException("The journal is closed!");
                }
                catch (CompactedDataFileException ex) {
                    LogHelper.warn(ex.getMessage(), new Object[0]);
                    Location location = null;
                    return location;
                }
            }
            finally {
                threadLock.unlock();
                this.shared.unlock();
            }
        }
        return null;
    }

    void dispose(DataFile dataFile) {
        Integer dataFileId = dataFile.getDataFileId();
        block0: for (Map.Entry threadRafs : this.perThreadDataFileRafs.entrySet()) {
            for (Map.Entry raf : ((ConcurrentMap)threadRafs.getValue()).entrySet()) {
                if (!((Integer)raf.getKey()).equals(dataFileId)) continue;
                this.disposeByThread((Thread)threadRafs.getKey(), dataFileId);
                continue block0;
            }
        }
    }

    void open() {
        this.disposer = this.journal.getDisposer();
        this.disposer.scheduleAtFixedRate(new ResourceDisposer(), this.journal.getDisposeInterval(), this.journal.getDisposeInterval(), TimeUnit.MILLISECONDS);
        this.opened = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        this.exclusive.lock();
        try {
            this.opened = false;
            for (Map.Entry threadRafs : this.perThreadDataFileRafs.entrySet()) {
                for (Map.Entry raf : ((ConcurrentMap)threadRafs.getValue()).entrySet()) {
                    this.disposeByThread((Thread)threadRafs.getKey(), (Integer)raf.getKey());
                }
            }
        }
        finally {
            this.exclusive.unlock();
        }
    }

    void pause() throws ClosedJournalException {
        if (!this.opened) {
            throw new ClosedJournalException("The journal is closed!");
        }
        this.exclusive.lock();
    }

    void resume() throws ClosedJournalException {
        if (!this.opened) {
            throw new ClosedJournalException("The journal is closed!");
        }
        this.exclusive.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeByThread(Thread t, Integer dataFileId) {
        Lock lock = this.getOrCreateLock(t, dataFileId);
        lock.lock();
        try {
            this.removeRaf(t, dataFileId);
        }
        catch (IOException ex) {
            LogHelper.warn(ex, ex.getMessage());
        }
        finally {
            lock.unlock();
        }
    }

    private boolean isIntoNextLocation(RandomAccessFile raf, Location source) throws CompactedDataFileException, IOException {
        int generation = this.journal.getDataFile(source.getDataFileId()).getDataFileGeneration();
        long position = raf.getFilePointer();
        return source.getDataFileGeneration() == generation && source.getNextFilePosition() == position;
    }

    private boolean seekToLocation(RandomAccessFile raf, Location destination, boolean fillLocation, boolean fillData) throws IOException {
        ByteBuffer headerBuffer = ByteBuffer.allocate(9);
        long position = raf.getFilePointer();
        int pointer = -1;
        int size = -1;
        byte type = -1;
        if (this.hasRecordHeader(raf, position)) {
            raf.getChannel().read(headerBuffer);
            headerBuffer.flip();
            pointer = headerBuffer.getInt();
            size = headerBuffer.getInt();
            type = headerBuffer.get();
        }
        if (pointer != destination.getPointer()) {
            position = destination.getThisFilePosition();
            if (position != -1L && this.hasRecordHeader(raf, position)) {
                raf.seek(position);
                headerBuffer.rewind();
                raf.getChannel().read(headerBuffer);
                headerBuffer.flip();
                pointer = headerBuffer.getInt();
                size = headerBuffer.getInt();
                type = headerBuffer.get();
            }
            if (pointer != destination.getPointer()) {
                Map.Entry hint = this.journal.getHints().lowerEntry(destination);
                position = hint != null && hint.getKey().getDataFileId() == destination.getDataFileId() ? (Long)hint.getValue() : (long)Journal.FILE_HEADER_SIZE;
                raf.seek(position);
                if (this.hasRecordHeader(raf, position)) {
                    headerBuffer.rewind();
                    raf.getChannel().read(headerBuffer);
                    headerBuffer.flip();
                    pointer = headerBuffer.getInt();
                    size = headerBuffer.getInt();
                    type = headerBuffer.get();
                    while (pointer != destination.getPointer()) {
                        IOHelper.skipBytes(raf, size - 9);
                        position = raf.getFilePointer();
                        if (this.hasRecordHeader(raf, position)) {
                            headerBuffer.rewind();
                            raf.getChannel().read(headerBuffer);
                            headerBuffer.flip();
                            pointer = headerBuffer.getInt();
                            size = headerBuffer.getInt();
                            type = headerBuffer.get();
                            continue;
                        }
                        return false;
                    }
                } else {
                    return false;
                }
            }
        }
        if (fillLocation || fillData) {
            destination.setThisFilePosition(position);
            destination.setSize(size);
            destination.setType(type);
            if (fillData) {
                destination.setData(this.readLocationData(destination, raf));
            } else {
                boolean skipped = this.skipLocationData(raf, destination);
                assert (skipped);
            }
        } else {
            raf.seek(position);
        }
        return true;
    }

    private boolean skipLocationData(RandomAccessFile raf, Location source) throws IOException {
        int toSkip = source.getSize() - 9;
        if (raf.length() - raf.getFilePointer() >= (long)toSkip) {
            IOHelper.skipBytes(raf, toSkip);
            return true;
        }
        return false;
    }

    private byte[] readLocationData(Location location, RandomAccessFile raf) throws IOException {
        if (location.isBatchControlRecord()) {
            byte[] checksum = new byte[8];
            raf.read(checksum);
            return checksum;
        }
        byte[] data = new byte[location.getSize() - 9];
        raf.readFully(data);
        return data;
    }

    private RandomAccessFile getOrCreateRaf(Thread thread, Integer file) throws CompactedDataFileException, IOException {
        RandomAccessFile raf;
        ConcurrentHashMap<Integer, RandomAccessFile> rafs = (ConcurrentHashMap<Integer, RandomAccessFile>)this.perThreadDataFileRafs.get(thread);
        if (rafs == null) {
            rafs = new ConcurrentHashMap<Integer, RandomAccessFile>();
            this.perThreadDataFileRafs.put(thread, rafs);
        }
        if ((raf = (RandomAccessFile)rafs.get(file)) == null) {
            raf = this.journal.getDataFile(file).openRandomAccessFile();
            IOHelper.skipBytes(raf, Journal.FILE_HEADER_SIZE);
            rafs.put(file, raf);
        }
        return raf;
    }

    private void removeRaf(Thread thread, Integer file) throws IOException {
        RandomAccessFile raf = (RandomAccessFile)((ConcurrentMap)this.perThreadDataFileRafs.get(thread)).remove(file);
        raf.close();
    }

    private Lock getOrCreateLock(Thread thread, Integer file) {
        Lock lock;
        ConcurrentHashMap<Integer, Lock> locks = (ConcurrentHashMap<Integer, Lock>)this.perThreadDataFileLocks.get(thread);
        if (locks == null) {
            locks = new ConcurrentHashMap<Integer, Lock>();
            this.perThreadDataFileLocks.put(thread, locks);
        }
        if ((lock = (Lock)locks.get(file)) == null) {
            lock = new ReentrantLock();
            locks.put(file, lock);
        }
        return lock;
    }

    private boolean hasRecordHeader(RandomAccessFile raf, long position) throws IOException {
        long remaining = raf.length() - position;
        if (remaining >= 9L) {
            return true;
        }
        if (remaining == 0L) {
            return false;
        }
        throw new IllegalStateException("Remaining file length doesn't fit a record header at position: " + position);
    }

    private class ResourceDisposer
    implements Runnable {
        private ResourceDisposer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HashSet deadThreads = new HashSet();
            for (Map.Entry threadRafs : DataFileAccessor.this.perThreadDataFileRafs.entrySet()) {
                for (Map.Entry raf : ((ConcurrentMap)threadRafs.getValue()).entrySet()) {
                    Lock lock = DataFileAccessor.this.getOrCreateLock((Thread)threadRafs.getKey(), (Integer)raf.getKey());
                    if (!lock.tryLock()) continue;
                    try {
                        DataFileAccessor.this.removeRaf((Thread)threadRafs.getKey(), (Integer)raf.getKey());
                        if (((Thread)threadRafs.getKey()).isAlive()) continue;
                        deadThreads.add(threadRafs.getKey());
                    }
                    catch (IOException ex) {
                        LogHelper.warn(ex, ex.getMessage());
                    }
                    finally {
                        lock.unlock();
                    }
                }
            }
            for (Thread deadThread : deadThreads) {
                DataFileAccessor.this.perThreadDataFileRafs.remove(deadThread);
                DataFileAccessor.this.perThreadDataFileLocks.remove(deadThread);
            }
        }
    }
}

