/*
 * Decompiled with CFR 0.152.
 */
package journal.io.api;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.RandomAccessFile;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import journal.io.api.ClosedJournalException;
import journal.io.api.DataFile;
import journal.io.api.Journal;
import journal.io.api.Location;
import journal.io.api.WriteCallback;
import journal.io.util.LogHelper;

class DataFileAppender {
    private final int SPIN_RETRIES = 100;
    private final int SPIN_BACKOFF = 10;
    private final Queue<Journal.WriteBatch> batchQueue = new ConcurrentLinkedQueue<Journal.WriteBatch>();
    private final AtomicReference<Exception> asyncException = new AtomicReference();
    private final AtomicBoolean batching = new AtomicBoolean(false);
    private final AtomicBoolean writing = new AtomicBoolean(false);
    private volatile boolean opened;
    private final Journal journal;
    private volatile Journal.WriteBatch nextWriteBatch;
    private volatile DataFile lastAppendDataFile;
    private volatile RandomAccessFile lastAppendRaf;
    private volatile Executor writer;

    DataFileAppender(Journal journal) {
        this.journal = journal;
    }

    Location storeItem(byte[] data, byte type, boolean sync, WriteCallback callback) throws IOException {
        int size = 9 + data.length;
        Location location = new Location();
        location.setSize(size);
        location.setType(type);
        location.setWriteCallback(callback);
        Journal.WriteCommand write = new Journal.WriteCommand(location, data, sync);
        location = this.enqueueBatch(write);
        if (sync) {
            try {
                location.getLatch().await();
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
        }
        return location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Future<Boolean> sync() throws ClosedJournalException, IOException {
        int spinnings = 0;
        int limit = 100;
        while (true) {
            if (this.asyncException.get() != null) {
                throw new IOException(this.asyncException.get());
            }
            try {
                if (!this.opened) {
                    throw new ClosedJournalException("The journal is closed!");
                }
                if (this.batching.compareAndSet(false, true)) {
                    try {
                        Journal.WriteFuture result = null;
                        if (this.nextWriteBatch != null) {
                            result = new Journal.WriteFuture(this.nextWriteBatch.getLatch());
                            this.batchQueue.offer(this.nextWriteBatch);
                            this.signalBatch();
                            this.nextWriteBatch = null;
                        } else {
                            result = new Journal.WriteFuture(this.journal.getLastAppendLocation().getLatch());
                        }
                        Journal.WriteFuture writeFuture = result;
                        return writeFuture;
                    }
                    finally {
                        this.batching.set(false);
                    }
                }
                if (spinnings <= limit) {
                    ++spinnings;
                    continue;
                }
                Thread.sleep(10L);
            }
            catch (InterruptedException ex) {
                throw new IllegalStateException(ex.getMessage(), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Location enqueueBatch(Journal.WriteCommand writeRecord) throws ClosedJournalException, IOException {
        Journal.WriteBatch currentBatch = null;
        int spinnings = 0;
        int limit = 100;
        while (true) {
            if (this.asyncException.get() != null) {
                throw new IOException(this.asyncException.get());
            }
            try {
                if (!this.opened) {
                    throw new ClosedJournalException("The journal is closed!");
                }
                if (this.batching.compareAndSet(false, true)) {
                    boolean hasNewBatch = false;
                    try {
                        if (this.nextWriteBatch == null) {
                            DataFile file = this.journal.getCurrentWriteDataFile();
                            boolean canBatch = false;
                            currentBatch = new Journal.WriteBatch(file, this.journal.getLastAppendLocation().getPointer() + 1);
                            canBatch = currentBatch.canBatch(writeRecord, this.journal.getMaxWriteBatchSize(), this.journal.getMaxFileLength());
                            if (!canBatch) {
                                file = this.journal.newDataFile();
                                currentBatch = new Journal.WriteBatch(file, 0);
                            }
                            Journal.WriteCommand controlRecord = currentBatch.prepareBatch();
                            writeRecord.getLocation().setDataFileId(file.getDataFileId());
                            writeRecord.getLocation().setPointer(currentBatch.incrementAndGetPointer());
                            writeRecord.getLocation().setLatch(currentBatch.getLatch());
                            currentBatch.appendBatch(writeRecord);
                            if (!writeRecord.isSync()) {
                                this.journal.getInflightWrites().put(controlRecord.getLocation(), controlRecord);
                                this.journal.getInflightWrites().put(writeRecord.getLocation(), writeRecord);
                                this.nextWriteBatch = currentBatch;
                            } else {
                                this.batchQueue.offer(currentBatch);
                                hasNewBatch = true;
                            }
                            this.journal.setLastAppendLocation(writeRecord.getLocation());
                            break;
                        }
                        boolean canBatch = this.nextWriteBatch.canBatch(writeRecord, this.journal.getMaxWriteBatchSize(), this.journal.getMaxFileLength());
                        writeRecord.getLocation().setDataFileId(this.nextWriteBatch.getDataFile().getDataFileId());
                        writeRecord.getLocation().setPointer(this.nextWriteBatch.incrementAndGetPointer());
                        writeRecord.getLocation().setLatch(this.nextWriteBatch.getLatch());
                        if (canBatch && !writeRecord.isSync()) {
                            this.nextWriteBatch.appendBatch(writeRecord);
                            this.journal.getInflightWrites().put(writeRecord.getLocation(), writeRecord);
                            this.journal.setLastAppendLocation(writeRecord.getLocation());
                            break;
                        }
                        if (canBatch && writeRecord.isSync()) {
                            this.nextWriteBatch.appendBatch(writeRecord);
                            this.journal.setLastAppendLocation(writeRecord.getLocation());
                            this.batchQueue.offer(this.nextWriteBatch);
                            this.nextWriteBatch = null;
                            hasNewBatch = true;
                            break;
                        }
                        this.batchQueue.offer(this.nextWriteBatch);
                        this.nextWriteBatch = null;
                        hasNewBatch = true;
                        continue;
                    }
                    finally {
                        this.batching.set(false);
                        if (hasNewBatch) {
                            this.signalBatch();
                        }
                        continue;
                    }
                }
                if (spinnings <= limit) {
                    ++spinnings;
                    continue;
                }
                Thread.sleep(10L);
            }
            catch (InterruptedException ex) {
                throw new IllegalStateException(ex.getMessage(), ex);
            }
        }
        return writeRecord.getLocation();
    }

    void open() {
        this.writer = this.journal.getWriter();
        this.opened = true;
    }

    void close() throws IOException {
        try {
            this.opened = false;
            while (this.batching.get()) {
                Thread.sleep(10L);
            }
            if (this.nextWriteBatch != null) {
                this.batchQueue.offer(this.nextWriteBatch);
                this.signalBatch();
                this.nextWriteBatch.getLatch().await();
                this.nextWriteBatch = null;
            }
            this.journal.setLastAppendLocation(null);
            if (this.lastAppendRaf != null) {
                this.lastAppendRaf.close();
            }
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
    }

    public Exception getAsyncException() {
        return this.asyncException.get();
    }

    private void signalBatch() {
        this.writer.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!DataFileAppender.this.writing.compareAndSet(false, true)) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (Exception ex) {}
                }
                Journal.WriteBatch wb = (Journal.WriteBatch)DataFileAppender.this.batchQueue.poll();
                try {
                    while (wb != null) {
                        if (!wb.isEmpty()) {
                            boolean newOrRotated;
                            boolean bl = newOrRotated = DataFileAppender.this.lastAppendDataFile != wb.getDataFile();
                            if (newOrRotated) {
                                if (DataFileAppender.this.lastAppendRaf != null) {
                                    DataFileAppender.this.lastAppendRaf.close();
                                }
                                DataFileAppender.this.lastAppendDataFile = wb.getDataFile();
                                DataFileAppender.this.lastAppendRaf = DataFileAppender.this.lastAppendDataFile.openRandomAccessFile();
                            }
                            Location batchLocation = wb.perform(DataFileAppender.this.lastAppendRaf, DataFileAppender.this.journal.isChecksum(), DataFileAppender.this.journal.isPhysicalSync(), DataFileAppender.this.journal.getReplicationTarget());
                            DataFileAppender.this.journal.getHints().put(batchLocation, batchLocation.getThisFilePosition());
                            DataFileAppender.this.journal.addToTotalLength(wb.getSize());
                            for (Journal.WriteCommand current : wb.getWrites()) {
                                try {
                                    current.getLocation().getWriteCallback().onSync(current.getLocation());
                                }
                                catch (Throwable ex) {
                                    LogHelper.warn(ex, ex.getMessage());
                                }
                                DataFileAppender.this.journal.getInflightWrites().remove(current.getLocation());
                            }
                            wb.getLatch().countDown();
                        }
                        wb = (Journal.WriteBatch)DataFileAppender.this.batchQueue.poll();
                    }
                }
                catch (Exception ex) {
                    DataFileAppender.this.batchQueue.offer(wb);
                    for (Journal.WriteBatch currentBatch : DataFileAppender.this.batchQueue) {
                        for (Journal.WriteCommand currentWrite : currentBatch.getWrites()) {
                            try {
                                currentWrite.getLocation().getWriteCallback().onError(currentWrite.getLocation(), ex);
                            }
                            catch (Throwable innerEx) {
                                LogHelper.warn(innerEx, innerEx.getMessage());
                            }
                        }
                        currentBatch.getLatch().countDown();
                    }
                    DataFileAppender.this.asyncException.compareAndSet(null, ex);
                }
                finally {
                    DataFileAppender.this.writing.set(false);
                }
            }
        });
    }
}

