/*
 * Decompiled with CFR 0.152.
 */
package journal.io.api;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.Adler32;
import journal.io.api.ClosedJournalException;
import journal.io.api.CompactedDataFileException;
import journal.io.api.DataFile;
import journal.io.api.DataFileAccessor;
import journal.io.api.DataFileAppender;
import journal.io.api.Location;
import journal.io.api.OpenJournalException;
import journal.io.api.RecoveryErrorHandler;
import journal.io.api.ReplicationTarget;
import journal.io.api.WriteCallback;
import journal.io.util.IOHelper;
import journal.io.util.LogHelper;

public class Journal {
    static final byte[] MAGIC_STRING = "J.IO".getBytes(Charset.forName("UTF-8"));
    static final int MAGIC_SIZE = MAGIC_STRING.length;
    static final int STORAGE_VERSION = 130;
    static final int STORAGE_VERSION_SIZE = 4;
    static final int FILE_HEADER_SIZE = MAGIC_SIZE + 4;
    static final int RECORD_POINTER_SIZE = 4;
    static final int RECORD_LENGTH_SIZE = 4;
    static final int RECORD_TYPE_SIZE = 1;
    static final int RECORD_HEADER_SIZE = 9;
    static final int CHECKSUM_SIZE = 8;
    static final int BATCH_CONTROL_RECORD_SIZE = 17;
    static final String WRITER_THREAD_GROUP = "Journal.IO - Writer Thread Group";
    static final String WRITER_THREAD = "Journal.IO - Writer Thread";
    static final String DISPOSER_THREAD_GROUP = "Journal.IO - Disposer Thread Group";
    static final String DISPOSER_THREAD = "Journal.IO - Disposer Thread";
    static final int PRE_START_POINTER = -1;
    static final String DEFAULT_DIRECTORY = ".";
    static final String DEFAULT_ARCHIVE_DIRECTORY = "data-archive";
    static final String DEFAULT_FILE_PREFIX = "db-";
    static final String DEFAULT_FILE_SUFFIX = ".log";
    static final int DEFAULT_MAX_FILE_LENGTH = 0x2000000;
    static final int DEFAULT_DISPOSE_INTERVAL = 600000;
    static final int MIN_FILE_LENGTH = 1024;
    static final int DEFAULT_MAX_BATCH_SIZE = 0x2000000;
    private final ConcurrentNavigableMap<Integer, DataFile> dataFiles = new ConcurrentSkipListMap<Integer, DataFile>();
    private final ConcurrentNavigableMap<Location, Long> hints = new ConcurrentSkipListMap<Location, Long>();
    private final ConcurrentMap<Location, WriteCommand> inflightWrites = new ConcurrentHashMap<Location, WriteCommand>();
    private final AtomicLong totalLength = new AtomicLong();
    private volatile Location lastAppendLocation;
    private volatile File directory = new File(".");
    private volatile File directoryArchive = new File("data-archive");
    private volatile String filePrefix = "db-";
    private volatile String fileSuffix = ".log";
    private volatile int maxWriteBatchSize = 0x2000000;
    private volatile int maxFileLength = 0x2000000;
    private volatile long disposeInterval = 600000L;
    private volatile boolean physicalSync = false;
    private volatile boolean checksum = true;
    private volatile boolean managedWriter;
    private volatile boolean managedDisposer;
    private volatile Executor writer;
    private volatile ScheduledExecutorService disposer;
    private volatile DataFileAppender appender;
    private volatile DataFileAccessor accessor;
    private volatile boolean opened;
    private volatile boolean archiveFiles;
    private RecoveryErrorHandler recoveryErrorHandler;
    private ReplicationTarget replicationTarget;

    public synchronized void open() throws IOException {
        if (this.opened) {
            return;
        }
        if (this.maxFileLength < 1024) {
            throw new IllegalStateException("Max file length must be equal or greater than: 1024");
        }
        if (this.maxWriteBatchSize > this.maxFileLength) {
            throw new IllegalStateException("Max batch size must be equal or less than: " + this.maxFileLength);
        }
        if (this.writer == null) {
            this.managedWriter = true;
            this.writer = Executors.newSingleThreadExecutor(new JournalThreadFactory(WRITER_THREAD_GROUP, WRITER_THREAD));
        }
        if (this.disposer == null) {
            this.managedDisposer = true;
            this.disposer = Executors.newSingleThreadScheduledExecutor(new JournalThreadFactory(DISPOSER_THREAD_GROUP, DISPOSER_THREAD));
        }
        if (this.recoveryErrorHandler == null) {
            this.recoveryErrorHandler = RecoveryErrorHandler.ABORT;
        }
        this.opened = true;
        this.accessor = new DataFileAccessor(this);
        this.accessor.open();
        this.appender = new DataFileAppender(this);
        this.appender.open();
        this.dataFiles.clear();
        File[] files = this.directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String n) {
                return dir.equals(Journal.this.directory) && n.startsWith(Journal.this.filePrefix) && n.endsWith(Journal.this.fileSuffix);
            }
        });
        if (files == null) {
            throw new IOException("Failed to access content of " + this.directory);
        }
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                String name1 = f1.getName();
                int index1 = Integer.parseInt(name1.substring(Journal.this.filePrefix.length(), name1.length() - Journal.this.fileSuffix.length()));
                String name2 = f2.getName();
                int index2 = Integer.parseInt(name2.substring(Journal.this.filePrefix.length(), name2.length() - Journal.this.fileSuffix.length()));
                return index1 - index2;
            }
        });
        if (files.length > 0) {
            for (int i = 0; i < files.length; ++i) {
                try {
                    File file = files[i];
                    String name = file.getName();
                    int index = Integer.parseInt(name.substring(this.filePrefix.length(), name.length() - this.fileSuffix.length()));
                    DataFile dataFile = new DataFile(file, index);
                    if (!this.dataFiles.isEmpty()) {
                        ((DataFile)this.dataFiles.lastEntry().getValue()).setNext(dataFile);
                    }
                    this.dataFiles.put(dataFile.getDataFileId(), dataFile);
                    this.totalLength.addAndGet(dataFile.getLength());
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.lastAppendLocation = this.recoveryCheck();
        }
        if (this.lastAppendLocation == null) {
            this.lastAppendLocation = new Location(1, -1);
        }
    }

    public synchronized void close() throws IOException {
        if (!this.opened) {
            return;
        }
        this.opened = false;
        this.accessor.close();
        this.appender.close();
        this.hints.clear();
        this.inflightWrites.clear();
        if (this.managedWriter) {
            ((ExecutorService)this.writer).shutdown();
            this.writer = null;
        }
        if (this.managedDisposer) {
            this.disposer.shutdown();
            this.disposer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void compact() throws ClosedJournalException, IOException {
        if (this.opened) {
            this.accessor.pause();
            try {
                for (DataFile file : this.dataFiles.values()) {
                    if (file.getDataFileId() >= this.lastAppendLocation.getDataFileId()) continue;
                    Location firstUserLocation = this.goToFirstLocation(file, (byte)1, false);
                    if (firstUserLocation == null) {
                        this.removeDataFile(file);
                        continue;
                    }
                    Location firstDeletedLocation = this.goToFirstLocation(file, (byte)3, false);
                    if (firstDeletedLocation == null) continue;
                    this.compactDataFile(file, firstUserLocation);
                }
            }
            finally {
                this.accessor.resume();
            }
        } else {
            throw new ClosedJournalException("The journal is closed!");
        }
    }

    public void sync() throws ClosedJournalException, IOException {
        try {
            this.appender.sync().get();
            if (this.appender.getAsyncException() != null) {
                throw new IOException(this.appender.getAsyncException());
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
    }

    public synchronized void truncate() throws OpenJournalException, IOException {
        if (!this.opened) {
            for (DataFile file : this.dataFiles.values()) {
                this.removeDataFile(file);
            }
        } else {
            throw new OpenJournalException("The journal is open! The journal must be closed to be truncated.");
        }
    }

    public byte[] read(Location location, ReadType read) throws ClosedJournalException, CompactedDataFileException, IOException {
        return this.accessor.readLocation(location, read.equals((Object)ReadType.SYNC));
    }

    public Location write(byte[] data, WriteType write) throws ClosedJournalException, IOException {
        return this.write(data, write, Location.NoWriteCallback.INSTANCE);
    }

    public Location write(byte[] data, WriteType write, WriteCallback callback) throws ClosedJournalException, IOException {
        Location loc = this.appender.storeItem(data, (byte)1, write.equals((Object)WriteType.SYNC), callback);
        return loc;
    }

    public void delete(Location location) throws ClosedJournalException, CompactedDataFileException, IOException {
        this.accessor.updateLocation(location, (byte)3, this.physicalSync);
    }

    public Iterable<Location> redo() throws ClosedJournalException, CompactedDataFileException, IOException {
        Map.Entry firstEntry = this.dataFiles.firstEntry();
        if (firstEntry == null) {
            return new Redo(null);
        }
        return new Redo(this.goToFirstLocation((DataFile)firstEntry.getValue(), (byte)1, true));
    }

    public Iterable<Location> redo(Location start) throws ClosedJournalException, CompactedDataFileException, IOException {
        return new Redo(start);
    }

    public Iterable<Location> undo() throws ClosedJournalException, CompactedDataFileException, IOException {
        return new Undo(this.redo());
    }

    public Iterable<Location> undo(Location end) throws ClosedJournalException, CompactedDataFileException, IOException {
        return new Undo(this.redo(end));
    }

    public List<File> getFiles() {
        LinkedList<File> result = new LinkedList<File>();
        for (DataFile dataFile : this.dataFiles.values()) {
            result.add(dataFile.getFile());
        }
        return result;
    }

    public int getMaxFileLength() {
        return this.maxFileLength;
    }

    public void setMaxFileLength(int maxFileLength) {
        this.maxFileLength = maxFileLength;
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public String getFilePrefix() {
        return this.filePrefix;
    }

    public void setFilePrefix(String filePrefix) {
        this.filePrefix = filePrefix;
    }

    public File getDirectoryArchive() {
        return this.directoryArchive;
    }

    public void setDirectoryArchive(File directoryArchive) {
        this.directoryArchive = directoryArchive;
    }

    public boolean isArchiveFiles() {
        return this.archiveFiles;
    }

    public void setArchiveFiles(boolean archiveFiles) {
        this.archiveFiles = archiveFiles;
    }

    public void setReplicationTarget(ReplicationTarget replicationTarget) {
        this.replicationTarget = replicationTarget;
    }

    public ReplicationTarget getReplicationTarget() {
        return this.replicationTarget;
    }

    public String getFileSuffix() {
        return this.fileSuffix;
    }

    public void setFileSuffix(String fileSuffix) {
        this.fileSuffix = fileSuffix;
    }

    public boolean isChecksum() {
        return this.checksum;
    }

    public void setChecksum(boolean checksumWrites) {
        this.checksum = checksumWrites;
    }

    public boolean isPhysicalSync() {
        return this.physicalSync;
    }

    public void setPhysicalSync(boolean physicalSync) {
        this.physicalSync = physicalSync;
    }

    public int getMaxWriteBatchSize() {
        return this.maxWriteBatchSize;
    }

    public void setMaxWriteBatchSize(int maxWriteBatchSize) {
        this.maxWriteBatchSize = maxWriteBatchSize;
    }

    public void setDisposeInterval(long disposeInterval) {
        this.disposeInterval = disposeInterval;
    }

    public long getDisposeInterval() {
        return this.disposeInterval;
    }

    public void setWriter(Executor writer) {
        this.writer = writer;
        this.managedWriter = false;
    }

    public void setDisposer(ScheduledExecutorService disposer) {
        this.disposer = disposer;
        this.managedDisposer = false;
    }

    public void setRecoveryErrorHandler(RecoveryErrorHandler recoveryErrorHandler) {
        this.recoveryErrorHandler = recoveryErrorHandler;
    }

    public String toString() {
        return this.directory.toString();
    }

    Executor getWriter() {
        return this.writer;
    }

    ScheduledExecutorService getDisposer() {
        return this.disposer;
    }

    ConcurrentNavigableMap<Integer, DataFile> getDataFiles() {
        return this.dataFiles;
    }

    DataFile getDataFile(Integer id) throws CompactedDataFileException {
        Map.Entry first = this.dataFiles.firstEntry();
        if (first != null && (Integer)first.getKey() <= id) {
            return (DataFile)this.dataFiles.get(id);
        }
        throw new CompactedDataFileException(id);
    }

    ConcurrentNavigableMap<Location, Long> getHints() {
        return this.hints;
    }

    ConcurrentMap<Location, WriteCommand> getInflightWrites() {
        return this.inflightWrites;
    }

    DataFile getCurrentWriteDataFile() throws IOException {
        if (this.dataFiles.isEmpty()) {
            this.newDataFile();
        }
        return (DataFile)this.dataFiles.lastEntry().getValue();
    }

    DataFile newDataFile() throws IOException {
        int nextNum = !this.dataFiles.isEmpty() ? ((DataFile)this.dataFiles.lastEntry().getValue()).getDataFileId() + 1 : 1;
        File file = this.getFile(nextNum);
        DataFile nextWriteFile = new DataFile(file, nextNum);
        nextWriteFile.writeHeader();
        if (!this.dataFiles.isEmpty()) {
            ((DataFile)this.dataFiles.lastEntry().getValue()).setNext(nextWriteFile);
        }
        this.dataFiles.put(nextWriteFile.getDataFileId(), nextWriteFile);
        return nextWriteFile;
    }

    Location getLastAppendLocation() {
        return this.lastAppendLocation;
    }

    void setLastAppendLocation(Location location) {
        this.lastAppendLocation = location;
    }

    void addToTotalLength(int size) {
        this.totalLength.addAndGet(size);
    }

    private Location goToFirstLocation(DataFile file, byte type, boolean goToNextFile) throws IOException, IllegalStateException {
        Location start = null;
        while (file != null && start == null) {
            start = this.accessor.readLocationDetails(file.getDataFileId(), 0);
            file = goToNextFile ? file.getNext() : null;
        }
        if (start != null && (start.getType() == type || type == 0)) {
            return start;
        }
        if (start != null) {
            return this.goToNextLocation(start, type, goToNextFile);
        }
        return null;
    }

    private Location goToNextLocation(Location start, byte type, boolean goToNextFile) throws IOException {
        DataFile currentDataFile = (DataFile)this.dataFiles.get(start.getDataFileId());
        Location currentLocation = new Location(start);
        Location result = null;
        while (result == null) {
            if (currentLocation != null) {
                result = currentLocation = this.accessor.readNextLocationDetails(currentLocation, type);
                continue;
            }
            if (!goToNextFile || (currentDataFile = currentDataFile.getNext()) == null) break;
            currentLocation = this.accessor.readLocationDetails(currentDataFile.getDataFileId(), 0);
            if (currentLocation == null || currentLocation.getType() != type && type != 0) continue;
            result = currentLocation;
        }
        return result;
    }

    private File getFile(int nextNum) {
        String fileName = this.filePrefix + nextNum + this.fileSuffix;
        File file = new File(this.directory, fileName);
        return file;
    }

    private void removeDataFile(DataFile dataFile) throws IOException {
        this.dataFiles.remove(dataFile.getDataFileId());
        this.totalLength.addAndGet(-dataFile.getLength());
        Location toRemove = new Location(dataFile.getDataFileId());
        Location candidate = null;
        while ((candidate = this.hints.higherKey(toRemove)) != null && candidate.getDataFileId() == toRemove.getDataFileId()) {
            this.hints.remove(candidate);
        }
        this.accessor.dispose(dataFile);
        if (this.archiveFiles) {
            dataFile.move(this.getDirectoryArchive());
        } else {
            boolean deleted = dataFile.delete();
            if (!deleted) {
                LogHelper.warn("Failed to discard data file %s", dataFile.getFile());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compactDataFile(DataFile currentFile, Location firstUserLocation) throws IOException {
        DataFile tmpFile = new DataFile(new File(currentFile.getFile().getParent(), this.filePrefix + currentFile.getDataFileId() + this.fileSuffix + ".tmp"), currentFile.getDataFileId());
        tmpFile.writeHeader();
        RandomAccessFile raf = tmpFile.openRandomAccessFile();
        try {
            Location currentUserLocation = firstUserLocation;
            WriteBatch batch = new WriteBatch(tmpFile, 0);
            batch.prepareBatch();
            while (currentUserLocation != null) {
                byte[] data = this.accessor.readLocation(currentUserLocation, false);
                WriteCommand write = new WriteCommand(currentUserLocation, data, true);
                batch.appendBatch(write);
                currentUserLocation = this.goToNextLocation(currentUserLocation, (byte)1, false);
            }
            Location batchLocation = batch.perform(raf, true, true, null);
            this.hints.put(batchLocation, batchLocation.getThisFilePosition());
        }
        finally {
            if (raf != null) {
                raf.close();
            }
        }
        this.accessor.pause();
        try {
            this.accessor.dispose(currentFile);
            this.totalLength.addAndGet(-currentFile.getLength());
            this.totalLength.addAndGet(tmpFile.getLength());
            IOHelper.deleteFile(currentFile.getFile());
            IOHelper.renameFile(tmpFile.getFile(), currentFile.getFile());
            currentFile.incrementGeneration();
        }
        finally {
            this.accessor.resume();
        }
    }

    private Location recoveryCheck() throws IOException {
        Location next;
        LinkedList<Location> checksummedLocations = new LinkedList<Location>();
        DataFile currentFile = (DataFile)this.dataFiles.firstEntry().getValue();
        Location currentBatch = null;
        Location lastBatch = null;
        while (currentFile != null) {
            try {
                currentFile.verifyHeader();
            }
            catch (IOException ex) {
                DataFile toDelete = currentFile;
                currentFile = toDelete.getNext();
                LogHelper.warn(ex, "Deleting data file: %s", toDelete);
                this.removeDataFile(toDelete);
                continue;
            }
            try {
                currentBatch = this.goToFirstLocation(currentFile, (byte)2, false);
                while (currentBatch != null) {
                    try {
                        Location currentLocation = currentBatch;
                        this.hints.put(currentBatch, currentBatch.getThisFilePosition());
                        if (this.isChecksum()) {
                            ByteBuffer currentBatchBuffer = ByteBuffer.wrap(this.accessor.readLocation(currentBatch, false));
                            Adler32 actualChecksum = new Adler32();
                            Location nextLocation = this.goToNextLocation(currentBatch, (byte)0, false);
                            long expectedChecksum = currentBatchBuffer.getLong();
                            checksummedLocations.clear();
                            while (nextLocation != null && nextLocation.getType() != 2) {
                                assert (currentLocation.compareTo(nextLocation) < 0);
                                byte[] data = this.accessor.readLocation(nextLocation, false);
                                actualChecksum.update(data, 0, data.length);
                                checksummedLocations.add(nextLocation);
                                currentLocation = nextLocation;
                                nextLocation = this.goToNextLocation(nextLocation, (byte)0, false);
                            }
                            if (checksummedLocations.isEmpty()) {
                                throw new IllegalStateException("Found empty batch!");
                            }
                            if (expectedChecksum != actualChecksum.getValue()) {
                                this.recoveryErrorHandler.onError(this, checksummedLocations);
                            }
                            if (nextLocation != null) assert (currentLocation.compareTo(nextLocation) < 0);
                            lastBatch = currentBatch;
                            currentBatch = nextLocation;
                            continue;
                        }
                        lastBatch = currentBatch;
                        currentBatch = this.goToNextLocation(currentBatch, (byte)2, false);
                    }
                    catch (Throwable ex) {
                        LogHelper.warn(ex, "Corrupted data found, deleting data starting from location %s up to the end of the file.", currentBatch);
                        this.accessor.deleteFromLocation(currentBatch);
                        break;
                    }
                }
            }
            catch (Throwable ex) {
                LogHelper.warn(ex, "Corrupted data found while reading first batch location, deleting whole data file: %s", currentFile);
                this.removeDataFile(currentFile);
            }
            currentFile = currentFile.getNext();
        }
        Location lastRecord = lastBatch;
        while (lastRecord != null && (next = this.goToNextLocation(lastRecord, (byte)0, false)) != null) {
            lastRecord = next;
        }
        return lastRecord;
    }

    private class Undo
    implements Iterable<Location> {
        private final Object[] stack;
        private final int start;

        public Undo(Iterable<Location> redo) {
            Object[] stack = new Object[12];
            int pointer = 10;
            for (Location location : redo) {
                stack[pointer] = location;
                if (pointer == 0) {
                    Object[] tmp = new Object[12];
                    tmp[11] = stack;
                    stack = tmp;
                    pointer = 10;
                    continue;
                }
                --pointer;
            }
            this.start = pointer + 1;
            this.stack = stack;
        }

        @Override
        public Iterator<Location> iterator() {
            return new Iterator<Location>(){
                private int pointer;
                private Object[] ref;
                private Location current;
                {
                    this.pointer = Undo.this.start;
                    this.ref = Undo.this.stack;
                }

                @Override
                public boolean hasNext() {
                    return this.ref[this.pointer] != null;
                }

                @Override
                public Location next() {
                    Object next = this.ref[this.pointer];
                    if (!(this.ref[this.pointer] instanceof Location)) {
                        this.ref = (Object[])this.ref[this.pointer];
                        if (this.ref == null) {
                            throw new NoSuchElementException();
                        }
                        this.pointer = 0;
                        return this.next();
                    }
                    ++this.pointer;
                    this.current = (Location)next;
                    return this.current;
                }

                @Override
                public void remove() {
                    if (this.current == null) {
                        throw new IllegalStateException("No location to remove!");
                    }
                    try {
                        Journal.this.delete(this.current);
                        this.current = null;
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e.getMessage(), e);
                    }
                }
            };
        }
    }

    private class Redo
    implements Iterable<Location> {
        private final Location start;

        public Redo(Location start) {
            this.start = start;
        }

        @Override
        public Iterator<Location> iterator() {
            return new Iterator<Location>(){
                private Location current = null;
                private Location next = Redo.access$400(Redo.this);

                @Override
                public boolean hasNext() {
                    return this.next != null;
                }

                @Override
                public Location next() {
                    if (this.next != null) {
                        try {
                            this.current = this.next;
                            this.next = Journal.this.goToNextLocation(this.current, (byte)1, true);
                            return this.current;
                        }
                        catch (IOException ex) {
                            throw new IllegalStateException(ex.getMessage(), ex);
                        }
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    if (this.current != null) {
                        try {
                            Journal.this.delete(this.current);
                            this.current = null;
                        }
                        catch (IOException ex) {
                            throw new IllegalStateException(ex.getMessage(), ex);
                        }
                    } else {
                        throw new IllegalStateException("No location to remove!");
                    }
                }
            };
        }

        static /* synthetic */ Location access$400(Redo x0) {
            return x0.start;
        }
    }

    private static class JournalThreadFactory
    implements ThreadFactory {
        private final String groupName;
        private final String threadName;

        public JournalThreadFactory(String groupName, String threadName) {
            this.groupName = groupName;
            this.threadName = threadName;
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(new ThreadGroup(this.groupName), r, this.threadName);
        }
    }

    static class WriteFuture
    implements Future<Boolean> {
        private final CountDownLatch latch;

        WriteFuture(CountDownLatch latch) {
            this.latch = latch != null ? latch : new CountDownLatch(0);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            throw new UnsupportedOperationException("Cannot cancel this type of future!");
        }

        @Override
        public boolean isCancelled() {
            throw new UnsupportedOperationException("Cannot cancel this type of future!");
        }

        @Override
        public boolean isDone() {
            return this.latch.getCount() == 0L;
        }

        @Override
        public Boolean get() throws InterruptedException, ExecutionException {
            this.latch.await();
            return true;
        }

        @Override
        public Boolean get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            boolean success = this.latch.await(timeout, unit);
            return success;
        }
    }

    static class WriteCommand {
        private final Location location;
        private final boolean sync;
        private volatile byte[] data;

        WriteCommand(Location location, byte[] data, boolean sync) {
            this.location = location;
            this.data = data;
            this.sync = sync;
        }

        public Location getLocation() {
            return this.location;
        }

        byte[] getData() {
            return this.data;
        }

        boolean isSync() {
            return this.sync;
        }
    }

    static class WriteBatch {
        private static byte[] EMPTY_BUFFER = new byte[0];
        private final DataFile dataFile;
        private final Queue<WriteCommand> writes = new ConcurrentLinkedQueue<WriteCommand>();
        private final CountDownLatch latch = new CountDownLatch(1);
        private volatile long offset;
        private volatile int pointer;
        private volatile int size;

        WriteBatch() {
            this.dataFile = null;
            this.offset = -1L;
            this.pointer = -1;
        }

        WriteBatch(DataFile dataFile, int pointer) throws IOException {
            this.dataFile = dataFile;
            this.offset = dataFile.getLength();
            this.pointer = pointer;
            this.size = 17;
        }

        boolean canBatch(WriteCommand write, int maxWriteBatchSize, int maxFileLength) throws IOException {
            int thisBatchSize = this.size + write.location.getSize();
            long thisFileLength = this.offset + (long)thisBatchSize;
            return thisBatchSize <= maxWriteBatchSize && thisFileLength <= (long)maxFileLength;
        }

        WriteCommand prepareBatch() throws IOException {
            WriteCommand controlRecord = new WriteCommand(new Location(), EMPTY_BUFFER, false);
            controlRecord.location.setType((byte)2);
            controlRecord.location.setSize(17);
            controlRecord.location.setDataFileId(this.dataFile.getDataFileId());
            controlRecord.location.setPointer(this.pointer);
            this.size = controlRecord.location.getSize();
            this.dataFile.incrementLength(this.size);
            this.writes.offer(controlRecord);
            return controlRecord;
        }

        void appendBatch(WriteCommand writeRecord) throws IOException {
            this.size += writeRecord.location.getSize();
            this.dataFile.incrementLength(writeRecord.location.getSize());
            this.writes.offer(writeRecord);
        }

        Location perform(RandomAccessFile file, boolean checksum, boolean physicalSync, ReplicationTarget replicationTarget) throws IOException {
            ByteBuffer buffer = ByteBuffer.allocate(this.size);
            Adler32 adler32 = new Adler32();
            WriteCommand control = this.writes.peek();
            buffer.putInt(control.location.getPointer());
            buffer.putInt(17);
            buffer.put((byte)2);
            buffer.putLong(0L);
            Iterator commands = this.writes.iterator();
            commands.next();
            while (commands.hasNext()) {
                WriteCommand current = (WriteCommand)commands.next();
                buffer.putInt(current.location.getPointer());
                buffer.putInt(current.location.getSize());
                buffer.put(current.location.getType());
                buffer.put(current.getData());
                if (!checksum) continue;
                adler32.update(current.getData(), 0, current.getData().length);
            }
            buffer.position(9);
            if (checksum) {
                buffer.putLong(adler32.getValue());
            }
            file.seek(this.offset);
            file.write(buffer.array(), 0, this.size);
            if (physicalSync) {
                IOHelper.sync(file.getFD());
            }
            try {
                if (replicationTarget != null) {
                    replicationTarget.replicate(control.location, buffer.array());
                }
            }
            catch (Throwable ex) {
                LogHelper.warn("Cannot replicate!", ex);
            }
            control.location.setThisFilePosition(this.offset);
            return control.location;
        }

        DataFile getDataFile() {
            return this.dataFile;
        }

        int getSize() {
            return this.size;
        }

        CountDownLatch getLatch() {
            return this.latch;
        }

        Collection<WriteCommand> getWrites() {
            return Collections.unmodifiableCollection(this.writes);
        }

        boolean isEmpty() {
            return this.writes.isEmpty();
        }

        int incrementAndGetPointer() {
            return ++this.pointer;
        }
    }

    public static enum WriteType {
        SYNC,
        ASYNC;

    }

    public static enum ReadType {
        SYNC,
        ASYNC;

    }
}

