/*
 * Decompiled with CFR 0.152.
 */
package journal.io.api;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import journal.io.api.Journal;
import journal.io.api.RecoveryErrorHandler;
import journal.io.api.ReplicationTarget;

public class JournalBuilder {
    private final File directory;
    private File directoryArchive;
    private Boolean checksum;
    private Long disposeInterval;
    private ScheduledExecutorService disposer;
    private String filePrefix;
    private String fileSuffix;
    private Integer maxFileLength;
    private Integer maxWriteBatchSize;
    private Boolean physicalSync;
    private RecoveryErrorHandler recoveryErrorHandler;
    private ReplicationTarget replicationTarget;
    private Executor writer;

    private JournalBuilder(File directory) {
        if (!directory.exists()) {
            throw new IllegalArgumentException("<" + directory + "> does not exist");
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("<" + directory + "> is not a directory");
        }
        if (!directory.canWrite()) {
            throw new IllegalArgumentException("Cannot write to main directory <" + directory + ">");
        }
        this.directory = directory;
    }

    public JournalBuilder setArchived(File to) {
        if (!to.exists()) {
            throw new IllegalArgumentException("<" + to + "> does not exist");
        }
        if (!to.isDirectory()) {
            throw new IllegalArgumentException("<" + to + "> is not a directory");
        }
        this.directoryArchive = to;
        return this;
    }

    public JournalBuilder setChecksum(Boolean checksum) {
        this.checksum = checksum;
        return this;
    }

    public JournalBuilder setDisposeInterval(Long disposeInterval) {
        this.disposeInterval = disposeInterval;
        return this;
    }

    public JournalBuilder setDisposer(ScheduledExecutorService disposer) {
        this.disposer = disposer;
        return this;
    }

    public JournalBuilder setFilePrefix(String filePrefix) {
        this.filePrefix = filePrefix;
        return this;
    }

    public JournalBuilder setFileSuffix(String fileSuffix) {
        this.fileSuffix = fileSuffix;
        return this;
    }

    public JournalBuilder setMaxFileLength(Integer maxFileLength) {
        this.maxFileLength = maxFileLength;
        return this;
    }

    public JournalBuilder setMaxWriteBatchSize(Integer maxWriteBatchSize) {
        this.maxWriteBatchSize = maxWriteBatchSize;
        return this;
    }

    public JournalBuilder setPhysicalSync(Boolean physicalSync) {
        this.physicalSync = physicalSync;
        return this;
    }

    public JournalBuilder setRecoveryErrorHandler(RecoveryErrorHandler recoveryErrorHandler) {
        this.recoveryErrorHandler = recoveryErrorHandler;
        return this;
    }

    public JournalBuilder setReplicationTarget(ReplicationTarget replicationTarget) {
        this.replicationTarget = replicationTarget;
        return this;
    }

    public JournalBuilder setWriter(Executor writer) {
        this.writer = writer;
        return this;
    }

    public Journal open() throws IOException {
        Journal journal = new Journal();
        journal.setDirectory(this.directory);
        if (this.directoryArchive != null) {
            journal.setArchiveFiles(true);
            journal.setDirectoryArchive(this.directoryArchive);
        }
        if (this.checksum != null) {
            journal.setChecksum(this.checksum);
        }
        if (this.disposeInterval != null) {
            journal.setDisposeInterval(this.disposeInterval);
        }
        if (this.disposer != null) {
            journal.setDisposer(this.disposer);
        }
        if (this.filePrefix != null) {
            journal.setFilePrefix(this.filePrefix);
        }
        if (this.fileSuffix != null) {
            journal.setFileSuffix(this.fileSuffix);
        }
        if (this.maxFileLength != null) {
            journal.setMaxFileLength(this.maxFileLength);
        }
        if (this.maxWriteBatchSize != null) {
            journal.setMaxWriteBatchSize(this.maxWriteBatchSize);
        }
        if (this.physicalSync != null) {
            journal.setPhysicalSync(this.physicalSync);
        }
        if (this.recoveryErrorHandler != null) {
            journal.setRecoveryErrorHandler(this.recoveryErrorHandler);
        }
        if (this.replicationTarget != null) {
            journal.setReplicationTarget(this.replicationTarget);
        }
        if (this.writer != null) {
            journal.setWriter(this.writer);
        }
        journal.open();
        return journal;
    }

    public static JournalBuilder of(File directory) {
        return new JournalBuilder(directory);
    }
}

