/*
 * Decompiled with CFR 0.152.
 */
package journal.io.api;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import journal.io.api.WriteCallback;

public final class Location
implements Comparable<Location> {
    static final byte ANY_RECORD_TYPE = 0;
    static final byte USER_RECORD_TYPE = 1;
    static final byte BATCH_CONTROL_RECORD_TYPE = 2;
    static final byte DELETED_RECORD_TYPE = 3;
    static final int NOT_SET = -1;
    private volatile int dataFileId = -1;
    private volatile int dataFileGeneration = -1;
    private volatile long thisFilePosition = -1L;
    private volatile long nextFilePosition = -1L;
    private volatile int pointer = -1;
    private volatile int size = -1;
    private volatile byte type = 0;
    private volatile WriteCallback writeCallback = NoWriteCallback.INSTANCE;
    private volatile byte[] data;
    private volatile CountDownLatch latch;

    public Location() {
    }

    public Location(Location source) {
        this.dataFileId = source.dataFileId;
        this.dataFileGeneration = source.dataFileGeneration;
        this.thisFilePosition = source.thisFilePosition;
        this.nextFilePosition = source.nextFilePosition;
        this.pointer = source.pointer;
        this.size = source.size;
        this.type = source.type;
    }

    public Location(int dataFileId) {
        this.dataFileId = dataFileId;
    }

    public Location(int dataFileId, int pointer) {
        this.dataFileId = dataFileId;
        this.pointer = pointer;
    }

    public boolean isBatchControlRecord() {
        return this.dataFileId != -1 && this.type == 2;
    }

    public boolean isDeletedRecord() {
        return this.dataFileId != -1 && this.type == 3;
    }

    public boolean isUserRecord() {
        return this.dataFileId != -1 && this.type == 1;
    }

    public int getSize() {
        return this.size;
    }

    public int getPointer() {
        return this.pointer;
    }

    public int getDataFileId() {
        return this.dataFileId;
    }

    public byte[] getData() {
        return this.data;
    }

    void setSize(int size) {
        this.size = size;
    }

    void setPointer(int pointer) {
        this.pointer = pointer;
    }

    void setDataFileId(int file) {
        this.dataFileId = file;
    }

    byte getType() {
        return this.type;
    }

    void setType(byte type) {
        this.type = type;
    }

    CountDownLatch getLatch() {
        return this.latch;
    }

    void setLatch(CountDownLatch latch) {
        this.latch = latch;
    }

    void setWriteCallback(WriteCallback writeCallback) {
        this.writeCallback = writeCallback;
    }

    WriteCallback getWriteCallback() {
        return this.writeCallback;
    }

    void setData(byte[] data) {
        this.data = data;
    }

    long getThisFilePosition() {
        return this.thisFilePosition;
    }

    void setThisFilePosition(long thisFilePosition) {
        this.thisFilePosition = thisFilePosition;
    }

    long getNextFilePosition() {
        return this.nextFilePosition;
    }

    void setNextFilePosition(long nextFilePosition) {
        this.nextFilePosition = nextFilePosition;
    }

    void setDataFileGeneration(int dataFileGeneration) {
        this.dataFileGeneration = dataFileGeneration;
    }

    int getDataFileGeneration() {
        return this.dataFileGeneration;
    }

    public String toString() {
        return this.dataFileId + ":" + this.pointer + ":" + this.type;
    }

    public void writeExternal(DataOutput dos) throws IOException {
        dos.writeInt(this.dataFileId);
        dos.writeInt(this.dataFileGeneration);
        dos.writeLong(this.thisFilePosition);
        dos.writeLong(this.nextFilePosition);
        dos.writeInt(this.pointer);
        dos.writeInt(this.size);
        dos.writeByte(this.type);
    }

    public void readExternal(DataInput dis) throws IOException {
        this.dataFileId = dis.readInt();
        this.dataFileGeneration = dis.readInt();
        this.thisFilePosition = dis.readLong();
        this.nextFilePosition = dis.readLong();
        this.pointer = dis.readInt();
        this.size = dis.readInt();
        this.type = dis.readByte();
    }

    @Override
    public int compareTo(Location o) {
        if (this.dataFileId == o.dataFileId) {
            int rc = this.pointer - o.pointer;
            return rc;
        }
        return this.dataFileId - o.dataFileId;
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof Location) {
            result = this.compareTo((Location)o) == 0;
        }
        return result;
    }

    public int hashCode() {
        return this.dataFileId ^ this.pointer;
    }

    static class NoWriteCallback
    implements WriteCallback {
        public static final WriteCallback INSTANCE = new NoWriteCallback();

        NoWriteCallback() {
        }

        @Override
        public void onSync(Location syncedLocation) {
        }

        @Override
        public void onError(Location location, Throwable error) {
        }
    }
}

