/*
 * Decompiled with CFR 0.152.
 */
package journal.io.api;

import java.io.IOException;
import java.util.List;
import journal.io.api.Journal;
import journal.io.api.Location;
import journal.io.util.LogHelper;

public interface RecoveryErrorHandler {
    public static final RecoveryErrorHandler ABORT = new AbortOnError();
    public static final RecoveryErrorHandler DELETE = new DeleteOnError();
    public static final RecoveryErrorHandler IGNORE = new IgnoreOnError();

    public void onError(Journal var1, List<Location> var2) throws IOException;

    public static class IgnoreOnError
    implements RecoveryErrorHandler {
        @Override
        public void onError(Journal journal, List<Location> locations) throws IOException {
            for (Location location : locations) {
                LogHelper.warn("Bad checksum for location, ignoring: " + location, new Object[0]);
            }
        }
    }

    public static class DeleteOnError
    implements RecoveryErrorHandler {
        @Override
        public void onError(Journal journal, List<Location> locations) throws IOException {
            for (Location location : locations) {
                LogHelper.warn("Deleting location due to bad checksum: " + location, new Object[0]);
                journal.delete(location);
            }
        }
    }

    public static class AbortOnError
    implements RecoveryErrorHandler {
        @Override
        public void onError(Journal journal, List<Location> locations) throws IOException {
            for (Location location : locations) {
                LogHelper.error("Bad checksum for location: " + location, new Object[0]);
            }
            throw new IOException("Aborting recovery process!");
        }
    }
}

