/*
 * Decompiled with CFR 0.152.
 */
package journal.io.util;

import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public final class IOHelper {
    protected static final int MAX_DIR_NAME_LENGTH = Integer.valueOf(System.getProperty("MaximumDirNameLength", "200"));
    protected static final int MAX_FILE_NAME_LENGTH = Integer.valueOf(System.getProperty("MaximumFileNameLength", "64"));
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    static final IOStrategy IO_STRATEGY = IOHelper.createIOStrategy();

    private IOHelper() {
    }

    public static boolean deleteFile(File fileToDelete) {
        if (fileToDelete == null || !fileToDelete.exists()) {
            return true;
        }
        boolean result = IOHelper.deleteChildren(fileToDelete);
        return result &= fileToDelete.delete();
    }

    public static boolean deleteChildren(File parent) {
        if (parent == null || !parent.exists()) {
            return false;
        }
        boolean result = true;
        if (parent.isDirectory()) {
            File[] files = parent.listFiles();
            if (files == null) {
                result = false;
            } else {
                for (int i = 0; i < files.length; ++i) {
                    File file = files[i];
                    if (file.getName().equals(".") || file.getName().equals("..")) continue;
                    if (file.isDirectory()) {
                        result &= IOHelper.deleteFile(file);
                        continue;
                    }
                    result &= file.delete();
                }
            }
        }
        return result;
    }

    public static void moveFile(File src, File targetDirectory) throws IOException {
        if (!src.renameTo(new File(targetDirectory, src.getName()))) {
            throw new IOException("Failed to move " + src + " to " + targetDirectory);
        }
    }

    public static void renameFile(File src, File dest) throws IOException {
        if (!src.renameTo(dest)) {
            throw new IOException("Failed to rename " + src + " to " + dest);
        }
    }

    public static void copyFile(File src, File dest) throws IOException {
        FileInputStream fileSrc = new FileInputStream(src);
        FileOutputStream fileDest = new FileOutputStream(dest);
        IOHelper.copyInputStream(fileSrc, fileDest);
    }

    public static void copyInputStream(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[4096];
        int len = in.read(buffer);
        while (len >= 0) {
            out.write(buffer, 0, len);
            len = in.read(buffer);
        }
        in.close();
        out.close();
    }

    public static void sync(FileDescriptor fd) throws IOException {
        IO_STRATEGY.sync(fd);
    }

    public static void skipBytes(RandomAccessFile raf, int bytes) throws IOException {
        int skipped;
        for (int n = 0; n < bytes; n += skipped) {
            skipped = raf.skipBytes(bytes - n);
            if (skipped != 0 || raf.getFilePointer() < raf.length()) continue;
            throw new EOFException();
        }
    }

    private static IOStrategy createIOStrategy() {
        return new IOStrategy(){

            @Override
            public void sync(FileDescriptor fd) throws IOException {
                fd.sync();
            }
        };
    }

    public static interface IOStrategy {
        public void sync(FileDescriptor var1) throws IOException;
    }
}

