/*
 * Decompiled with CFR 0.152.
 */
package pekko.contrib.persistence.mongodb;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.dispatch.MessageDispatcher;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.Materializer$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pekko.contrib.persistence.mongodb.Atom;
import pekko.contrib.persistence.mongodb.CanDeserializeJournal;
import pekko.contrib.persistence.mongodb.CanSerializeJournal;
import pekko.contrib.persistence.mongodb.CanSuffixCollectionNames;
import pekko.contrib.persistence.mongodb.Event;
import pekko.contrib.persistence.mongodb.IndexSettings;
import pekko.contrib.persistence.mongodb.MongoCollectionCache;
import pekko.contrib.persistence.mongodb.MongoCollectionCache$;
import pekko.contrib.persistence.mongodb.MongoPersistenceDriver$;
import pekko.contrib.persistence.mongodb.MongoSettings;
import pekko.contrib.persistence.mongodb.MongoSettings$;
import pekko.contrib.persistence.mongodb.ReflectiveLookupExtension;
import pekko.contrib.persistence.mongodb.ReflectiveLookupExtension$;
import pekko.contrib.persistence.mongodb.ServerVersion;
import pekko.contrib.persistence.mongodb.ServerVersion$;
import pekko.contrib.persistence.mongodb.WithMongoPersistencePluginDispatcher;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0011Us\u0001CA\u0004\u0003\u0013A\t!a\u0007\u0007\u0011\u0005}\u0011\u0011\u0002E\u0001\u0003CAq!a\f\u0002\t\u0003\t\tDB\u0005\u00024\u0005\u0001\n1%\t\u00026\u001d9\u0011Q^\u0001\t\u0002\u0006\rhaBAo\u0003!\u0005\u0015q\u001c\u0005\b\u0003_)A\u0011AAq\u0011%\t\u0019'BA\u0001\n\u0003\n)\u0007C\u0005\u0002x\u0015\t\t\u0011\"\u0001\u0002z!I\u0011\u0011Q\u0003\u0002\u0002\u0013\u0005\u0011Q\u001d\u0005\n\u0003\u001f+\u0011\u0011!C!\u0003#C\u0011\"a(\u0006\u0003\u0003%\t!!;\t\u0013\u0005-V!!A\u0005B\u00055\u0006\"CAX\u000b\u0005\u0005I\u0011IAY\u0011%\t\u0019,BA\u0001\n\u0013\t)lB\u0004\u0002p\u0006A\t)!\u0019\u0007\u000f\u0005e\u0012\u0001#!\u0002<!9\u0011q\u0006\t\u0005\u0002\u0005}\u0003\"CA2!\u0005\u0005I\u0011IA3\u0011%\t9\bEA\u0001\n\u0003\tI\bC\u0005\u0002\u0002B\t\t\u0011\"\u0001\u0002\u0004\"I\u0011q\u0012\t\u0002\u0002\u0013\u0005\u0013\u0011\u0013\u0005\n\u0003?\u0003\u0012\u0011!C\u0001\u0003CC\u0011\"a+\u0011\u0003\u0003%\t%!,\t\u0013\u0005=\u0006#!A\u0005B\u0005E\u0006\"CAZ!\u0005\u0005I\u0011BA[\u000f\u001d\t\t0\u0001EA\u0003\u00074q!!0\u0002\u0011\u0003\u000by\fC\u0004\u00020m!\t!!1\t\u0013\u0005\r4$!A\u0005B\u0005\u0015\u0004\"CA<7\u0005\u0005I\u0011AA=\u0011%\t\tiGA\u0001\n\u0003\t)\rC\u0005\u0002\u0010n\t\t\u0011\"\u0011\u0002\u0012\"I\u0011qT\u000e\u0002\u0002\u0013\u0005\u0011\u0011\u001a\u0005\n\u0003W[\u0012\u0011!C!\u0003[C\u0011\"a,\u001c\u0003\u0003%\t%!-\t\u0013\u0005M6$!A\u0005\n\u0005UvaBAz\u0003!\u0005\u00151\u001b\u0004\b\u0003\u001b\f\u0001\u0012QAh\u0011\u001d\tyC\nC\u0001\u0003#D\u0011\"a\u0019'\u0003\u0003%\t%!\u001a\t\u0013\u0005]d%!A\u0005\u0002\u0005e\u0004\"CAAM\u0005\u0005I\u0011AAk\u0011%\tyIJA\u0001\n\u0003\n\t\nC\u0005\u0002 \u001a\n\t\u0011\"\u0001\u0002Z\"I\u00111\u0016\u0014\u0002\u0002\u0013\u0005\u0013Q\u0016\u0005\n\u0003_3\u0013\u0011!C!\u0003cC\u0011\"a-'\u0003\u0003%I!!.\t\u000f\u0005U\u0018\u0001b\u0001\u0002x\u001aA\u0011qDA\u0005\u0003\u0003\u0011Y\u0001\u0003\u0006\u0003\u0014E\u0012\t\u0011)A\u0005\u0005+A!Ba\u000b2\u0005\u0003\u0005\u000b\u0011\u0002B\u0017\u0011\u001d\ty#\rC\u0001\u0005\u007f!qAa\u00122\u0005\u0003\u0011I\u0005B\u0004\u0003RE\u0012\tA!\u0013\t\u0013\tM\u0013G1A\u0005\u0002\u0005\u0015\u0004\u0002\u0003B+c\u0001\u0006I!a\u001a\t\u0013\t]\u0013G1A\u0005\u0012\te\u0003\u0002\u0003B4c\u0001\u0006IAa\u0017\t\u0013\t%\u0014G1A\u0005\u0004\t-\u0004\u0002\u0003B7c\u0001\u0006IA!\u0006\t\u0013\t=\u0014G1A\u0005\u0004\tE\u0004\u0002\u0003B@c\u0001\u0006IAa\u001d\t\u0015\t\u0005\u0015\u0007#b\u0001\n\u0003\u0011\u0019\tC\u0004\u0002\u001aF2\tAa#\t\u000f\t\u0005\u0016G\"\u0001\u0003$\"9!QV\u0019\u0007\u0002\t=\u0006b\u0002BZc\u0019\u0005!Q\u0017\u0005\b\u0005s\u000bd\u0011\u0001B^\u0011\u001d\u0011y.\rD\u0001\u0005CDqAa<2\r\u0003\u0011\t\u0010C\u0004\u0003tF2\tA!>\t\u0019\te\u0018\u0007#b\u0001\n\u0003\tIAa?\t\u000f\r\u0015\u0011\u0007\"\u0001\u0004\b!91\u0011D\u0019\u0005\u0002\rm\u0001bBB\u0011c\u0011\u000511\u0005\u0005\b\u0007K\tD\u0011AB\u0012\u0011\u001d\u00199#\rC\u0001\u0007GAqa!\u000b2\t\u0003\u0019\u0019\u0003C\u0004\u0004,E\"\ta!\f\t\u000f\rM\u0012\u0007\"\u0001\u00046!I11H\u0019C\u0002\u0013%1Q\b\u0005\t\u0007\u000f\n\u0004\u0015!\u0003\u0004@!A1\u0011J\u0019!\n\u0013\u0019Y\u0005\u0003\u0005\u0004RE\u0002K\u0011BB*\u0011!\u0019I&\rQ\u0005\n\rm\u0003bBB4c\u0011\u00051\u0011\u000e\u0005\b\u0007[\nD\u0011AB8\u0011\u001d\u0019\u0019(\rC\u0001\u0007kBqa!\u001f2\t\u0003\u0019Y\b\u0003\u0007\u0004\u0000EB)\u0019!C\u0001\u0003\u0013\u0019\t\t\u0003\u0005\u0004\u0010F\u0002\u000b\u0011BBI\u0011\u001d\u00199*\rC\u0001\u00073Cqaa&2\t\u0003\u0019Y\nC\u0004\u0004 F\"\ta!)\t\u0011\r\u0015\u0016\u0007)A\u0005\u0007#Cqaa*2\t\u0003\u0019I\nC\u0004\u0004(F\"\ta!+\t\u000f\r5\u0016\u0007\"\u0001\u00040\"A11W\u0019!\u0002\u0013\u0019\t\nC\u0005\u00046F\"\t!!\u0003\u0004\u001a\"Y1qW\u0019C\u0002\u0013\u0005\u0011\u0011BB]\u0011!\u00199-\rQ\u0001\n\rm\u0006\u0002CBec\u0001\u0006Ia!%\t\u000f\r-\u0017\u0007\"\u0001\u0004\u001a\"91QZ\u0019\u0005\u0002\r=\u0007bBBic\u0011\u000511\u001b\u0005\b\u0007/\fD\u0011ABm\u0011\u001d\u0019Y.\rC\u0001\u00073Dqa!82\t\u0003\u0019y\u000eC\u0004\u0004fF\"\taa:\t\u000f\rU\u0018\u0007\"\u0001\u0004P\"91q_\u0019\u0005\u0002\re\u0007bBB}c\u0011\u00051\u0011\u001c\u0005\b\u0007w\fD\u0011ABm\u0011\u001d\u0019i0\rC\u0001\u00073Dqaa@2\t\u0003\u0019y\u000eC\u0004\u0005\u0002E\"\taa:\t\u000f\u0011\r\u0011\u0007\"\u0001\u0004P\"9AQA\u0019\u0005\u0002\r=\u0007b\u0002C\u0004c\u0011\u00051\u0011\u001c\u0005\b\t\u0013\tD\u0011\u0001C\u0006\u0011\u001d!\u0019\"\rC\u0001\u00073Dq\u0001\"\u00062\t\u0003\u0019I\u000eC\u0004\u0005\u0018E\"\ta!7\t\u000f\u0011e\u0011\u0007\"\u0001\u0004P\"9A1D\u0019\u0005\u0002\rM\u0007b\u0002C\u000fc\u0011\u00051\u0011\u001c\u0005\b\t?\tD\u0011ABh\u0011\u001d!\t#\rC\u0001\tGAq\u0001\"\u00102\t\u0003!y$\u0001\fN_:<w\u000eU3sg&\u001cH/\u001a8dK\u0012\u0013\u0018N^3s\u0015\u0011\tY!!\u0004\u0002\u000f5|gnZ8eE*!\u0011qBA\t\u0003-\u0001XM]:jgR,gnY3\u000b\t\u0005M\u0011QC\u0001\bG>tGO]5c\u0015\t\t9\"A\u0003qK.\\wn\u0001\u0001\u0011\u0007\u0005u\u0011!\u0004\u0002\u0002\n\t1Rj\u001c8h_B+'o]5ti\u0016t7-\u001a#sSZ,'oE\u0002\u0002\u0003G\u0001B!!\n\u0002,5\u0011\u0011q\u0005\u0006\u0003\u0003S\tQa]2bY\u0006LA!!\f\u0002(\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtDCAA\u000e\u0005-9&/\u001b;f'\u00064W\r^=\u0014\u0007\r\t\u0019#K\u0003\u0004!m1SA\u0001\u0007BG.twn\u001e7fI\u001e,GmE\u0005\u0011\u0003G\ti$!\u0011\u0002HA\u0019\u0011qH\u0002\u000e\u0003\u0005\u0001B!!\n\u0002D%!\u0011QIA\u0014\u0005\u001d\u0001&o\u001c3vGR\u0004B!!\u0013\u0002Z9!\u00111JA+\u001d\u0011\ti%a\u0015\u000e\u0005\u0005=#\u0002BA)\u00033\ta\u0001\u0010:p_Rt\u0014BAA\u0015\u0013\u0011\t9&a\n\u0002\u000fA\f7m[1hK&!\u00111LA/\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\u0011\t9&a\n\u0015\u0005\u0005\u0005\u0004cAA !\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u001a\u0011\t\u0005%\u00141O\u0007\u0003\u0003WRA!!\u001c\u0002p\u0005!A.\u00198h\u0015\t\t\t(\u0001\u0003kCZ\f\u0017\u0002BA;\u0003W\u0012aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAA>!\u0011\t)#! \n\t\u0005}\u0014q\u0005\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u000b\u000bY\t\u0005\u0003\u0002&\u0005\u001d\u0015\u0002BAE\u0003O\u00111!\u00118z\u0011%\ti\tFA\u0001\u0002\u0004\tY(A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003'\u0003b!!&\u0002\u001c\u0006\u0015UBAAL\u0015\u0011\tI*a\n\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u001e\u0006]%\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a)\u0002*B!\u0011QEAS\u0013\u0011\t9+a\n\u0003\u000f\t{w\u000e\\3b]\"I\u0011Q\u0012\f\u0002\u0002\u0003\u0007\u0011QQ\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u00111P\u0001\ti>\u001cFO]5oOR\u0011\u0011qM\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0003o\u0003B!!\u001b\u0002:&!\u00111XA6\u0005\u0019y%M[3di\nI!j\\;s]\u0006dW\rZ\n\n7\u0005\r\u0012QHA!\u0003\u000f\"\"!a1\u0011\u0007\u0005}2\u0004\u0006\u0003\u0002\u0006\u0006\u001d\u0007\"CAG?\u0005\u0005\t\u0019AA>)\u0011\t\u0019+a3\t\u0013\u00055\u0015%!AA\u0002\u0005\u0015%a\u0005*fa2L7-Y!dW:|w\u000f\\3eO\u0016$7#\u0003\u0014\u0002$\u0005u\u0012\u0011IA$)\t\t\u0019\u000eE\u0002\u0002@\u0019\"B!!\"\u0002X\"I\u0011Q\u0012\u0016\u0002\u0002\u0003\u0007\u00111\u0010\u000b\u0005\u0003G\u000bY\u000eC\u0005\u0002\u000e2\n\t\u00111\u0001\u0002\u0006\nqQK\\1dW:|w\u000f\\3eO\u0016$7#C\u0003\u0002$\u0005u\u0012\u0011IA$)\t\t\u0019\u000fE\u0002\u0002@\u0015!B!!\"\u0002h\"I\u0011QR\u0005\u0002\u0002\u0003\u0007\u00111\u0010\u000b\u0005\u0003G\u000bY\u000fC\u0005\u0002\u000e.\t\t\u00111\u0001\u0002\u0006\u0006qQK\\1dW:|w\u000f\\3eO\u0016$\u0017\u0001D!dW:|w\u000f\\3eO\u0016$\u0017!\u0003&pkJt\u0017\r\\3e\u0003M\u0011V\r\u001d7jG\u0006\f5m\u001b8po2,GmZ3e\u0003I\u0019HO]5oOJ:&/\u001b;f'\u00064W\r^=\u0015\t\u0005u\u0012\u0011 \u0005\b\u0003w\u0004\u0004\u0019AA\u007f\u0003)1'o\\7D_:4\u0017n\u001a\t\u0005\u0003\u007f\u00149A\u0004\u0003\u0003\u0002\t\r\u0001\u0003BA'\u0003OIAA!\u0002\u0002(\u00051\u0001K]3eK\u001aLA!!\u001e\u0003\n)!!QAA\u0014'\r\t$Q\u0002\t\u0005\u0003;\u0011y!\u0003\u0003\u0003\u0012\u0005%!\u0001J,ji\"luN\\4p!\u0016\u00148/[:uK:\u001cW\r\u00157vO&tG)[:qCR\u001c\u0007.\u001a:\u0002\u0005\u0005\u001c\b\u0003\u0002B\f\u0005Oi!A!\u0007\u000b\t\tm!QD\u0001\u0006C\u000e$xN\u001d\u0006\u0005\u0003/\u0011yB\u0003\u0003\u0003\"\t\r\u0012AB1qC\u000eDWM\u0003\u0002\u0003&\u0005\u0019qN]4\n\t\t%\"\u0011\u0004\u0002\f\u0003\u000e$xN]*zgR,W.\u0001\u0004d_:4\u0017n\u001a\t\u0005\u0005_\u0011Y$\u0004\u0002\u00032)!!1\u0006B\u001a\u0015\u0011\u0011)Da\u000e\u0002\u0011QL\b/Z:bM\u0016T!A!\u000f\u0002\u0007\r|W.\u0003\u0003\u0003>\tE\"AB\"p]\u001aLw\r\u0006\u0004\u0003B\t\r#Q\t\t\u0004\u0003;\t\u0004b\u0002B\ni\u0001\u0007!Q\u0003\u0005\b\u0005W!\u0004\u0019\u0001B\u0017\u0005\u0005\u0019\u0015\u0003\u0002B&\u0003\u000b\u0003B!!\n\u0003N%!!qJA\u0014\u0005\u001dqu\u000e\u001e5j]\u001e\u0014\u0011\u0001R\u0001\u0010\t\u00163\u0015)\u0016'U?\u0012\u0013uLT!N\u000b\u0006\u0001B)\u0012$B+2#v\f\u0012\"`\u001d\u0006kU\tI\u0001\u0007Y><w-\u001a:\u0016\u0005\tm\u0003\u0003\u0002B/\u0005Gj!Aa\u0018\u000b\t\t\u0005$1E\u0001\u0006g24GG[\u0005\u0005\u0005K\u0012yF\u0001\u0004M_\u001e<WM]\u0001\bY><w-\u001a:!\u0003-\t7\r^8s'f\u001cH/Z7\u0016\u0005\tU\u0011\u0001D1di>\u00148+_:uK6\u0004\u0013\u0001D7bi\u0016\u0014\u0018.\u00197ju\u0016\u0014XC\u0001B:!\u0011\u0011)Ha\u001f\u000e\u0005\t]$\u0002\u0002B=\u0005;\taa\u001d;sK\u0006l\u0017\u0002\u0002B?\u0005o\u0012A\"T1uKJL\u0017\r\\5{KJ\fQ\"\\1uKJL\u0017\r\\5{KJ\u0004\u0013\u0001C:fiRLgnZ:\u0016\u0005\t\u0015\u0005\u0003BA\u000f\u0005\u000fKAA!#\u0002\n\tiQj\u001c8h_N+G\u000f^5oON$BA!$\u0003\u001eB1!q\u0012BK\u00053k!A!%\u000b\t\tM\u0015qE\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002\u0002BL\u0005#\u0013aAR;ukJ,\u0007c\u0001BNk5\t\u0011\u0007C\u0004\u0003 \u0002\u0003\r!!@\u0002\t9\fW.Z\u0001\u0010G>dG.Z2uS>tg*Y7fgV\u0011!Q\u0015\t\u0007\u0005\u001f\u0013)Ja*\u0011\r\u0005%#\u0011VA\u007f\u0013\u0011\u0011Y+!\u0018\u0003\t1K7\u000f^\u0001\u0011K:\u001cXO]3D_2dWm\u0019;j_:$BA!$\u00032\"9!q\u0014\"A\u0002\u0005u\u0018\u0001E2baB,GmQ8mY\u0016\u001cG/[8o)\u0011\u0011iIa.\t\u000f\t}5\t1\u0001\u0002~\u0006YQM\\:ve\u0016Le\u000eZ3y))\u0011iLa1\u0003H\n-'q\u001a\t\t\u0003K\u0011yL!'\u0003\u000e&!!\u0011YA\u0014\u0005%1UO\\2uS>t\u0017\u0007C\u0004\u0003F\u0012\u0003\r!!@\u0002\u0013%tG-\u001a=OC6,\u0007b\u0002Be\t\u0002\u0007\u00111U\u0001\u0007k:L\u0017/^3\t\u000f\t5G\t1\u0001\u0002$\u000611\u000f]1sg\u0016DqA!5E\u0001\u0004\u0011\u0019.\u0001\u0004gS\u0016dGm\u001d\t\u0007\u0003K\u0011)N!7\n\t\t]\u0017q\u0005\u0002\u000byI,\u0007/Z1uK\u0012t\u0004\u0003CA\u0013\u00057\fi0a\u001f\n\t\tu\u0017q\u0005\u0002\u0007)V\u0004H.\u001a\u001a\u0002+I,Wn\u001c<f\u000b6\u0004H/_\"pY2,7\r^5p]R1!1\u001dBv\u0005[\u0004bAa$\u0003\u0016\n\u0015\b\u0003BA\u0013\u0005OLAA!;\u0002(\t!QK\\5u\u0011\u001d\tI*\u0012a\u0001\u00053CqA!2F\u0001\u0004\ti0\u0001\tdY>\u001cXmQ8o]\u0016\u001cG/[8ogR\u0011!Q]\u0001\u001dO\u0016$Xj\u001c8h_Z+'o]5p]\u001a\u0013x.\u001c\"vS2$\u0017J\u001c4p+\t\u00119\u0010\u0005\u0004\u0003\u0010\nU\u0015Q`\u0001\r[>twm\u001c,feNLwN\\\u000b\u0003\u0005{\u0004bAa$\u0003\u0016\n}\b\u0003BA\u000f\u0007\u0003IAaa\u0001\u0002\n\ti1+\u001a:wKJ4VM]:j_:\f\u0011dZ3u\u00032d7i\u001c7mK\u000e$\u0018n\u001c8t\u0003N4U\u000f^;sKR!1\u0011BB\u0007!\u0019\u0011yI!&\u0004\fA1\u0011\u0011\nBU\u00053Cqaa\u0004J\u0001\u0004\u0019\t\"\u0001\u0006oC6,g)\u001b7uKJ\u0004b!!\n\u0004\u0014\r]\u0011\u0002BB\u000b\u0003O\u0011aa\u00149uS>t\u0007\u0003CA\u0013\u0005\u007f\u000bi0a)\u0002-\u001d,GoQ8mY\u0016\u001cG/[8og\u0006\u001bh)\u001e;ve\u0016$Ba!\u0003\u0004\u001e!91q\u0004&A\u0002\u0005u\u0018AD2pY2,7\r^5p]:\u000bW.Z\u0001\u0016O\u0016$(j\\;s]\u0006d7i\u001c7mK\u000e$\u0018n\u001c8t+\t\u0019I!\u0001\u000ek_V\u0014h.\u00197D_2dWm\u0019;j_:\u001c\u0018i\u001d$viV\u0014X-\u0001\fhKR\u001cf.\u00199tQ>$8i\u001c7mK\u000e$\u0018n\u001c8t\u0003m\u0019h.\u00199tQ>$8i\u001c7mK\u000e$\u0018n\u001c8t\u0003N4U\u000f^;sK\u0006\u0011\"/Z7pm\u0016,U\u000e\u001d;z\u0015>,(O\\1m)\u0011\u0011\u0019oa\f\t\u000f\rEr\n1\u0001\u0003\u001a\u0006\u0019!N\u001c7\u0002'I,Wn\u001c<f\u000b6\u0004H/_*oCB\u001c\bn\u001c;\u0015\t\t\r8q\u0007\u0005\b\u0007s\u0001\u0006\u0019\u0001BM\u0003\r\u0019h\u000e]\u0001 G\u0006t7+\u001e4gSb\u001cu\u000e\u001c7fGRLwN\u001c(b[\u0016\u001c()^5mI\u0016\u0014XCAB !\u0019\t)ca\u0005\u0004BA!\u0011QDB\"\u0013\u0011\u0019)%!\u0003\u00031\r\u000bgnU;gM&D8i\u001c7mK\u000e$\u0018n\u001c8OC6,7/\u0001\u0011dC:\u001cVO\u001a4jq\u000e{G\u000e\\3di&|gNT1nKN\u0014U/\u001b7eKJ\u0004\u0013AG4fiN+hMZ5y\rJ|W\u000eU3sg&\u001cH/\u001a8dK&#G\u0003BA\u007f\u0007\u001bBqaa\u0014T\u0001\u0004\ti0A\u0007qKJ\u001c\u0018n\u001d;f]\u000e,\u0017\nZ\u0001\u0018m\u0006d\u0017\u000eZ1uK6{gnZ8DQ\u0006\u0014\u0018m\u0019;feN$B!!@\u0004V!91q\u000b+A\u0002\u0005u\u0018!B5oaV$\u0018AE1qa\u0016tGmU;gM&DHk\u001c(b[\u0016$Ba!\u0018\u0004dQ!\u0011Q`B0\u0011\u001d\u0019\t'\u0016a\u0001\u0003{\faa];gM&D\bbBB3+\u0002\u0007\u0011Q`\u0001\u000f]\u0006lW-\u00138TKR$\u0018N\\4t\u0003a9W\r\u001e&pkJt\u0017\r\\\"pY2,7\r^5p]:\u000bW.\u001a\u000b\u0005\u0003{\u001cY\u0007C\u0004\u0004PY\u0003\r!!@\u0002-\u001d,Go\u00158baN\u001cu\u000e\u001c7fGRLwN\u001c(b[\u0016$B!!@\u0004r!91qJ,A\u0002\u0005u\u0018AC4fi*{WO\u001d8bYR!!QRB<\u0011\u001d\u0019y\u0005\u0017a\u0001\u0003{\f\u0001bZ3u':\f\u0007o\u001d\u000b\u0005\u0005\u001b\u001bi\bC\u0004\u0004Pe\u0003\r!!@\u0002\u000f%tG-\u001a=fgV\u001111\u0011\t\u0007\u0003\u0013\u001a)i!#\n\t\r\u001d\u0015Q\f\u0002\u0004'\u0016\f\b\u0003BA\u000f\u0007\u0017KAa!$\u0002\n\ti\u0011J\u001c3fqN+G\u000f^5oON\fAB[8ve:\fGnQ1dQ\u0016\u0004b!!\b\u0004\u0014\n5\u0015\u0002BBK\u0003\u0013\u0011A#T8oO>\u001cu\u000e\u001c7fGRLwN\\\"bG\",\u0017a\u00026pkJt\u0017\r\\\u000b\u0003\u0005\u001b#BA!$\u0004\u001e\"91qJ/A\u0002\u0005u\u0018\u0001\u0006:f[>4XMS8ve:\fG.\u00138DC\u000eDW\r\u0006\u0003\u0003f\u000e\r\u0006bBB(=\u0002\u0007\u0011Q`\u0001\u000bg:\f\u0007o]\"bG\",\u0017!B:oCB\u001cH\u0003\u0002BG\u0007WCqaa\u0014b\u0001\u0004\ti0\u0001\nsK6|g/Z*oCB\u001c\u0018J\\\"bG\",G\u0003\u0002Bs\u0007cCqaa\u0014c\u0001\u0004\ti0A\u0007sK\u0006dG/[7f\u0007\u0006\u001c\u0007.Z\u0001\te\u0016\fG\u000e^5nK\u0006\u0019\u0012/^3ssNKG-\u001a#jgB\fGo\u00195feV\u001111\u0018\t\u0005\u0007{\u001b\u0019-\u0004\u0002\u0004@*!1\u0011\u0019B\u000f\u0003!!\u0017n\u001d9bi\u000eD\u0017\u0002BBc\u0007\u007f\u0013\u0011#T3tg\u0006<W\rR5ta\u0006$8\r[3s\u0003Q\tX/\u001a:z'&$W\rR5ta\u0006$8\r[3sA\u0005iQ.\u001a;bI\u0006$\u0018mQ1dQ\u0016\f\u0001\"\\3uC\u0012\fG/Y\u0001\u001bkN,7+\u001e4gSb,GmQ8mY\u0016\u001cG/[8o\u001d\u0006lWm]\u000b\u0003\u0003G\u000bA\u0002Z1uC\n\f7/\u001a(b[\u0016,\"a!6\u0011\r\u0005\u001521CA\u007f\u0003M\u0019h.\u00199t\u0007>dG.Z2uS>tg*Y7f+\t\ti0\u0001\bt]\u0006\u00048/\u00138eKbt\u0015-\\3\u0002!Mt\u0017\r]:Xe&$XmU1gKRLXCABq!\r\u0019\u0019o\u0001\b\u0004\u0003;\u0001\u0011!D:oCB\u001cx\u000bV5nK>,H/\u0006\u0002\u0004jB!11^By\u001b\t\u0019iO\u0003\u0003\u0004p\nE\u0015\u0001\u00033ve\u0006$\u0018n\u001c8\n\t\rM8Q\u001e\u0002\u000f\r&t\u0017\u000e^3EkJ\fG/[8o\u0003)\u0019h.\u00199t\rNLhnY\u0001\u0016U>,(O\\1m\u0007>dG.Z2uS>tg*Y7f\u0003AQw.\u001e:oC2Le\u000eZ3y\u001d\u0006lW-A\u000bk_V\u0014h.\u00197TKFt%/\u00138eKbt\u0015-\\3\u0002')|WO\u001d8bYR\u000bw-\u00138eKbt\u0015-\\3\u0002%)|WO\u001d8bY^\u0013\u0018\u000e^3TC\u001a,G/_\u0001\u0010U>,(O\\1m/RKW.Z8vi\u0006a!n\\;s]\u0006dgi]=oG\u0006I\"/Z1mi&lW-\u00128bE2,\u0007+\u001a:tSN$XM\\2f\u0003Y\u0011X-\u00197uS6,7i\u001c7mK\u000e$\u0018n\u001c8OC6,\u0017A\u0006:fC2$\u0018.\\3D_2dWm\u0019;j_:\u001c\u0016N_3\u0016\u0005\u00115\u0001\u0003BA\u0013\t\u001fIA\u0001\"\u0005\u0002(\t!Aj\u001c8h\u0003YiW\r^1eCR\f7i\u001c7mK\u000e$\u0018n\u001c8OC6,\u0017!E7fi\u0006$\u0017\r^1J]\u0012,\u0007PT1nK\u0006AQn\u001c8h_V\u0013\u0018.\u0001\fvg\u0016dUmZ1dsN+'/[1mSj\fG/[8o\u0003a\u0019XO\u001a4jq\n+\u0018\u000e\u001c3fe\u000ec\u0017m]:PaRLwN\\\u0001\u0010gV4g-\u001b=TKB\f'/\u0019;pe\u0006y1/\u001e4gSb$%o\u001c9F[B$\u00180\u0001\neKN,'/[1mSj,'j\\;s]\u0006dG\u0003\u0002C\u0013\ts!B\u0001b\n\u0005.A!\u0011Q\u0004C\u0015\u0013\u0011!Y#!\u0003\u0003\u000b\u00153XM\u001c;\t\u0011\u0011=\u00121\u0001a\u0002\tc\t!!\u001a<\u0011\r\u0005uA1\u0007C\u001c\u0013\u0011!)$!\u0003\u0003+\r\u000bg\u000eR3tKJL\u0017\r\\5{K*{WO\u001d8bYB\u0019!1\u0014\u001c\t\u0011\u0011m\u00121\u0001a\u0001\to\t1\u0001\u001a2p\u0003A\u0019XM]5bY&TXMS8ve:\fG\u000e\u0006\u0003\u0005B\u0011-C\u0003\u0002C\u001c\t\u0007B\u0001\u0002b\f\u0002\u0006\u0001\u000fAQ\t\t\u0007\u0003;!9\u0005b\u000e\n\t\u0011%\u0013\u0011\u0002\u0002\u0014\u0007\u0006t7+\u001a:jC2L'0\u001a&pkJt\u0017\r\u001c\u0005\t\t\u001b\n)\u00011\u0001\u0005P\u0005\u0011\u0011m\u001e\t\u0005\u0003;!\t&\u0003\u0003\u0005T\u0005%!\u0001B!u_6\u0004")
public abstract class MongoPersistenceDriver
extends WithMongoPersistencePluginDispatcher {
    private MongoSettings settings;
    private Future<ServerVersion> mongoVersion;
    private Seq<IndexSettings> indexes;
    private final ActorSystem as;
    private final Config config;
    private final String DEFAULT_DB_NAME;
    private final Logger logger;
    private final ActorSystem actorSystem;
    private final Materializer materializer;
    private final Option<CanSuffixCollectionNames> canSuffixCollectionNamesBuilder;
    private final MongoCollectionCache<Future<Object>> journalCache;
    private final MongoCollectionCache<Future<Object>> snapsCache;
    private final MongoCollectionCache<Future<Object>> realtimeCache;
    private final MessageDispatcher querySideDispatcher;
    private final MongoCollectionCache<Future<Object>> metadataCache;
    private volatile byte bitmap$0;

    public static WriteSafety string2WriteSafety(String fromConfig) {
        return MongoPersistenceDriver$.MODULE$.string2WriteSafety(fromConfig);
    }

    public String DEFAULT_DB_NAME() {
        return this.DEFAULT_DB_NAME;
    }

    public Logger logger() {
        return this.logger;
    }

    public ActorSystem actorSystem() {
        return this.actorSystem;
    }

    public Materializer materializer() {
        return this.materializer;
    }

    private MongoSettings settings$lzycompute() {
        MongoPersistenceDriver mongoPersistenceDriver = this;
        synchronized (mongoPersistenceDriver) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                MongoSettings mongoSettings;
                MongoSettings defaults = MongoSettings$.MODULE$.apply(this.as.settings());
                Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> $this.config.getConfig("overrides"));
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    Config overrides = (Config)success.value();
                    this.logger().info("Applying configuration-specific overrides for driver");
                    mongoSettings = defaults.withOverride(overrides);
                } else if (try_ instanceof Failure) {
                    this.logger().debug("No configuration-specific overrides found to apply to driver");
                    mongoSettings = defaults;
                } else {
                    throw new MatchError((Object)try_);
                }
                this.settings = mongoSettings;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.settings;
    }

    public MongoSettings settings() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.settings$lzycompute();
        }
        return this.settings;
    }

    public abstract Future<Object> collection(String var1);

    public abstract Future<List<String>> collectionNames();

    public abstract Future<Object> ensureCollection(String var1);

    public abstract Future<Object> cappedCollection(String var1);

    public abstract Function1<Object, Future<Object>> ensureIndex(String var1, boolean var2, boolean var3, Seq<Tuple2<String, Object>> var4);

    public abstract Future<BoxedUnit> removeEmptyCollection(Object var1, String var2);

    public abstract void closeConnections();

    public abstract Future<String> getMongoVersionFromBuildInfo();

    private Future<ServerVersion> mongoVersion$lzycompute() {
        MongoPersistenceDriver mongoPersistenceDriver = this;
        synchronized (mongoPersistenceDriver) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.mongoVersion = this.getMongoVersionFromBuildInfo().map((Function1 & Serializable)x0$1 -> {
                    Option<ServerVersion> option;
                    String string = x0$1;
                    if (string != null && !(option = ServerVersion$.MODULE$.unapply(string)).isEmpty()) {
                        ServerVersion v = (ServerVersion)option.get();
                        return v;
                    }
                    return new ServerVersion.Unsupported(-1.0, "UNKNOWN");
                }, this.pluginDispatcher());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.mongoVersion;
    }

    public Future<ServerVersion> mongoVersion() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.mongoVersion$lzycompute();
        }
        return this.mongoVersion;
    }

    public Future<List<Object>> getAllCollectionsAsFuture(Option<Function1<String, Object>> nameFilter) {
        return this.collectionNames().flatMap((Function1 & Serializable)names -> Future$.MODULE$.sequence((IterableOnce)names.filterNot((Function1 & Serializable)name -> BoxesRunTime.boxToBoolean((boolean)this.excluded$1(name))).filter((Function1)nameFilter.getOrElse((Function0 & Serializable)() -> (Function1 & Serializable)name -> BoxesRunTime.boxToBoolean((boolean)MongoPersistenceDriver.allPass$1(name)))).map((Function1 & Serializable)name -> this.collection((String)name)), BuildFrom$.MODULE$.buildFromIterableOps(), this.pluginDispatcher()).map((Function1 & Serializable)list -> list, this.pluginDispatcher()), this.pluginDispatcher());
    }

    public Future<List<Object>> getCollectionsAsFuture(String collectionName) {
        return this.getAllCollectionsAsFuture((Option<Function1<String, Object>>)Option$.MODULE$.apply((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.startsWith(collectionName))));
    }

    public Future<List<Object>> getJournalCollections() {
        return this.getCollectionsAsFuture(this.journalCollectionName());
    }

    public Future<List<Object>> journalCollectionsAsFuture() {
        return this.getCollectionsAsFuture(this.journalCollectionName());
    }

    public Future<List<Object>> getSnapshotCollections() {
        return this.getCollectionsAsFuture(this.snapsCollectionName());
    }

    public Future<List<Object>> snapshotCollectionsAsFuture() {
        return this.getCollectionsAsFuture(this.snapsCollectionName());
    }

    public Future<BoxedUnit> removeEmptyJournal(Object jnl) {
        return this.removeEmptyCollection(jnl, this.journalIndexName());
    }

    public Future<BoxedUnit> removeEmptySnapshot(Object snp) {
        return this.removeEmptyCollection(snp, this.snapsIndexName());
    }

    private Option<CanSuffixCollectionNames> canSuffixCollectionNamesBuilder() {
        return this.canSuffixCollectionNamesBuilder;
    }

    private String getSuffixFromPersistenceId(String persistenceId) {
        Option<CanSuffixCollectionNames> option = this.canSuffixCollectionNamesBuilder();
        if (option instanceof Some) {
            Some some = (Some)option;
            CanSuffixCollectionNames builderIns = (CanSuffixCollectionNames)some.value();
            return builderIns.getSuffixFromPersistenceId(persistenceId);
        }
        return "";
    }

    private String validateMongoCharacters(String input) {
        Option<CanSuffixCollectionNames> option = this.canSuffixCollectionNamesBuilder();
        if (option instanceof Some) {
            Some some = (Some)option;
            CanSuffixCollectionNames builderIns = (CanSuffixCollectionNames)some.value();
            return builderIns.validateMongoCharacters(input);
        }
        return input;
    }

    private String appendSuffixToName(String nameInSettings, String suffix) {
        String string;
        block3: {
            String string2 = suffix;
            switch (string2 == null ? 0 : string2.hashCode()) {
                case 0: {
                    if (!"".equals(string2)) break;
                    string = nameInSettings;
                    break block3;
                }
            }
            string = new StringBuilder(0).append(nameInSettings).append(this.suffixSeparator()).append(this.validateMongoCharacters(suffix)).toString();
        }
        String name = string;
        this.logger().debug(new StringBuilder(58).append("Suffixed name for value \"").append(nameInSettings).append("\" in settings and suffix \"").append(suffix).append("\" is \"").append(name).append("\"").toString());
        return name;
    }

    public String getJournalCollectionName(String persistenceId) {
        String string = persistenceId;
        switch (string == null ? 0 : string.hashCode()) {
            case 0: {
                if (!"".equals(string)) break;
                return this.journalCollectionName();
            }
        }
        return this.appendSuffixToName(this.journalCollectionName(), this.getSuffixFromPersistenceId(persistenceId));
    }

    public String getSnapsCollectionName(String persistenceId) {
        String string = persistenceId;
        switch (string == null ? 0 : string.hashCode()) {
            case 0: {
                if (!"".equals(string)) break;
                return this.snapsCollectionName();
            }
        }
        return this.appendSuffixToName(this.snapsCollectionName(), this.getSuffixFromPersistenceId(persistenceId));
    }

    public Future<Object> getJournal(String persistenceId) {
        return this.collection(this.getJournalCollectionName(persistenceId));
    }

    public Future<Object> getSnaps(String persistenceId) {
        return this.collection(this.getSnapsCollectionName(persistenceId));
    }

    private Seq<IndexSettings> indexes$lzycompute() {
        MongoPersistenceDriver mongoPersistenceDriver = this;
        synchronized (mongoPersistenceDriver) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.indexes = new .colon.colon((Object)new IndexSettings(this.journalIndexName(), true, false, (Seq<Tuple2<String, Object>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pid"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"from"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"to"), (Object)BoxesRunTime.boxToInteger((int)1))})), (List)new .colon.colon((Object)new IndexSettings(this.journalSeqNrIndexName(), false, false, (Seq<Tuple2<String, Object>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pid"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"to"), (Object)BoxesRunTime.boxToInteger((int)-1))})), (List)new .colon.colon((Object)new IndexSettings(this.journalTagIndexName(), false, true, (Seq<Tuple2<String, Object>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"_tg"), (Object)BoxesRunTime.boxToInteger((int)1))})), (List)Nil$.MODULE$)));
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.indexes;
    }

    public Seq<IndexSettings> indexes() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.indexes$lzycompute();
        }
        return this.indexes;
    }

    public Future<Object> journal() {
        return this.journal("");
    }

    public Future<Object> journal(String persistenceId) {
        String collectionName = this.getJournalCollectionName(persistenceId);
        return this.journalCache.getOrElseCreate(collectionName, (Function1<String, Future<Object>>)(Function1 & Serializable)theCollectionName -> {
            Future<Object> journalCollection = this.ensureCollection((String)theCollectionName);
            return (Future)this.indexes().foldLeft(journalCollection, (Function2 & Serializable)(acc, index) -> acc.flatMap((Function1 & Serializable)x$2 -> (Future)this.ensureIndex(index.name(), index.unique(), index.sparse(), index.fields()).apply(x$2), this.pluginDispatcher()));
        });
    }

    public void removeJournalInCache(String persistenceId) {
        String collectionName = this.getJournalCollectionName(persistenceId);
        this.journalCache.invalidate(collectionName);
    }

    public Future<Object> snaps() {
        return this.snaps("");
    }

    public Future<Object> snaps(String persistenceId) {
        String collectionName = this.getSnapsCollectionName(persistenceId);
        return this.snapsCache.getOrElseCreate(collectionName, (Function1<String, Future<Object>>)(Function1 & Serializable)theCollectionName -> {
            Future<Object> snapsCollection = this.ensureCollection((String)theCollectionName);
            return snapsCollection.flatMap((Function1 & Serializable)x$3 -> (Future)this.ensureIndex(this.snapsIndexName(), true, false, (Seq<Tuple2<String, Object>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pid"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sn"), (Object)BoxesRunTime.boxToInteger((int)-1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ts"), (Object)BoxesRunTime.boxToInteger((int)-1))})).apply(x$3), this.pluginDispatcher());
        });
    }

    public void removeSnapsInCache(String persistenceId) {
        String collectionName = this.getSnapsCollectionName(persistenceId);
        this.snapsCache.invalidate(collectionName);
    }

    public Future<Object> realtime() {
        return this.realtimeCache.getOrElseCreate(this.realtimeCollectionName(), (Function1<String, Future<Object>>)(Function1 & Serializable)collectionName -> this.cappedCollection((String)collectionName));
    }

    public MessageDispatcher querySideDispatcher() {
        return this.querySideDispatcher;
    }

    public Future<Object> metadata() {
        return this.metadataCache.getOrElseCreate(this.metadataCollectionName(), (Function1<String, Future<Object>>)(Function1 & Serializable)collectionName -> {
            Future<Object> metadataCollection = this.ensureCollection((String)collectionName);
            return metadataCollection.flatMap((Function1 & Serializable)x$4 -> (Future)this.ensureIndex(this.metadataIndexName(), true, true, (Seq<Tuple2<String, Object>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pid"), (Object)BoxesRunTime.boxToInteger((int)1))})).apply(x$4), this.pluginDispatcher());
        });
    }

    public boolean useSuffixedCollectionNames() {
        return this.suffixBuilderClassOption().isDefined();
    }

    public Option<String> databaseName() {
        return this.settings().Database();
    }

    public String snapsCollectionName() {
        return this.settings().SnapsCollection();
    }

    public String snapsIndexName() {
        return this.settings().SnapsIndex();
    }

    public WriteSafety snapsWriteSafety() {
        return MongoPersistenceDriver$.MODULE$.string2WriteSafety(this.settings().SnapsWriteConcern());
    }

    public FiniteDuration snapsWTimeout() {
        return this.settings().SnapsWTimeout();
    }

    public boolean snapsFsync() {
        return this.settings().SnapsFSync();
    }

    public String journalCollectionName() {
        return this.settings().JournalCollection();
    }

    public String journalIndexName() {
        return this.settings().JournalIndex();
    }

    public String journalSeqNrIndexName() {
        return this.settings().JournalSeqNrIndex();
    }

    public String journalTagIndexName() {
        return this.settings().JournalTagIndex();
    }

    public WriteSafety journalWriteSafety() {
        return MongoPersistenceDriver$.MODULE$.string2WriteSafety(this.settings().JournalWriteConcern());
    }

    public FiniteDuration journalWTimeout() {
        return this.settings().JournalWTimeout();
    }

    public boolean journalFsync() {
        return this.settings().JournalFSync();
    }

    public boolean realtimeEnablePersistence() {
        return this.settings().realtimeEnablePersistence();
    }

    public String realtimeCollectionName() {
        return this.settings().realtimeCollectionName();
    }

    public long realtimeCollectionSize() {
        return this.settings().realtimeCollectionSize();
    }

    public String metadataCollectionName() {
        return this.settings().MetadataCollection();
    }

    public String metadataIndexName() {
        return this.settings().MetadataIndex();
    }

    public String mongoUri() {
        return this.settings().MongoUri();
    }

    public boolean useLegacySerialization() {
        return this.settings().UseLegacyJournalSerialization();
    }

    public Option<String> suffixBuilderClassOption() {
        return Option$.MODULE$.apply((Object)this.settings().SuffixBuilderClass()).filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$5.trim()))));
    }

    public String suffixSeparator() {
        String string = this.settings().SuffixSeparator();
        switch (string == null ? 0 : string.hashCode()) {
            default: 
        }
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(string))) {
            return this.validateMongoCharacters(this.settings().SuffixSeparator()).substring(0, 1);
        }
        return "_";
    }

    public boolean suffixDropEmpty() {
        return this.settings().SuffixDropEmptyCollections();
    }

    public Event deserializeJournal(Object dbo, CanDeserializeJournal<Object> ev) {
        return ev.deserializeDocument(dbo);
    }

    public Object serializeJournal(Atom aw, CanSerializeJournal<Object> ev) {
        return ev.serializeAtom(aw);
    }

    private final boolean excluded$1(String name) {
        String string = name;
        String string2 = this.metadataCollectionName();
        return !(string == null ? string2 != null : !string.equals(string2)) || name.startsWith("system.");
    }

    private static final boolean allPass$1(String name) {
        return true;
    }

    public MongoPersistenceDriver(ActorSystem as, Config config) {
        None$ none$;
        Some some;
        String suffixBuilderClass;
        this.as = as;
        this.config = config;
        super(as, config);
        this.DEFAULT_DB_NAME = "pekko-persistence";
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.actorSystem = as;
        this.materializer = Materializer$.MODULE$.apply((ClassicActorSystemProvider)as);
        as.registerOnTermination((Function0)(JFunction0.mcV.sp & Serializable)() -> this.closeConnections());
        Option<String> option = this.suffixBuilderClassOption();
        if (option instanceof Some && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((suffixBuilderClass = (String)(some = (Some)option).value()).trim()))) {
            ReflectiveLookupExtension reflectiveAccess = (ReflectiveLookupExtension)ReflectiveLookupExtension$.MODULE$.apply(this.actorSystem());
            Class builderClass = reflectiveAccess.unsafeReflectClassByName(suffixBuilderClass, ClassTag$.MODULE$.apply(CanSuffixCollectionNames.class));
            Constructor builderCons = builderClass.getConstructor(new Class[0]);
            none$ = new Some(builderCons.newInstance(new Object[0]));
        } else {
            none$ = None$.MODULE$;
        }
        this.canSuffixCollectionNamesBuilder = none$;
        this.journalCache = MongoCollectionCache$.MODULE$.apply(this.settings().CollectionCache(), "journal", this.actorSystem());
        this.snapsCache = MongoCollectionCache$.MODULE$.apply(this.settings().CollectionCache(), "snaps", this.actorSystem());
        this.realtimeCache = MongoCollectionCache$.MODULE$.apply(this.settings().CollectionCache(), "realtime", this.actorSystem());
        this.querySideDispatcher = this.actorSystem().dispatchers().lookup("pekko-contrib-persistence-query-dispatcher");
        this.metadataCache = MongoCollectionCache$.MODULE$.apply(this.settings().CollectionCache(), "metadata", this.actorSystem());
    }

    public static interface WriteSafety {
    }
}

